/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress.views;

import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.progress.ProgressController;
import com.nokia.widgets.progress.models.ModelBase;
import com.nokia.widgets.progress.models.ProgressModel;
import com.nokia.widgets.progress.views.AbstractProgressDialog;
import com.nokia.widgets.progress.views.GuiListener;
import com.nokia.widgets.progress.views.ProgressGuiEvent;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public abstract class AbstractProgressUI
extends JComponent
implements Observer,
ActionListener,
Accessible {
    public static final String EVENT_FULL_UI_REBUILD = "fulluirebuild";
    protected static final String INDETERMINATED_ANIMATION_FILE_FORWARD = "/com/nokia/laf/icons/s_ot2_progress-verification_spinner36.gif";
    protected static final String INDETERMINATED_ANIMATION_FILE_REVERSE = "/com/nokia/laf/icons/s_ot2_progress-verification_spinner36.gif";
    protected static final String INDETERMINATED_ANIMATION_FILE_STOPPED = "/com/nokia/widgets/res/s_ot2_spinner_static.png";
    protected static final int LARGE_COMPONENT_GAP = 12;
    protected static final int SMALL_COMPONENT_GAP = 6;
    protected List myFullRebuildRequiredKeys;
    protected ProgressController myController;
    protected ProgressModel myModel;
    protected JLabel myElapsedTimeLabel;
    protected JLabel myElapsedTimeValueLabel;
    protected JLabel myDurationValueLabel;
    protected JLabel myDurationLabel;
    protected PButton myActionButton;
    protected Set<GuiListener> myGuiListeners;
    protected String myCurrentAction;
    protected ImageIcon myForwardAnimation;
    protected ImageIcon myReverseAnimation;
    protected ImageIcon myStoppedAnimation;
    protected ImageIcon myDisabledAnimation;
    protected transient boolean myUIRebuildRequired = false;
    protected JLabel myAnimationLabel = new JLabel();

    public AbstractProgressUI(ProgressController controller) {
        this.setDoubleBuffered(true);
        this.myAnimationLabel.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 12));
        this.myController = controller;
        this.myGuiListeners = new LinkedHashSet<GuiListener>();
        this.myFullRebuildRequiredKeys = new ArrayList();
        this.myFullRebuildRequiredKeys.add("timefieldvisible");
        this.myFullRebuildRequiredKeys.add("showaction");
        this.myFullRebuildRequiredKeys.add("showduration");
        this.initComponents();
    }

    protected void initComponents() {
        this.myDurationLabel = PLabel.createSystemText(WidgetResources.getString("ProgressDialog.EstimatedDuration"));
        this.myDurationValueLabel = PLabel.createValueText("     ");
        this.myElapsedTimeLabel = PLabel.createSystemText(WidgetResources.getString("ProgressDialog.ElapsedTime"));
        this.myElapsedTimeValueLabel = PLabel.createValueText("-");
        this.myElapsedTimeValueLabel.setName("ElapsedTime");
        this.myDurationValueLabel.setName("DurationValue");
        this.myActionButton = new PButton("Action");
        this.myActionButton.addActionListener(this);
    }

    protected void initUI() {
        this.removeAll();
        this.updateDurationText();
        this.updateAnimationLabel();
    }

    public void setModel(ProgressModel model) {
        if (model == null || model == this.myModel) {
            return;
        }
        if (this.myModel != null) {
            this.myModel.deleteObserver(this);
        }
        this.myModel = model;
        this.initUI();
        this.myModel.addObserver(this);
    }

    public void startElapsedTimeTimer() {
        this.myModel.startElapsedTimeTimer();
    }

    public void stopElapsedTimeTimer() {
        this.myModel.stopElapsedTimeTimer();
    }

    public boolean isTimerStarted() {
        return this.myModel.isTimerStarted();
    }

    public void addGuiListener(GuiListener listener) {
        this.myGuiListeners.add(listener);
    }

    public void removeGuiListener(GuiListener listener) {
        this.myGuiListeners.remove(listener);
    }

    public void destroy() {
        this.myModel.deleteObserver(this);
    }

    public JLabel getTimeLabel() {
        return this.myElapsedTimeValueLabel;
    }

    public JLabel getAnimationLabel() {
        return this.myAnimationLabel;
    }

    public void updateTime() {
        int elapsedSeconds = this.myModel.getElapsedTime();
        int hours = elapsedSeconds / 3600;
        int minutes = elapsedSeconds / 60;
        if (hours > 0) {
            minutes %= 60;
        }
        int seconds = elapsedSeconds % 60;
        String hoursStr = hours < 10 ? "0" + hours : String.valueOf(hours);
        String minutesStr = minutes < 10 ? "0" + minutes : String.valueOf(minutes);
        String secondsStr = seconds < 10 ? "0" + seconds : String.valueOf(seconds);
        String elapsedTime = String.valueOf(minutesStr) + ":" + secondsStr;
        if (hours > 0) {
            elapsedTime = String.valueOf(hoursStr) + ":" + elapsedTime;
        }
        if ("00:00".equals(elapsedTime)) {
            if (this.myModel.getProgressState() == 2) {
                elapsedTime = "-";
            } else if (this.myModel.getProgressState() == 1) {
                elapsedTime = "00:01";
            }
        }
        this.myElapsedTimeValueLabel.setText(elapsedTime);
    }

    protected void updateActionButton() {
        this.myCurrentAction = this.myModel.getCurrentAction();
        if ("cancelaction".equals(this.myCurrentAction)) {
            this.myActionButton.setText(WidgetResources.getString("CancelAction_Text"));
        } else if ("startaction".equals(this.myCurrentAction)) {
            this.myActionButton.setText(WidgetResources.getString("StartAction_Text"));
            this.myActionButton.setMnemonic(WidgetResources.getMnemonic("StartAction_Mnemonic"));
        } else if ("stopaction".equals(this.myCurrentAction)) {
            this.myActionButton.setText(WidgetResources.getString("StopAction_Text"));
            this.myActionButton.setMnemonic(WidgetResources.getMnemonic("StopAction_Mnemonic"));
        }
        this.myActionButton.setPreferredSize(this.myActionButton.getMinimumSize());
        this.myActionButton.setEnabled(this.myModel.isActionButtonEnabled());
    }

    public void setActionButtonDefault(boolean isDefault) {
        this.myActionButton.setDefaultButton(isDefault);
    }

    public void setFocusOnActionButton() {
        this.myActionButton.requestFocus();
    }

    protected void loadAnimationFiles() {
        this.myReverseAnimation = this.myForwardAnimation = CommonIcons.getProgressOngoingIcon40();
        this.myStoppedAnimation = new ImageIcon(ImageUtils.createEmptyImage(36, 36));
        this.myDisabledAnimation = new ImageIcon(ImageUtils.createEmptyImage(36, 36));
        this.myAnimationLabel = new JLabel();
        this.myAnimationLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 12));
    }

    protected void updateData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractProgressUI.this.updateTime();
                if (AbstractProgressUI.this.myUIRebuildRequired) {
                    AbstractProgressUI.this.myUIRebuildRequired = false;
                    AbstractProgressUI.this.initUI();
                    if (SwingUtilities.getWindowAncestor(AbstractProgressUI.this) != null) {
                        SwingUtilities.getWindowAncestor(AbstractProgressUI.this).invalidate();
                    }
                    AbstractProgressUI.this.fireGuiEvent(new ProgressGuiEvent(AbstractProgressUI.EVENT_FULL_UI_REBUILD));
                }
                if (AbstractProgressUI.this.myModel.isActionButtonVisible()) {
                    AbstractProgressUI.this.updateActionButton();
                }
                AbstractProgressUI.this.updateDurationText();
                AbstractProgressUI.this.updateAnimationLabel();
            }
        });
    }

    protected void updateDurationText() {
        this.myDurationValueLabel.setText(this.myModel.getEstimatedDuration());
    }

    protected void updateAnimationLabel() {
        if (this.myAnimationLabel == null) {
            return;
        }
        this.myElapsedTimeValueLabel.setEnabled(true);
        if (this.myModel.getProgressState() == 0) {
            int dir = this.myModel.getIndeterminatedAnimationDirection();
            if (dir == 0) {
                this.myAnimationLabel.setIcon(this.myForwardAnimation);
            } else if (dir == 1) {
                this.myAnimationLabel.setIcon(this.myReverseAnimation);
            }
        } else if (this.myModel.getProgressState() == 1 || this.myModel.getProgressState() == 3) {
            this.myAnimationLabel.setIcon(this.myStoppedAnimation);
        } else {
            this.myAnimationLabel.setIcon(this.myDisabledAnimation);
            this.myElapsedTimeValueLabel.setEnabled(false);
        }
    }

    protected void fireGuiEvent(ProgressGuiEvent event) {
        Iterator<GuiListener> it = this.myGuiListeners.iterator();
        while (it.hasNext()) {
            it.next().guiUpdated(event);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this);
        if (this.myFullRebuildRequiredKeys.contains(((ModelBase)o).getLastUpdatedKey()) || parentWindow instanceof AbstractProgressDialog && !parentWindow.isVisible()) {
            this.myUIRebuildRequired = true;
        }
        this.updateData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myActionButton) {
            this.fireGuiEvent(new ProgressGuiEvent(this.myCurrentAction));
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAbstractProgressUI();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAbstractProgressUI
    extends JComponent.AccessibleJComponent {
        protected AccessibleAbstractProgressUI() {
            super(AbstractProgressUI.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }
    }
}

