/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress.views;

import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.progress.ProgressDialogController;
import com.nokia.widgets.progress.views.AbstractProgressDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ProgressBarDialog
extends AbstractProgressDialog
implements ActionListener {
    protected JLabel myDetailedMessage;

    public ProgressBarDialog(Window parentWindow, ProgressDialogController progressController) {
        super(parentWindow, progressController);
    }

    @Override
    protected void initUI() {
        super.initUI();
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.ipady = 10;
        gbc.weighty = 100.0;
        gbc.weightx = 0.0;
        Image icon = this.myModel.getTopLeftIcon();
        if (icon != null) {
            gbc.insets = new Insets(12, 6, 0, 0);
            upperPanel.add((Component)new JLabel(new ImageIcon(icon)), gbc);
            gbc.insets = new Insets(12, 6, 0, 18);
        } else {
            gbc.insets = new Insets(12, 18, 0, 18);
        }
        gbc.weightx = 100.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        if (this.myModel.getHeadingText().length() > 0) {
            upperPanel.add((Component)this.myHeading, gbc);
            ++gbc.gridy;
        }
        this.myDetailedMessage = PLabel.createValueText();
        this.myDetailedMessage.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        String detailsMessage = this.myModel.getDetailMessage();
        if (detailsMessage.length() > 0) {
            this.myDetailedMessage.setText(detailsMessage);
            upperPanel.add((Component)this.myDetailedMessage, gbc);
            ++gbc.gridy;
        }
        gbc.insets = icon != null ? new Insets(12, 6, 12, 18) : new Insets(12, 18, 12, 18);
        upperPanel.add((Component)this.myController.getProgressController().getView(), gbc);
        this.getContentPane().add((Component)upperPanel, "Center");
        this.setResizable(false);
        this.pack();
    }

    @Override
    protected void updateUI() {
        super.updateUI();
        this.myDetailedMessage.setText(this.myModel.getDetailMessage());
    }
}

