/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress.views;

import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PMatrixLayout;
import com.nokia.widgets.layout.PVerticalLayout;
import com.nokia.widgets.progress.ProgressController;
import com.nokia.widgets.progress.models.ProgressBarModel;
import com.nokia.widgets.progress.views.AbstractProgressUI;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressBarUI
extends AbstractProgressUI
implements ActionListener {
    protected JProgressBar myProgressBar;
    protected JLabel myIndeterminatedText;
    protected ProgressBarModel myProgressBarModel;

    public ProgressBarUI(ProgressController controller) {
        super(controller);
        this.myFullRebuildRequiredKeys.add("animation");
    }

    @Override
    protected void initUI() {
        Object stringPaintedOnTrack = Boolean.TRUE;
        if (this.myProgressBar != null) {
            stringPaintedOnTrack = this.myProgressBar.getClientProperty("OrangeTouch.stringPaintedOnTrack");
        }
        super.initUI();
        this.myProgressBarModel = (ProgressBarModel)this.myController.getModel();
        this.setLayout(new BorderLayout());
        if (this.myProgressBarModel.isIndeterminatedAnimationUsed()) {
            this.loadAnimationFiles();
            this.createIndeterminatedAnimationUI();
        } else {
            this.createDeterminatedUI();
            if (this.myProgressBar != null) {
                this.myProgressBar.putClientProperty("OrangeTouch.stringPaintedOnTrack", stringPaintedOnTrack);
            }
        }
        if (this.myProgressBar != null) {
            this.setAccessibleInfo();
        }
        this.updateTime();
        this.updateData();
        this.revalidate();
    }

    public void setStringPaintedOnTrack(boolean stringPaintedOnTrack) {
        this.myProgressBar.putClientProperty("OrangeTouch.stringPaintedOnTrack", stringPaintedOnTrack);
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = super.isEnabled();
        if (oldEnabled == enabled) {
            return;
        }
        super.setEnabled(enabled);
        if (this.myProgressBar != null) {
            this.myProgressBar.setEnabled(enabled);
        }
        if (this.myElapsedTimeLabel != null) {
            this.myElapsedTimeLabel.setEnabled(enabled);
        }
        if (this.myElapsedTimeValueLabel != null) {
            this.myElapsedTimeValueLabel.setEnabled(enabled);
        }
        if (this.myDurationLabel != null) {
            this.myDurationLabel.setEnabled(enabled);
        }
        if (this.myDurationValueLabel != null) {
            this.myDurationValueLabel.setEnabled(enabled);
        }
        if (this.myProgressBarModel.isIndeterminatedAnimationUsed()) {
            if (!enabled) {
                this.myAnimationLabel.setIcon(this.myDisabledAnimation);
            } else {
                this.myAnimationLabel.setIcon(this.myStoppedAnimation);
            }
        }
    }

    protected void createDeterminatedUI() {
        Box progressBox = Box.createHorizontalBox();
        this.myProgressBar = new JProgressBar();
        progressBox.add(this.myProgressBar);
        if (this.myProgressBarModel.isActionButtonVisible()) {
            progressBox.add(Box.createHorizontalStrut(12));
            progressBox.add(this.myActionButton);
            this.updateActionButton();
        }
        Box labelBox = Box.createVerticalBox();
        Box valueBox = Box.createVerticalBox();
        Box timesBox = Box.createHorizontalBox();
        if (this.myProgressBarModel.isEstimatedDurationVisible()) {
            labelBox.add(this.myDurationLabel);
            valueBox.add(this.myDurationValueLabel);
        }
        if (this.myProgressBarModel.isTimeFieldVisible()) {
            if (this.myProgressBarModel.isEstimatedDurationVisible()) {
                labelBox.add(Box.createRigidArea(new Dimension(0, 6)));
                valueBox.add(Box.createRigidArea(new Dimension(0, 6)));
            }
            labelBox.add(this.myElapsedTimeLabel);
            valueBox.add(this.myElapsedTimeValueLabel);
        }
        labelBox.add(Box.createVerticalGlue());
        valueBox.add(Box.createVerticalGlue());
        timesBox.add(labelBox);
        timesBox.add(Box.createHorizontalStrut(6));
        timesBox.add(valueBox);
        timesBox.add(Box.createHorizontalGlue());
        Box contentBox = Box.createVerticalBox();
        contentBox.add(progressBox);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(timesBox);
        this.add((Component)contentBox, "Center");
        this.setEnabled(this.myProgressBarModel.getProgressState() != 2);
    }

    protected void createIndeterminatedAnimationUI() {
        PVerticalLayout verticalLayout = new PVerticalLayout(4, 3, 6, 6);
        verticalLayout.setHMargin(0);
        JPanel verticalBox = new JPanel(verticalLayout);
        Box contentBox = Box.createHorizontalBox();
        this.updateAnimationLabel();
        this.myIndeterminatedText = PLabel.createValueText(this.myProgressBarModel.getProgressText());
        this.myIndeterminatedText.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        verticalBox.add(this.myIndeterminatedText);
        if (this.myProgressBarModel.isTimeFieldVisible() || this.myProgressBarModel.isEstimatedDurationVisible()) {
            this.myProgressBar = new JProgressBar();
            this.myProgressBar.setPreferredSize(new Dimension(170, 15));
            this.myProgressBar.setIndeterminate(this.myProgressBarModel.isIndeterminated());
            this.myProgressBar.setEnabled(false);
            contentBox.add(this.myProgressBar);
        } else {
            contentBox.add(this.myAnimationLabel);
        }
        if (this.myProgressBarModel.isActionButtonVisible()) {
            contentBox.add(Box.createHorizontalStrut(12));
            contentBox.add(this.myActionButton);
            this.updateActionButton();
        }
        contentBox.add(Box.createHorizontalGlue());
        verticalBox.add(contentBox);
        PMatrixLayout layout = new PMatrixLayout(2, 12, 0, 0, 0);
        layout.setMatrixHorizontalAlignment(4);
        JPanel textPanel = new JPanel(layout);
        if (this.myProgressBarModel.isEstimatedDurationVisible() && this.myProgressBarModel.isEstimatedDurationSetByClient()) {
            textPanel.add(this.myDurationLabel);
            textPanel.add(this.myDurationValueLabel);
        }
        if (this.myProgressBarModel.isTimeFieldVisible()) {
            textPanel.add(this.myElapsedTimeLabel);
            textPanel.add(this.myElapsedTimeValueLabel);
        }
        if (this.myProgressBarModel.isEstimatedDurationVisible() || this.myProgressBarModel.isTimeFieldVisible()) {
            verticalBox.add(textPanel);
        }
        this.add((Component)verticalBox, "Center");
    }

    @Override
    protected void updateAnimationLabel() {
        super.updateAnimationLabel();
        if (this.myProgressBar == null || this.myProgressBarModel == null || !this.myProgressBarModel.isIndeterminatedAnimationUsed()) {
            return;
        }
        if (this.myIndeterminatedText != null) {
            this.myIndeterminatedText.setVisible(!"".equals(this.myIndeterminatedText.getText()));
        }
        if (this.myProgressBarModel.getProgressState() == 0) {
            this.myProgressBar.setIndeterminate(true);
            this.myProgressBar.setEnabled(true);
        } else if (this.myProgressBarModel.getProgressState() == 1) {
            this.myProgressBar.setIndeterminate(false);
            this.myProgressBar.setValue(this.myProgressBar.getMaximum());
        } else if (this.myProgressBarModel.getProgressState() == 3) {
            this.myProgressBar.setIndeterminate(false);
            this.myProgressBar.setValue(0);
        } else {
            this.myProgressBar.setIndeterminate(false);
            this.myProgressBar.setValue(0);
        }
    }

    @Override
    protected void updateData() {
        super.updateData();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarUI.this.myProgressBarModel.isIndeterminatedAnimationUsed()) {
                    ProgressBarUI.this.updateAnimationLabel();
                    if (ProgressBarUI.this.myIndeterminatedText != null && ProgressBarUI.this.myProgressBarModel != null) {
                        ProgressBarUI.this.myIndeterminatedText.setText(ProgressBarUI.this.myProgressBarModel.getProgressText());
                    }
                } else if (ProgressBarUI.this.myProgressBarModel.isIndeterminated()) {
                    ProgressBarUI.this.myProgressBar.setIndeterminate(ProgressBarUI.this.myProgressBarModel.getProgressState() == 0);
                    ProgressBarUI.this.myProgressBar.setStringPainted(ProgressBarUI.this.myProgressBarModel.isProgressTextVisible());
                    ProgressBarUI.this.myProgressBar.setString(ProgressBarUI.this.myProgressBarModel.getProgressText());
                    ProgressBarUI.this.myProgressBar.putClientProperty("OrangeTouch.stringPaintedOnTrack", ProgressBarUI.this.myProgressBarModel.isStringPaintedOnTrack());
                    if (ProgressBarUI.this.myProgressBarModel.getProgressState() == 2 || ProgressBarUI.this.myProgressBarModel.getProgressState() == 3) {
                        ProgressBarUI.this.myProgressBar.setValue(ProgressBarUI.this.myProgressBar.getMinimum());
                    } else {
                        ProgressBarUI.this.myProgressBar.setValue(ProgressBarUI.this.myProgressBar.getMaximum());
                    }
                } else {
                    ProgressBarUI.this.myProgressBar.putClientProperty("OrangeTouch.stringPaintedOnTrack", ProgressBarUI.this.myProgressBarModel.isStringPaintedOnTrack());
                    int minValue = ProgressBarUI.this.myProgressBarModel.getMinimumValue();
                    int maxValue = ProgressBarUI.this.myProgressBarModel.getMaximumValue();
                    int curValue = ProgressBarUI.this.myProgressBarModel.getCurrentValue();
                    ProgressBarUI.this.myProgressBar.setMinimum(minValue);
                    ProgressBarUI.this.myProgressBar.setMaximum(maxValue);
                    ProgressBarUI.this.myProgressBar.setValue(curValue);
                    ProgressBarUI.this.myProgressBar.setStringPainted(ProgressBarUI.this.myProgressBarModel.isProgressTextVisible());
                    if (ProgressBarUI.this.myProgressBarModel.isProgressTextVisible()) {
                        String progressText = ProgressBarUI.this.myProgressBarModel.getProgressText();
                        if (progressText == null || progressText.length() == 0) {
                            progressText = String.valueOf(String.valueOf((int)((float)curValue / (float)maxValue * 100.0f))) + "%";
                        }
                        ProgressBarUI.this.myProgressBar.setString(progressText);
                    }
                }
                if (ProgressBarUI.this.myProgressBarModel != null) {
                    ProgressBarUI.this.setEnabled(ProgressBarUI.this.myProgressBarModel.getProgressState() != 2);
                }
                ProgressBarUI.this.repaint();
            }
        });
    }

    private void setAccessibleInfo() {
        this.myProgressBar.getAccessibleContext().setAccessibleName(WidgetResources.getString("ProgressBar.Default.AcessibleName"));
        this.myProgressBar.getAccessibleContext().setAccessibleDescription(WidgetResources.getString("ProgressBar.Default.AccessibleDescription"));
    }

    public AccessibleContext getProgressBarAccessibleContext() {
        return this.myProgressBar == null ? null : this.myProgressBar.getAccessibleContext();
    }
}

