/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress.views;

import com.nokia.widgets.balloon.Balloon;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.progress.ProgressController;
import com.nokia.widgets.progress.models.StepProgressModel;
import com.nokia.widgets.progress.models.StepProgressTask;
import com.nokia.widgets.progress.views.AbstractProgressUI;
import com.nokia.widgets.progress.views.ProgressGuiEvent;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StepProgressUI
extends AbstractProgressUI {
    public static final String EVENT_STARTED_TASK_ANIMATION_UPDATE = "startedtaskanimationupdate";
    public static final int VISIBLE_STEPS_IN_SCROLLING = 17;
    protected static final int STEP_TASK_INDENTATION_IN_PIXELS = 22;
    protected static final int DOWN_PANEL_HEIGHT_IN_PIXELS = 55;
    protected Map myTaskIcons;
    protected List myIconLabels = new ArrayList();
    protected JPanel myTaskPanel;
    protected JPanel myLowerPanel;
    protected String myCurrentStepID;
    protected int myCurrentStepIndex;
    protected ImageIcon myDownArrow;
    protected ImageIcon myUpArrow;
    protected Map myAttachedBalloons = new HashMap();
    protected StepProgressModel myStepProgressModel;
    protected boolean myNewBalloonAttached = false;
    private int myPreferredHeight = -1;

    public StepProgressUI(ProgressController controller) {
        super(controller);
        this.myTaskIcons = new HashMap();
        this.myDownArrow = WidgetResources.getImageIcon("ProgressArrow.down");
        this.myUpArrow = WidgetResources.getImageIcon("ProgressArrow.up");
        this.initComponents();
        this.loadAnimationFiles();
        this.myTaskIcons.put(0, CommonIcons.getProgressUpcomingIcon());
        this.myTaskIcons.put(1, CommonIcons.getProgressOngoingIcon());
        this.myTaskIcons.put(3, CommonIcons.getProgressSuccessIcon());
        this.myTaskIcons.put(2, CommonIcons.getProgressSkippedIcon());
        this.myTaskIcons.put(4, CommonIcons.getProgressFailedIcon());
        this.myTaskIcons.put(5, CommonIcons.getProgressCompletedWithErrorsIcon());
        this.myTaskIcons.put(6, CommonIcons.getProgressSkippedIcon());
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.myTaskPanel = new JPanel();
        this.myTaskPanel.setOpaque(false);
        this.myTaskPanel.setDoubleBuffered(true);
        this.myTaskPanel.setLayout(new BoxLayout(this.myTaskPanel, 1));
    }

    @Override
    protected void initUI() {
        super.initUI();
        this.myStepProgressModel = (StepProgressModel)this.myController.getModel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.myTaskPanel, "Center");
        this.drawProgressTasks(0);
        this.myLowerPanel = new JPanel();
        this.myLowerPanel.setOpaque(false);
        this.myLowerPanel.setLayout(new BoxLayout(this.myLowerPanel, 0));
        Box contentBox = Box.createHorizontalBox();
        Box labelBox = Box.createVerticalBox();
        Box valueBox = Box.createVerticalBox();
        if (this.myStepProgressModel.isEstimatedDurationVisible()) {
            labelBox.add(this.myDurationLabel);
            valueBox.add(this.myDurationValueLabel);
        }
        if (this.myStepProgressModel.isTimeFieldVisible()) {
            labelBox.add(Box.createRigidArea(new Dimension(0, 6)));
            valueBox.add(Box.createRigidArea(new Dimension(0, 6)));
            this.myElapsedTimeValueLabel.setBorder(this.myElapsedTimeLabel.getBorder());
            labelBox.add(this.myElapsedTimeLabel);
            valueBox.add(this.myElapsedTimeValueLabel);
        }
        labelBox.add(Box.createVerticalGlue());
        valueBox.add(Box.createVerticalGlue());
        contentBox.add(labelBox);
        contentBox.add(Box.createHorizontalStrut(6));
        contentBox.add(valueBox);
        contentBox.add(Box.createHorizontalGlue());
        Box buttonBox = Box.createVerticalBox();
        if (this.myStepProgressModel.isActionButtonVisible()) {
            buttonBox.add(Box.createRigidArea(new Dimension(0, 2)));
            buttonBox.add(this.myActionButton);
            buttonBox.add(Box.createVerticalGlue());
            contentBox.add(buttonBox);
        }
        if (this.myStepProgressModel.isActionButtonVisible() || this.myStepProgressModel.isEstimatedDurationVisible() || this.myStepProgressModel.isTimeFieldVisible()) {
            int width = Math.max(this.myTaskPanel.getPreferredSize().width, this.myDurationLabel.getMinimumSize().width + this.myDurationValueLabel.getMinimumSize().width) + 12;
            if (this.myPreferredHeight <= -1) {
                this.myLowerPanel.setMinimumSize(new Dimension(width, 55));
            } else {
                this.myLowerPanel.setMinimumSize(new Dimension(width, this.myPreferredHeight));
            }
            this.myLowerPanel.setPreferredSize(this.myLowerPanel.getMinimumSize());
        }
        this.myLowerPanel.add(contentBox);
        this.add((Component)this.myLowerPanel, "South");
        this.updateTime();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.closeBalloons();
    }

    public void attachBalloon(String stepID, Balloon balloonWidget) {
        this.myAttachedBalloons.put(stepID, balloonWidget);
        this.myNewBalloonAttached = true;
        this.updateData();
        balloonWidget.showBalloon();
    }

    public void attachBalloon(String stepID, String title, String message, int type) {
        Balloon balloonWidget = new Balloon(this.myTaskPanel, SwingUtilities.getWindowAncestor(this), message, title, type);
        this.attachBalloon(stepID, balloonWidget);
    }

    public void attachBalloon(String stepID, String title, String message, int type, Action action) {
        Balloon balloon = new Balloon(this.myTaskPanel, SwingUtilities.getWindowAncestor(this), message, title, type);
        balloon.setAction(action);
        this.attachBalloon(stepID, balloon);
    }

    public void closeBalloons() {
        Iterator it = this.myAttachedBalloons.values().iterator();
        while (it.hasNext()) {
            ((Balloon)it.next()).close();
        }
        this.myAttachedBalloons.clear();
    }

    public void setPreferredHeight(int preferredHeight) {
        this.myPreferredHeight = preferredHeight;
    }

    protected void drawProgressTasks(int startIndex) {
        int tempStartIndex = startIndex;
        this.myTaskPanel.removeAll();
        if (tempStartIndex == -1) {
            tempStartIndex = 0;
        }
        this.myIconLabels.clear();
        JLabel emptyLabel = new JLabel("");
        emptyLabel.setPreferredSize(new Dimension(this.myUpArrow.getIconWidth(), this.myUpArrow.getIconHeight()));
        List<StepProgressTask> steps = this.myStepProgressModel.getAllSteps();
        int endIndex = steps.size();
        if (endIndex == 0) {
            return;
        }
        if (this.myStepProgressModel.isScrollingUsed()) {
            if (tempStartIndex + 17 > steps.size()) {
                tempStartIndex = steps.size() - 17;
            }
            endIndex = tempStartIndex + 17;
        }
        boolean onBeginning = tempStartIndex == 0;
        boolean onEnd = tempStartIndex >= steps.size() - 17;
        this.myTaskPanel.add(Box.createVerticalGlue());
        if (this.myStepProgressModel.isScrollingUsed() && steps.size() > 17) {
            Box upArrowBox = Box.createHorizontalBox();
            upArrowBox.add(onBeginning ? emptyLabel : new JLabel(this.myUpArrow));
            upArrowBox.add(Box.createHorizontalGlue());
            this.myTaskPanel.add(upArrowBox);
        }
        int i = tempStartIndex;
        while (i < endIndex) {
            StepProgressTask task = steps.get(i);
            if (task.isVisible()) {
                Box itemBox = Box.createHorizontalBox();
                int status = this.myStepProgressModel.getCorrectedStatus(task);
                ImageIcon icon = (ImageIcon)this.myTaskIcons.get(status);
                itemBox.add(Box.createHorizontalStrut(this.getStepIndentationInPixels(task)));
                JLabel iconLabel = new JLabel(icon);
                iconLabel.setName(task.getID());
                this.myIconLabels.add(iconLabel);
                itemBox.add(iconLabel);
                itemBox.add(Box.createHorizontalStrut(6));
                if (task.isCollapsed()) {
                    List<StepProgressTask> children = this.myStepProgressModel.getChildrenTasks(task.getID());
                    int currentTaskIndex = 0;
                    StepProgressTask currentChild = task;
                    int j = 0;
                    while (j < children.size()) {
                        StepProgressTask child = children.get(j);
                        if (child.getStatus() == 1 || child.getStatus() == 3 || child.getStatus() == 4) {
                            currentChild = child;
                            currentTaskIndex = j + 1;
                        }
                        ++j;
                    }
                    if (task.getStatus() == 3 || task.getStatus() == 4 || task.getStatus() == 5 || task.getStatus() == 6) {
                        itemBox.add(PLabel.createValueText(String.valueOf(task.getDescription()) + " - " + currentTaskIndex + " / " + children.size()));
                    } else {
                        itemBox.add(PLabel.createValueText(String.valueOf(task.getDescription()) + " - " + currentTaskIndex + " / " + children.size() + " " + currentChild.getDescription()));
                    }
                } else {
                    itemBox.add(PLabel.createValueText(task.getDescription()));
                }
                itemBox.add(Box.createHorizontalGlue());
                this.myTaskPanel.add(itemBox);
                this.additionalTaskInfo(task);
                this.myTaskPanel.add(Box.createVerticalStrut(12));
            }
            ++i;
        }
        this.myTaskPanel.validate();
        int idx = 0;
        while (idx < this.myIconLabels.size()) {
            JLabel iconLabel = (JLabel)this.myIconLabels.get(idx);
            if (this.myAttachedBalloons.containsKey(iconLabel.getName()) && iconLabel.isShowing()) {
                Balloon balloon = (Balloon)this.myAttachedBalloons.get(iconLabel.getName());
                balloon.relocateBalloon(iconLabel);
            }
            ++idx;
        }
        if (this.myStepProgressModel.isScrollingUsed() && steps.size() > 17) {
            Box downArrowBox = Box.createHorizontalBox();
            downArrowBox.add(onEnd ? emptyLabel : new JLabel(this.myDownArrow));
            downArrowBox.add(Box.createHorizontalGlue());
            this.myTaskPanel.add(downArrowBox);
        }
        this.myTaskPanel.revalidate();
    }

    protected void additionalTaskInfo(StepProgressTask task) {
    }

    @Override
    protected void updateData() {
        super.updateData();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (StepProgressUI.this.myStepProgressModel.isScrollingUsed()) {
                    StepProgressUI.this.drawProgressTasks(StepProgressUI.this.myStepProgressModel.getCurrentStepIndex());
                } else {
                    StepProgressUI.this.drawProgressTasks(0);
                }
                StepProgressUI.this.myNewBalloonAttached = false;
                StepProgressUI.this.revalidate();
            }
        });
    }

    protected int getStepIndentationInPixels(StepProgressTask task) {
        int size = 0;
        StepProgressTask temp = task;
        while (temp.getParent() != null) {
            size += 22;
            temp = temp.getParent();
        }
        return size;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        boolean value = super.imageUpdate(img, infoflags, x, y, w, h);
        this.fireGuiEvent(new ProgressGuiEvent(EVENT_STARTED_TASK_ANIMATION_UPDATE));
        return value;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleStepProgressUI();
        }
        return this.accessibleContext;
    }

    protected class AccessibleStepProgressUI
    extends AbstractProgressUI.AccessibleAbstractProgressUI {
        protected AccessibleStepProgressUI() {
        }

        @Override
        public String getAccessibleName() {
            return this.accessibleName == null ? WidgetResources.getString("StepProgress.Default.AccessibleName") : this.accessibleName;
        }

        @Override
        public String getAccessibleDescription() {
            return this.accessibleDescription == null ? WidgetResources.getString("StepProgress.Default.AccessibleDescription") : this.accessibleDescription;
        }
    }
}

