/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.rangeslider;

import com.nokia.laf.NetSliderUI;
import com.nokia.widgets.rangeslider.RangeSlider;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

class RangeSliderUI
extends NetSliderUI {
    private Rectangle myUpperThumbRect;
    private boolean myUpperThumbSelected;
    private transient boolean myLowerDragging;
    private transient boolean myUpperDragging;

    @Override
    public void installUI(JComponent c) {
        if (theFilledColor == null) {
            theFilledColor = UIManager.getColor("Slider.filledColor");
        }
        this.myUpperThumbRect = new Rectangle();
        super.installUI(c);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeHandler();
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.myUpperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected void calculateThumbLocation() {
        int upperPosition;
        super.calculateThumbLocation();
        if (this.slider.getSnapToTicks()) {
            int upperValue;
            int snappedValue = upperValue = this.slider.getValue() + this.slider.getExtent();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((upperValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(upperValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != upperValue) {
                    this.slider.setExtent(snappedValue - this.slider.getValue());
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            upperPosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.myUpperThumbRect.x = upperPosition - this.myUpperThumbRect.width / 2;
            this.myUpperThumbRect.y = this.trackRect.y;
        } else {
            upperPosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.myUpperThumbRect.x = this.trackRect.x;
            this.myUpperThumbRect.y = upperPosition - this.myUpperThumbRect.height / 2;
        }
    }

    @Override
    protected int getThumbOverhang() {
        if (this.slider.getOrientation() == 0) {
            return (int)this.getThumbSize().getHeight() / 2;
        }
        return (int)this.getThumbSize().getWidth() / 2;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Rectangle clipRect = g.getClipBounds();
        if (this.myUpperThumbSelected) {
            if (clipRect.intersects(this.thumbRect)) {
                super.paintThumb(g);
            }
            if (clipRect.intersects(this.myUpperThumbRect)) {
                this.paintUpperThumb(g);
            }
        } else {
            if (clipRect.intersects(this.myUpperThumbRect)) {
                this.paintUpperThumb(g);
            }
            if (clipRect.intersects(this.thumbRect)) {
                super.paintThumb(g);
            }
        }
    }

    @Override
    public void paintTrack(Graphics g) {
        ImageIcon midTrack;
        Rectangle trackBounds = this.trackRect;
        boolean leftToRight = ComponentUtils.isLeftToRight(this.slider);
        g.translate(trackBounds.x, trackBounds.y);
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        int lowerX = 0;
        int upperX = 0;
        if (this.slider.getOrientation() == 0) {
            trackTop = trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackRight = this.trackRect.width - 1;
            lowerX = this.thumbRect.x + this.thumbRect.width / 2;
            upperX = this.myUpperThumbRect.x + this.myUpperThumbRect.width / 2;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - this.getThumbOverhang();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang();
            }
            trackBottom = this.trackRect.height - 1;
        }
        if (this.slider.getOrientation() == 0) {
            ImageIcon rightEdge;
            ImageIcon leftEdge;
            if (this.slider.isEnabled() && !ComponentUtils.isReadOnly(this.slider)) {
                midTrack = (ImageIcon)UIManager.get("Slider.midTrack");
                leftEdge = (ImageIcon)UIManager.get("Slider.leftEdge");
                rightEdge = (ImageIcon)UIManager.get("Slider.rightEdge");
            } else {
                midTrack = (ImageIcon)UIManager.get("Slider.disabledMidTrack");
                leftEdge = (ImageIcon)UIManager.get("Slider.disabledLeftEdge");
                rightEdge = (ImageIcon)UIManager.get("Slider.disabledRightEdge");
            }
            g.drawImage(midTrack.getImage(), trackLeft, trackTop - 3, trackRight - trackLeft - 1, midTrack.getIconHeight(), null);
            g.drawImage(leftEdge.getImage(), trackLeft, trackTop - 3, leftEdge.getIconWidth(), leftEdge.getIconHeight(), null);
            g.drawImage(rightEdge.getImage(), trackRight - 1, trackTop - 3, rightEdge.getIconWidth(), rightEdge.getIconHeight(), null);
        } else {
            ImageIcon bottomEdge;
            ImageIcon topEdge;
            if (this.slider.isEnabled() && !ComponentUtils.isReadOnly(this.slider)) {
                midTrack = (ImageIcon)UIManager.get("Slider.verticalMidTrack");
                topEdge = (ImageIcon)UIManager.get("Slider.topEdge");
                bottomEdge = (ImageIcon)UIManager.get("Slider.bottomEdge");
            } else {
                midTrack = (ImageIcon)UIManager.get("Slider.disabledVerticalMidTrack");
                topEdge = (ImageIcon)UIManager.get("Slider.disabledTopEdge");
                bottomEdge = (ImageIcon)UIManager.get("Slider.disabledBottomEdge");
            }
            g.drawImage(midTrack.getImage(), trackLeft, trackTop, midTrack.getIconWidth(), trackBottom - trackTop, null);
            g.drawImage(topEdge.getImage(), trackLeft, trackTop - 1, topEdge.getIconWidth(), topEdge.getIconHeight(), null);
            g.drawImage(bottomEdge.getImage(), trackLeft, trackBottom - 6, bottomEdge.getIconWidth(), bottomEdge.getIconHeight(), null);
        }
        if (this.slider.getOrientation() == 0 && this.slider.isEnabled()) {
            g.setColor(theFilledColor);
            g.fillRect(lowerX - 5, trackTop - 2, upperX - lowerX - 3, midTrack.getIconHeight() - 1);
        }
        g.translate(-trackBounds.x, -trackBounds.y);
    }

    @Override
    public void paintThumb(Graphics g) {
    }

    private void paintUpperThumb(Graphics g) {
        Rectangle lowerKnobBounds = this.thumbRect;
        this.thumbRect = this.myUpperThumbRect;
        super.paintThumb(g);
        this.thumbRect = lowerKnobBounds;
    }

    private void setUpperThumbLocation(int x, int y) {
        Rectangle upperUnionRect = new Rectangle();
        upperUnionRect.setBounds(this.myUpperThumbRect);
        this.myUpperThumbRect.setLocation(x, y);
        SwingUtilities.computeUnion(this.myUpperThumbRect.x, this.myUpperThumbRect.y, this.myUpperThumbRect.width, this.myUpperThumbRect.height, upperUnionRect);
        this.slider.repaint(upperUnionRect.x, upperUnionRect.y, upperUnionRect.width, upperUnionRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            if (this.myUpperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int delta = 1 * (direction > 0 ? 1 : -1);
            if (this.myUpperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent arg0) {
            if (!RangeSliderUI.this.myLowerDragging && !RangeSliderUI.this.myUpperDragging) {
                RangeSliderUI.this.calculateThumbLocation();
                RangeSliderUI.this.slider.repaint();
            }
        }
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super(RangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (RangeSliderUI.this.slider.isRequestFocusEnabled()) {
                RangeSliderUI.this.slider.requestFocus();
            }
            boolean lowerPressed = false;
            boolean upperPressed = false;
            if (RangeSliderUI.this.myUpperThumbSelected) {
                if (RangeSliderUI.this.myUpperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    upperPressed = true;
                } else if (RangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    lowerPressed = true;
                }
            } else if (RangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                lowerPressed = true;
            } else if (RangeSliderUI.this.myUpperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                upperPressed = true;
            }
            if (lowerPressed) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).thumbRect.x;
                        break;
                    }
                }
                RangeSliderUI.this.myUpperThumbSelected = false;
                RangeSliderUI.this.myLowerDragging = true;
                return;
            }
            RangeSliderUI.this.myLowerDragging = false;
            if (upperPressed) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).myUpperThumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).myUpperThumbRect.x;
                        break;
                    }
                }
                RangeSliderUI.this.myUpperThumbSelected = true;
                RangeSliderUI.this.myUpperDragging = true;
                return;
            }
            RangeSliderUI.this.myUpperDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            RangeSliderUI.this.myLowerDragging = false;
            RangeSliderUI.this.myUpperDragging = false;
            RangeSliderUI.this.slider.setValueIsAdjusting(false);
            RangeSliderUI.this.slider.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (RangeSliderUI.this.myLowerDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb();
            } else if (RangeSliderUI.this.myUpperDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            RangeSliderUI.this.slider.setValueIsAdjusting(false);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RangeSliderUI.this.slider.setValueIsAdjusting(false);
        }

        @Override
        public boolean shouldScroll(int direction) {
            return false;
        }

        private void moveLowerThumb() {
            int thumbMiddle = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int trackBottom = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int vMax = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    RangeSliderUI.this.setThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int trackRight = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int hMax = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    RangeSliderUI.this.setThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void moveUpperThumb() {
            int thumbMiddle = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int trackBottom = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int vMin = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackTop = vMin;
                    } else {
                        trackBottom = vMin;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    RangeSliderUI.this.setUpperThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForYPosition(thumbMiddle) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int trackRight = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int hMin = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackRight = hMin;
                    } else {
                        trackLeft = hMin;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    RangeSliderUI.this.setUpperThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForXPosition(thumbMiddle) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }
}

