/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.rollingcounter;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.numberrangemodel.NumberRangeModel;
import com.nokia.widgets.rollingcounter.RollingCounterUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

public class RollingCounter<T extends Number>
extends JComponent {
    private NumberRangeModel<T> myModel;
    private InternationalFormatter myValueFormatter = RollingCounter.createIntegerFormatter();
    private int myStepSpacing = 100;
    private Number myStep;
    private Icon myIcon = null;
    private boolean myInterpolateRollingSpeed = true;
    private boolean myPaintLabels = true;
    private boolean myShowPointer = true;
    private boolean myWrapOnOverflow = true;
    private int myInnerMargin = 16;
    private boolean myCircleProjection = true;
    private boolean myDimmedEdges = true;
    private boolean myAnimateBackwardRolling = false;

    public RollingCounter(NumberRangeModel<T> model, Number step) {
        this.myModel = model;
        this.myStep = step;
        this.setFont(UIManager.getFont("Label.font").deriveFont(22.0f));
        this.setBackground(Color.WHITE);
        this.setBorder(new RollingCounterBorder());
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(new RollingCounterUI());
    }

    @Override
    public RollingCounterUI getUI() {
        return (RollingCounterUI)this.ui;
    }

    public boolean isCircleProjection() {
        return this.myCircleProjection;
    }

    public void setCircleProjection(boolean circleProjection) {
        boolean oldValue = this.myCircleProjection;
        this.myCircleProjection = circleProjection;
        this.firePropertyChange("circleProjection", oldValue, this.myCircleProjection);
    }

    public boolean isDimmedEdges() {
        return this.myDimmedEdges;
    }

    public void setWrapOnOverflow(boolean wrap) {
        this.myWrapOnOverflow = wrap;
    }

    public void setDimmedEdges(boolean dimmedEdges) {
        boolean oldValue = this.myDimmedEdges;
        this.myDimmedEdges = dimmedEdges;
        this.firePropertyChange("dimmedEdges", oldValue, this.myDimmedEdges);
    }

    public void setPaintLabels(boolean paintLabels) {
        boolean oldValue = this.myPaintLabels;
        this.myPaintLabels = paintLabels;
        this.firePropertyChange("paintLabels", oldValue, this.myPaintLabels);
    }

    public boolean areLabelsPainted() {
        return this.myPaintLabels;
    }

    public void setShowPointer(boolean showPointer) {
        boolean oldValue = this.myShowPointer;
        this.myShowPointer = showPointer;
        this.firePropertyChange("showPointer", oldValue, this.myShowPointer);
    }

    public boolean isPointerShown() {
        return this.myShowPointer;
    }

    public void setInterpolateRollingSpeed(boolean interpolate) {
        this.myInterpolateRollingSpeed = interpolate;
    }

    public boolean isInterpolateRollingSpeed() {
        return this.myInterpolateRollingSpeed;
    }

    public void setIcon(Icon icon) {
        Icon oldValue = this.myIcon;
        this.myIcon = icon;
        this.firePropertyChange("icon", oldValue, this.myIcon);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public Icon getIcon(double value) {
        return this.getIcon();
    }

    public void setStepSpacing(int stepSpacing) {
        this.myStepSpacing = stepSpacing;
    }

    public int getStepSpacing() {
        return this.myStepSpacing;
    }

    public void setValueFormatter(InternationalFormatter formatter) {
        this.myValueFormatter = formatter;
    }

    public void setValue(T value) {
        T oldValue = this.myModel.getValue();
        T normalized = this.getWrappedValue(value);
        this.myModel.setValue(normalized);
        this.firePropertyChange("value", oldValue, normalized);
    }

    private T getWrappedValue(T val) {
        double value = ((Number)val).doubleValue();
        double max = ((Number)this.myModel.getMaximum()).doubleValue();
        if (this.myWrapOnOverflow && value > max) {
            double min = ((Number)this.myModel.getMinimum()).doubleValue();
            double diff = max - min;
            double times = Math.floor(value / diff);
            return (T)Double.valueOf(value - times * diff);
        }
        return val;
    }

    public void setAnimateBackwardRolling(boolean animate) {
        this.myAnimateBackwardRolling = animate;
    }

    public boolean isBackwardRollinAnimated() {
        return this.myAnimateBackwardRolling;
    }

    public String getFormattedValue(double value) {
        if (this.myValueFormatter == null) {
            return String.valueOf(value);
        }
        try {
            return this.myValueFormatter.valueToString(value);
        }
        catch (ParseException e) {
            return String.valueOf(value);
        }
    }

    public T getValue() {
        return this.getModel().getValue();
    }

    private NumberRangeModel<T> getModel() {
        return this.myModel;
    }

    private static NumberFormatter createIntegerFormatter() {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(0);
        format.setGroupingUsed(false);
        return new NumberFormatter(format);
    }

    public Number getStep() {
        return this.myStep;
    }

    public T getMinimum() {
        return this.getModel().getMinimum();
    }

    public void setMinimum(T minimum) {
        T oldMin = this.getModel().getMinimum();
        this.getModel().setMinimum(minimum);
        this.firePropertyChange("minimum", oldMin, minimum);
    }

    public Number getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setInnerMargin(int margin) {
        int oldValue = this.myInnerMargin;
        this.myInnerMargin = margin;
        if (oldValue != margin) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getInnerMargin() {
        return this.myInnerMargin;
    }

    public void setMaximum(T maximum) {
        T oldMax = this.getModel().getMaximum();
        this.getModel().setMaximum(maximum);
        this.firePropertyChange("maximum", oldMax, maximum);
    }

    private static class RollingCounterBorder
    extends AbstractBorder {
        private static Color[] BORDER_ALPHA = new Color[]{NetUtils.getColor(Color.BLACK, 4), NetUtils.getColor(Color.BLACK, 5), NetUtils.getColor(Color.BLACK, 5), NetUtils.getColor(Color.BLACK, 3)};

        private RollingCounterBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(BORDER_ALPHA[0]);
            g.drawLine(x + 50, height - 3, width - 50, height - 3);
            g.setColor(BORDER_ALPHA[1]);
            g.drawLine(x + 22, height - 3, width - 22, height - 3);
            g.setColor(BORDER_ALPHA[2]);
            g.drawLine(x + 31, height - 2, width - 31, height - 2);
            g.setColor(BORDER_ALPHA[3]);
            g.drawLine(x + 36, height - 1, width - 36, height - 1);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 0;
            insets.left = 0;
            insets.right = 0;
            insets.bottom = 3;
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }
    }
}

