/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.rollingcounter;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.painters.CircleProjection;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.rollingcounter.RollingCounter;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;

public class RollingCounterUI<T extends Number>
extends ComponentUI
implements ActionListener,
PropertyChangeListener {
    private int myAnimationStep = 3;
    private static final Color BORDER_COLOR = Color.decode("#D6D6FF");
    private RollingCounter<T> myCounter;
    private static PArrowIcon ARROW_ICON = new PArrowIcon(10, 5, new Color(0, 0, 200, 50));
    private static PArrowIcon ARROW_ICON_BOTTOM = new PArrowIcon(10, 5, new Color(0, 0, 200, 50), 1);
    private static Color BASE_COLOR = new Color(18, 65, 145);
    private Timer myTimer = new Timer(6, this);
    private int myAnimatedXValue = -1;
    private BufferedImage myImage;
    private BufferedImage myForegroundImage;
    private CircleProjection myCircleProjection;
    private Color[] FADE_IN_GRADIENT = new Color[]{NetUtils.getColor(BASE_COLOR, 18), NetUtils.getColor(BASE_COLOR, 255)};
    private Color[] BACKGROUND_GRADIENT = new Color[]{NetUtils.getColor(BASE_COLOR, 60), NetUtils.getColor(BASE_COLOR, 0)};
    private int myCachedHeight;
    private double myPreviousEvent;

    @Override
    public void installUI(JComponent c) {
        this.myCounter = (RollingCounter)c;
        this.myTimer.setRepeats(true);
        super.installUI(c);
        this.myCounter.addPropertyChangeListener(this);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.myCounter.removePropertyChangeListener(this);
        this.myCounter = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        NetUtils.antiAliasingOn(g);
        Insets insets = c.getInsets();
        int width = this.myCounter.getWidth() - (insets.left + insets.right);
        int height = this.myCounter.getHeight() - (insets.top + insets.bottom);
        g.setColor(this.myCounter.getBackground());
        g.fillRoundRect(insets.left, insets.top, width, height, 20, 20);
        this.paintLabels(g, insets.top, insets.left, width, height);
        this.paintForeground(g, insets, width, height);
    }

    private void paintForeground(Graphics g, Insets insets, int innerWidth, int innerHeight) {
        if (this.myForegroundImage == null || this.myForegroundImage.getWidth() != innerWidth || this.myForegroundImage.getHeight() != innerHeight) {
            this.myForegroundImage = ImageUtils.createCompatibleTranslucentImage(innerWidth, innerHeight);
            Graphics2D g2d = this.myForegroundImage.createGraphics();
            NetUtils.antiAliasingOn(g2d);
            if (this.myCounter.isDimmedEdges()) {
                this.paintEndGradients(g2d, this.BACKGROUND_GRADIENT, innerWidth + 1, innerHeight + 1);
            }
            g2d.setColor(BORDER_COLOR);
            g2d.drawRoundRect(0, 0, innerWidth - 1, innerHeight - 1, 20, 20);
            if (this.myCounter.isPointerShown()) {
                this.paintPointer(g2d, innerWidth, innerHeight);
            }
            g2d.dispose();
        }
        g.drawImage(this.myForegroundImage, insets.left, insets.top, null);
    }

    private void paintPointer(Graphics2D g2d, int innerWidth, int innerHeight) {
        ARROW_ICON.paintIcon(this.myCounter, g2d, innerWidth / 2 - ARROW_ICON.getIconWidth() / 2, -2);
        ARROW_ICON_BOTTOM.paintIcon(this.myCounter, g2d, innerWidth / 2 - ARROW_ICON.getIconWidth() / 2, innerHeight - ARROW_ICON.getIconHeight() + 1);
    }

    private void paintLabels(Graphics g, int top, int left, int innerWidth, int innerHeight) {
        int imageWidth;
        int middleArea = (int)(0.33 * (double)innerWidth);
        NetUtils.antiAliasingOff(g);
        NetLookAndFeel.toggleTextAntialiasing(g);
        g.setColor(this.myCounter.getForeground());
        Font font = this.myCounter.getFont();
        g.setFont(font);
        Graphics2D g2d = null;
        double radius = 0.5 * (double)(innerWidth - middleArea);
        int n = imageWidth = this.myCounter.isCircleProjection() ? (int)((double)middleArea + Math.PI * radius) : innerWidth;
        if (this.recreateImage(innerHeight, imageWidth)) {
            this.myImage = ImageUtils.createCompatibleTranslucentImage(imageWidth, innerHeight);
            g2d = this.myImage.createGraphics();
        } else {
            g2d = this.myImage.createGraphics();
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.Clear);
            g2d.fillRect(0, 0, this.myImage.getWidth(), this.myImage.getHeight());
            g2d.setComposite(oldComposite);
        }
        Insets insets = this.myCounter.getInsets();
        g2d.setFont(font);
        g2d.setColor(this.myCounter.getForeground());
        int textY = insets.top + this.myCounter.getInnerMargin() + font.getSize() - 2;
        FontMetrics fm = g2d.getFontMetrics();
        int valueXPos = this.myTimer.isRunning() ? this.myAnimatedXValue : this.getXPosition(((Number)this.myCounter.getValue()).doubleValue());
        int valueAtLeftEndXPos = valueXPos - imageWidth / 2;
        int valueAtRightEndXPos = valueXPos + imageWidth / 2;
        NetLookAndFeel.toggleTextAntialiasing(g2d);
        NetUtils.antiAliasingOff(g2d);
        g2d.translate((double)(-valueXPos) + (double)imageWidth / 2.0, 0.0);
        int clipStart = Math.max(0, this.getClosestTick(valueAtLeftEndXPos) - 1);
        int clipEnd = this.getClosestTick(valueAtRightEndXPos) + 1;
        double min = ((Number)this.myCounter.getMinimum()).doubleValue();
        double step = this.myCounter.getStep().doubleValue();
        int stepSpacing = this.myCounter.getStepSpacing();
        double tickValue = min + (double)clipStart * step;
        boolean labelsPainted = this.myCounter.areLabelsPainted();
        int idx = clipStart;
        while (idx <= clipEnd) {
            Icon icon;
            int tickPosition = (idx + 1) * stepSpacing;
            if (labelsPainted) {
                String formattedValue = this.myCounter.getFormattedValue(tickValue);
                Rectangle2D stringRect = fm.getStringBounds(formattedValue, g2d);
                int textXPosition = (int)((double)tickPosition - stringRect.getWidth() / 2.0);
                g2d.drawString(formattedValue, textXPosition, textY);
            }
            if ((icon = this.myCounter.getIcon(tickValue)) != null) {
                icon.paintIcon(this.myCounter, g2d, tickPosition - icon.getIconWidth() / 2, labelsPainted ? textY + 6 : innerHeight / 2 - icon.getIconHeight() / 2);
            }
            tickValue += step;
            ++idx;
        }
        g2d.translate(valueXPos - imageWidth / 2, 0);
        NetUtils.antiAliasingOn(g2d);
        g2d.setComposite(AlphaComposite.DstIn);
        if (this.myCounter.isDimmedEdges()) {
            this.paintEndGradients(g2d, this.FADE_IN_GRADIENT, imageWidth, innerHeight);
        }
        this.myImage.flush();
        g2d.dispose();
        if (this.myCounter.isCircleProjection()) {
            if (this.myCircleProjection == null || !SystemUtils.isEqual(radius, this.myCircleProjection.getRadius(), 0.01) || !SystemUtils.isEqual(middleArea, this.myCircleProjection.getCenterArea(), 0.01) || this.myImage.getHeight() != this.myCachedHeight) {
                this.myCircleProjection = new CircleProjection(radius, middleArea);
                this.myCachedHeight = this.myImage.getHeight();
            }
            ((Graphics2D)g).drawImage(this.myImage, this.myCircleProjection, left, top);
        } else {
            g.drawImage(this.myImage, left, top, null);
        }
    }

    private boolean recreateImage(int innerHeight, int imageWidth) {
        return this.myImage == null || this.myImage.getWidth() != imageWidth || this.myImage.getHeight() != innerHeight;
    }

    private int getXPosition(double value) {
        double step = this.myCounter.getStep().doubleValue();
        double min = ((Number)this.myCounter.getMinimum()).doubleValue();
        double max = this.myCounter.getMaximum().doubleValue();
        int stepSpacing = this.myCounter.getStepSpacing();
        int tickCount = (int)(Math.floor((max - min) / step) + 1.0);
        int totalLegth = (tickCount - 1) * stepSpacing;
        return stepSpacing + (int)((double)totalLegth / (max - min) * (value - min));
    }

    private int getClosestTick(double xPosition) {
        return (int)Math.floor(xPosition / (double)this.myCounter.getStepSpacing());
    }

    private void paintEndGradients(Graphics g, Color[] colors, int width, int height) {
        int gradientSize = width / 3;
        Shape leftEnd = NetUtils.getRoundedPath(this.myCounter, 0, 0, gradientSize, height, 22, 3, false);
        Shape rightEnd = NetUtils.getRoundedPath(this.myCounter, width - gradientSize - 1, 0, gradientSize + 1, height, 22, 7, false);
        GradientUtils.drawHorizontalGradient(this.myCounter, g, colors, leftEnd);
        GradientUtils.drawHorizontalGradient(this.myCounter, g, new Color[]{colors[1], colors[0]}, rightEnd);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Icon icon;
        Font font = this.myCounter.getFont();
        int height = 2 * this.myCounter.getInnerMargin();
        if (this.myCounter.areLabelsPainted()) {
            height += font.getSize();
        }
        if ((icon = this.myCounter.getIcon(((Number)this.myCounter.getMinimum()).doubleValue())) != null) {
            height += icon.getIconHeight() + 2;
        }
        int width = 2 * this.myCounter.getStepSpacing();
        Insets insets = c.getInsets();
        if (insets != null) {
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
        }
        return new Dimension(width, height);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        T value = this.myCounter.getValue();
        if (this.myAnimationStep > 0) {
            if (this.myAnimatedXValue + this.myAnimationStep < this.getXPosition(((Number)value).doubleValue())) {
                this.myAnimatedXValue += this.myAnimationStep;
            } else {
                this.myTimer.stop();
            }
        } else if (this.myCounter.isBackwardRollinAnimated()) {
            if (this.myAnimatedXValue + this.myAnimationStep > this.getXPosition(((Number)value).doubleValue())) {
                this.myAnimatedXValue += this.myAnimationStep;
            } else {
                this.myTimer.stop();
            }
        }
        this.myCounter.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName())) {
            Number oldValue = (Number)evt.getOldValue();
            this.myAnimatedXValue = this.getXPosition(oldValue.doubleValue());
            Number targetValue = (Number)evt.getNewValue();
            int targetPixels = this.getXPosition(targetValue.doubleValue());
            int distance = this.myCounter.isBackwardRollinAnimated() ? targetPixels - this.myAnimatedXValue : Math.abs(targetPixels - this.myAnimatedXValue);
            int interpolationDivisor = 3;
            double nonInterpolatedRollingSpeed = distance >= 0 ? Math.max(3.0, (double)distance / 40.0) : Math.min(-3.0, (double)distance / 40.0);
            this.myAnimationStep = (int)(this.myCounter.isInterpolateRollingSpeed() ? (double)(distance / interpolationDivisor) : nonInterpolatedRollingSpeed);
            long current = System.currentTimeMillis();
            double delta = (double)current - this.myPreviousEvent;
            if (this.myCounter.isInterpolateRollingSpeed()) {
                this.myTimer.setDelay((int)(delta / (double)interpolationDivisor));
            }
            this.myPreviousEvent = current;
            this.myTimer.restart();
        }
        if ("icon".equals(evt.getPropertyName()) || "paintLabels".equals(evt.getPropertyName()) || "circleProjection".equals(evt.getPropertyName()) || "dimmedEdges".equals(evt.getPropertyName())) {
            this.myCircleProjection = null;
            if ("dimmedEdges".equals(evt.getPropertyName())) {
                this.myImage = null;
                this.myForegroundImage = null;
            }
            this.myCounter.revalidate();
            this.myCounter.repaint();
        }
        if ("showPointer".equals(evt.getPropertyName())) {
            this.myForegroundImage = null;
            this.myCounter.revalidate();
            this.myCounter.repaint();
        }
    }
}

