/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.search;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.search.SearchHelper;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SearchDialog
extends JDialog {
    public SearchDialog(final SearchHelper helper) {
        this.setTitle(WidgetResources.getString("SearchHelper.title"));
        PPanel contentPanel = new PPanel();
        contentPanel.setLayout(new BorderLayout());
        this.setContentPane(contentPanel);
        PPanel upperPanel = new PPanel();
        upperPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 23;
        gbc.insets = new Insets(0, 6, 3, 6);
        upperPanel.add(Box.createVerticalStrut(6), gbc);
        ++gbc.gridy;
        upperPanel.add((Component)PLabel.createTitle(WidgetResources.getString("SearchHelper.searchPhrase")), gbc);
        ++gbc.gridy;
        final JTextField searchText = new JTextField(25);
        searchText.setText(helper.getSearchQuery());
        upperPanel.add((Component)searchText, gbc);
        ++gbc.gridy;
        upperPanel.add(Box.createVerticalStrut(3), gbc);
        gbc.insets = new Insets(0, 6, 0, 6);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        PLabel directionLabel = PLabel.createTitle(WidgetResources.getString("SearchHelper.searchDirection"));
        upperPanel.add((Component)directionLabel, gbc);
        ++gbc.gridx;
        final JRadioButton forward = new JRadioButton(WidgetResources.getString("SearchHelper.forward"));
        upperPanel.add((Component)forward, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 6, 3, 6);
        JRadioButton backward = new JRadioButton(WidgetResources.getString("SearchHelper.backward"));
        upperPanel.add((Component)backward, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        upperPanel.add(Box.createVerticalStrut(3), gbc);
        gbc.gridwidth = 0;
        ++gbc.gridy;
        final JCheckBox matchCase = new JCheckBox(WidgetResources.getString("SearchHelper.matchCase"));
        matchCase.setSelected(helper.getMatchCase());
        upperPanel.add((Component)matchCase, gbc);
        ++gbc.gridy;
        upperPanel.add(Box.createVerticalStrut(2), gbc);
        JButton searchButton = new JButton(WidgetResources.getString("SearchHelper.search"));
        searchButton.setMnemonic(WidgetResources.getMnemonic("SearchHelper.search_Mnemonic"));
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String toSearch = searchText.getText();
                if (toSearch.length() > 0) {
                    helper.setSearchQuery(searchText.getText());
                    helper.setSearchDirection(forward.isSelected());
                    helper.setMatchCase(matchCase.isSelected());
                    helper.searchText();
                }
            }
        });
        JButton closeButton = new JButton(WidgetResources.getString("SearchHelper.close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.dispose();
            }
        });
        PPanel buttonPanel = new PPanel(new RowAlignLayout());
        buttonPanel.setPanelType(ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        buttonPanel.setVisibleUpperEdge(true);
        buttonPanel.add(searchButton);
        buttonPanel.add(closeButton);
        this.getRootPane().setDefaultButton(searchButton);
        ButtonGroup group = new ButtonGroup();
        group.add(forward);
        group.add(backward);
        forward.setSelected(helper.isSearchDirectionForward());
        backward.setSelected(!helper.isSearchDirectionForward());
        contentPanel.add((Component)upperPanel, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.setModal(false);
        this.setResizable(false);
        this.pack();
    }
}

