/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.search;

import com.nokia.widgets.search.SearchDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SearchHelper {
    private static final String STEP_KEY = "Step";
    private static final String SEARCH_KEY = "Search";
    private final JTextComponent myTextSource;
    private String mySearchQuery;
    private boolean myForward = true;
    private boolean myMatchCase;
    private SearchDialog mySearchDialog;
    private String myText;

    public SearchHelper(JTextComponent textSource) {
        this.myTextSource = textSource;
    }

    public void enableSearch(boolean enable) {
        if (enable) {
            this.myTextSource.getInputMap(2).put(KeyStroke.getKeyStroke(70, 2), SEARCH_KEY);
            this.myTextSource.getActionMap().put(SEARCH_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SearchHelper.this.mySearchDialog != null && SearchHelper.this.mySearchDialog.isVisible()) {
                        SearchHelper.this.mySearchDialog.toFront();
                        return;
                    }
                    SearchHelper.this.mySearchDialog = new SearchDialog(SearchHelper.this);
                    SearchHelper.this.mySearchDialog.setLocationRelativeTo(SwingUtilities.getWindowAncestor(SearchHelper.this.myTextSource));
                    SearchHelper.this.mySearchDialog.setVisible(true);
                }
            });
            this.myTextSource.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), STEP_KEY);
            this.myTextSource.getActionMap().put(STEP_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchHelper.this.searchText();
                }
            });
        } else {
            this.myTextSource.getInputMap(2).remove(KeyStroke.getKeyStroke(70, 2));
            this.myTextSource.getInputMap(2).remove(KeyStroke.getKeyStroke(114, 0));
            this.myTextSource.getActionMap().remove(SEARCH_KEY);
            this.myTextSource.getActionMap().remove(STEP_KEY);
        }
    }

    public void setSearchQuery(String searchQuery) {
        this.mySearchQuery = searchQuery;
    }

    public String getSearchQuery() {
        return this.mySearchQuery;
    }

    public void setSearchDirection(boolean forward) {
        this.myForward = forward;
    }

    public boolean isSearchDirectionForward() {
        return this.myForward;
    }

    public void setMatchCase(boolean matchCase) {
        this.myMatchCase = matchCase;
    }

    public boolean getMatchCase() {
        return this.myMatchCase;
    }

    public void searchText() {
        if (this.mySearchQuery != null && this.mySearchQuery.length() > 0) {
            int index;
            String query = this.mySearchQuery;
            this.myText = this.myTextSource.getText();
            if (!this.myMatchCase) {
                this.myText = this.myText.toLowerCase();
                query = query.toLowerCase();
            }
            if ((index = this.getIndex(this.myForward, query)) != -1) {
                this.myTextSource.setCaretPosition(index);
                this.myTextSource.moveCaretPosition(index + query.length());
            }
        }
    }

    private int getIndex(boolean forward, String query) {
        int index = this.tryToGetIndex(forward, query);
        if (index == -1) {
            if (forward) {
                this.myTextSource.setCaretPosition(0);
            } else {
                this.myTextSource.setCaretPosition(this.myText.length());
            }
            index = this.tryToGetIndex(forward, query);
        }
        return index;
    }

    private int tryToGetIndex(boolean forward, String query) {
        if (forward) {
            return this.myText.indexOf(query, this.myTextSource.getCaretPosition());
        }
        if (this.myTextSource.getCaret().getMark() - 1 >= 0) {
            return this.myText.lastIndexOf(query, this.myTextSource.getCaret().getMark() - 1);
        }
        return -1;
    }
}

