/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.slidingpanel;

import com.nokia.widgets.PPanel;
import com.nokia.widgets.slidingpanel.SlidingPanelStateChangeEvent;
import com.nokia.widgets.slidingpanel.SlidingPanelStateListener;
import com.nokia.widgets.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class SlidingPanel
extends PPanel
implements ActionListener {
    protected static final int TIMER_DELAY = 33;
    protected static final float MIN_SPEED = 1.0f;
    protected static final float MAX_SPEED = 6.0f;
    protected static final float SPEED_CHANGE = 0.5f;
    protected static final float BUFFER_ZONE_PIXELS = 36.0f;
    protected Timer myAnimationTimer;
    protected int myState = 0;
    protected Dimension mySize = new Dimension();
    protected Dimension myPreferredSize = new Dimension();
    protected float mySpeed = 1.0f;
    protected final List<SlidingPanelStateListener> myStateChangeListeners = new ArrayList<SlidingPanelStateListener>();
    private SoftReference<BufferedImage> myImage;
    private boolean myUseOptimisedPainting = false;
    private boolean myWasPreferredSizeSet = false;

    public SlidingPanel() {
        this.myAnimationTimer = new Timer(33, this);
        this.myAnimationTimer.setCoalesce(false);
    }

    public void setTimerDelay(int timerDelay) {
        this.myAnimationTimer.setDelay(timerDelay);
    }

    public void setOptimizedPainting(boolean optimized) {
        this.myUseOptimisedPainting = optimized;
    }

    public void showPanel() {
        this.setVisible(true);
        if (this.myUseOptimisedPainting && this.myState != 1 && this.getHeight() > 0 && this.getWidth() > 0) {
            this.createTempImageIfNeeded();
            BufferedImage image = this.myImage.get();
            if (image != null) {
                Graphics2D g2d = image.createGraphics();
                Dimension oldSize = this.getSize();
                this.setSize(this.myPreferredSize);
                this.doLayout();
                super.paint(g2d);
                this.setSize(oldSize);
                g2d.dispose();
            }
        }
        this.setState(3);
        this.myAnimationTimer.start();
    }

    public void hidePanel() {
        if (this.myUseOptimisedPainting && this.myState != 0 && this.getHeight() > 0 && this.getWidth() > 0) {
            this.createTempImageIfNeeded();
            BufferedImage image = this.myImage.get();
            if (image != null) {
                Graphics2D g2d = image.createGraphics();
                super.paint(g2d);
                g2d.dispose();
            }
        }
        this.setState(2);
        this.myAnimationTimer.start();
    }

    public boolean isPanelVisible() {
        return this.myState == 1;
    }

    public synchronized void addStateListener(SlidingPanelStateListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.myStateChangeListeners.contains(listener)) {
            this.myStateChangeListeners.add(listener);
        }
    }

    public synchronized void removeStateListener(SlidingPanelStateListener listener) {
        this.myStateChangeListeners.remove(listener);
    }

    public void fireStateChanged(SlidingPanelStateChangeEvent event) {
        if (event == null || this.myStateChangeListeners.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.myStateChangeListeners.size()) {
            try {
                this.myStateChangeListeners.get(i).stateChanged(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        switch (this.myState) {
            case 0: {
                this.myAnimationTimer.stop();
                this.setVisible(false);
                this.mySpeed = 1.0f;
                break;
            }
            case 3: {
                this.animateShowing();
                break;
            }
            case 2: {
                this.animateHiding();
                break;
            }
            case 1: {
                this.myAnimationTimer.stop();
                this.mySpeed = 1.0f;
                break;
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.prepareForAnimation();
    }

    protected void prepareForAnimation() {
        if (this.isPanelVisible()) {
            return;
        }
        this.setPreferredSize(null);
        this.myPreferredSize = this.getPreferredSize();
        this.myWasPreferredSizeSet = this.isPreferredSizeSet();
        this.setState(0);
        this.mySize.width = this.myPreferredSize.width;
        this.mySize.height = 0;
        this.setSize(this.mySize);
        this.setPreferredSize(this.mySize);
        this.setMinimumSize(this.mySize);
        this.setMaximumSize(this.mySize);
        this.setVisible(false);
        this.revalidate();
    }

    @Override
    public void removeNotify() {
        if (this.isPanelVisible()) {
            super.removeNotify();
            return;
        }
        this.setVisible(false);
        this.setState(0);
        super.removeNotify();
        this.setSize(this.myPreferredSize);
        this.setMinimumSize(this.myPreferredSize);
        this.setPreferredSize(this.myWasPreferredSizeSet ? this.myPreferredSize : null);
        this.setMaximumSize(this.myPreferredSize);
    }

    private void animateHiding() {
        Dimension size = this.mySize = this.getSize(this.mySize);
        if (size.height == 0) {
            this.setState(0);
            return;
        }
        int height = size.height - (int)this.mySpeed;
        if (height <= 0) {
            height = 0;
        } else if ((float)height >= (float)this.myPreferredSize.height - 36.0f) {
            this.mySpeed += 0.5f;
            this.mySpeed = Math.min(this.mySpeed, 6.0f);
        } else if ((float)height <= 36.0f) {
            this.mySpeed -= 0.5f;
            this.mySpeed = Math.max(this.mySpeed, 1.0f);
        }
        size.height = height;
        this.setSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.revalidate();
    }

    @Override
    public void paint(Graphics g) {
        if (this.myUseOptimisedPainting && this.myImage != null && (this.myState == 2 || this.myState == 3)) {
            g.drawImage(this.myImage.get(), 0, 0, null);
            return;
        }
        super.paint(g);
    }

    private void animateShowing() {
        Dimension size = this.mySize = this.getSize(this.mySize);
        if (size.height >= this.myPreferredSize.height) {
            this.setState(1);
            if (!this.myWasPreferredSizeSet) {
                this.setPreferredSize(null);
            }
            return;
        }
        int height = size.height + (int)this.mySpeed;
        if (height > this.myPreferredSize.height) {
            height = this.myPreferredSize.height;
        } else if ((float)height <= 36.0f) {
            this.mySpeed += 0.5f;
            this.mySpeed = Math.min(this.mySpeed, 6.0f);
        } else if ((float)height >= (float)this.myPreferredSize.height - 36.0f) {
            this.mySpeed -= 0.5f;
            this.mySpeed = Math.max(this.mySpeed, 1.0f);
        }
        size.height = height;
        this.setSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.revalidate();
    }

    private void setState(int state) {
        if (this.myState != state) {
            this.myState = state;
            this.fireStateChanged(new SlidingPanelStateChangeEvent(this, this.myState));
        }
    }

    private void createTempImageIfNeeded() {
        if (this.shouldCreateNewImage()) {
            this.myImage = new SoftReference<BufferedImage>(ImageUtils.createCompatibleOpaqueImage(this.getWidth(), this.getHeight()));
        }
    }

    private boolean shouldCreateNewImage() {
        if (this.myImage == null) {
            return true;
        }
        BufferedImage image = this.myImage.get();
        if (image == null) {
            return true;
        }
        return image.getWidth() != this.getWidth() || image.getHeight() != this.getHeight();
    }
}

