/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.speedometer;

import com.nokia.widgets.numberrangemodel.NumberRangeModel;
import com.nokia.widgets.speedometer.DefaultSpeedometerModel;
import com.nokia.widgets.speedometer.SpeedometerUI;
import java.awt.Color;
import java.awt.Font;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

public class Speedometer<T extends Number>
extends JComponent {
    private boolean myPaintLabels = true;
    private NumberRangeModel<T> myModel = null;
    private T myTickSpacing;
    private int myRadius = 160;
    private Color myPointerColor = Color.RED;
    private boolean myPaintMajorTicks = true;
    private int myMajorTickLength = 20;
    private boolean myPaintMinorTicks = true;
    private T myMinorTickSpacing;
    private int myMinorTickLength = 10;
    private String myText = "";
    private boolean myDisplayValue = true;
    private InternationalFormatter myValueFormatter = Speedometer.createDoubleFormatter(1, 1);
    private InternationalFormatter myTickLabelFormatter = Speedometer.createDoubleFormatter(1, 0);
    private int myInnerMargin = 20;
    private double myMinAngle = -3.7699111843077517;
    private double myMaxAngle = 0.6283185307179586;
    private boolean myShowOuterGlow = true;
    private Font myCurrentValueFont = UIManager.getFont("Label.font").deriveFont(1, 38.0f);
    private Font myTextFont = UIManager.getFont("Label.font").deriveFont(1, 17.0f);

    public Speedometer(T min, T max) {
        this(new DefaultSpeedometerModel<T>(min, min, max));
    }

    public Speedometer(T value, T min, T max) {
        this(new DefaultSpeedometerModel<T>(value, min, max));
    }

    public Speedometer(NumberRangeModel<T> model) {
        this.updateUI();
        this.setForeground(Color.WHITE);
        this.setBackground(Color.BLACK);
        this.setBorder(BorderFactory.createEmptyBorder(24, 24, 24, 24));
        this.setFont(UIManager.getFont("Label.font").deriveFont(1).deriveFont(18.0f));
        this.myModel = model;
        if (this.myModel.getValue() instanceof Integer) {
            this.myValueFormatter = Speedometer.createIntegerFormatter();
        }
    }

    public Speedometer() {
        this(new DefaultSpeedometerModel<Double>(0.0, 0.0, 100.0));
    }

    @Override
    public void updateUI() {
        this.setUI(new SpeedometerUI());
    }

    @Override
    public SpeedometerUI getUI() {
        return (SpeedometerUI)this.ui;
    }

    public void setShowOuterGlow(boolean showOuterGlow) {
        boolean oldValue = this.myShowOuterGlow;
        this.myShowOuterGlow = showOuterGlow;
        this.firePropertyChange("showOuterGlow", oldValue, this.myShowOuterGlow);
    }

    public boolean isOuterGlowShown() {
        return this.myShowOuterGlow;
    }

    public void setRadius(int radius) {
        int oldValue = this.myRadius;
        this.myRadius = radius;
        this.firePropertyChange("radius", oldValue, this.myRadius);
    }

    public int getRadius() {
        return this.myRadius;
    }

    public boolean getPaintLabels() {
        return this.myPaintLabels;
    }

    public NumberRangeModel<T> getModel() {
        return this.myModel;
    }

    public String getFormattedValue(double value) {
        if (this.myValueFormatter == null) {
            return String.valueOf(value);
        }
        try {
            return this.myValueFormatter.valueToString(value);
        }
        catch (ParseException e) {
            return String.valueOf(value);
        }
    }

    public String getFormattedTickLabel(double value) {
        if (this.myTickLabelFormatter == null) {
            return this.getFormattedValue(value);
        }
        try {
            return this.myTickLabelFormatter.valueToString(value);
        }
        catch (ParseException e) {
            return String.valueOf(value);
        }
    }

    public void setModel(NumberRangeModel<T> model) {
        NumberRangeModel<T> oldValue = this.myModel;
        this.myModel = model;
        this.firePropertyChange("model", oldValue, this.myModel);
    }

    public T getValue() {
        return this.getModel().getValue();
    }

    public void setValue(T n) {
        NumberRangeModel<T> m = this.getModel();
        T oldValue = m.getValue();
        if (n.equals(oldValue)) {
            return;
        }
        m.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", oldValue, m.getValue());
        }
        this.firePropertyChange("value", oldValue, n);
    }

    public Number getMinimum() {
        return this.getModel().getMinimum();
    }

    public void setMinimum(T minimum) {
        T oldMin = this.getModel().getMinimum();
        this.getModel().setMinimum(minimum);
        this.firePropertyChange("minimum", oldMin, minimum);
    }

    public Number getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setMaximum(T maximum) {
        T oldMax = this.getModel().getMaximum();
        this.getModel().setMaximum(maximum);
        this.firePropertyChange("maximum", oldMax, maximum);
    }

    public void setPaintLabels(boolean paintLabels) {
        boolean oldValue = this.myPaintLabels;
        this.myPaintLabels = paintLabels;
        this.firePropertyChange("paintLabels", oldValue, this.myPaintLabels);
    }

    public T getTickSpacing() {
        return this.myTickSpacing;
    }

    public void setTickSpacing(T tickSpacing) {
        T oldvalue = tickSpacing;
        this.myTickSpacing = tickSpacing;
        this.firePropertyChange("tickSpacing", oldvalue, this.myTickSpacing);
    }

    public void setTickLabelFormatter(InternationalFormatter formatter) {
        InternationalFormatter oldvalue = this.myTickLabelFormatter;
        this.myTickLabelFormatter = formatter;
        this.firePropertyChange("tickLabelFormatter", oldvalue, this.myTickLabelFormatter);
    }

    public void setPointerColor(Color pointerColor) {
        Color oldvalue = this.myPointerColor;
        this.myPointerColor = pointerColor;
        this.firePropertyChange("pointerColor", oldvalue, this.myPointerColor);
    }

    public Color getPointerColor() {
        return this.myPointerColor;
    }

    public boolean getPaintMajorTicks() {
        return this.myPaintMajorTicks;
    }

    public void setPaintMinorTicks(boolean paint) {
        boolean oldValue = this.myPaintMinorTicks;
        this.myPaintMinorTicks = paint;
        this.firePropertyChange("paintMinorTicks", oldValue, this.myPaintMinorTicks);
    }

    public void setPaintMajorTicks(boolean paint) {
        boolean oldValue = this.myPaintMajorTicks;
        this.myPaintMajorTicks = paint;
        this.firePropertyChange("paintMajorTicks", oldValue, this.myPaintMajorTicks);
    }

    public boolean getPaintMinorTicks() {
        return this.myPaintMinorTicks;
    }

    public int getMinorTickLength() {
        return this.myMinorTickLength;
    }

    public int getMajorTickLength() {
        return this.myMajorTickLength;
    }

    public T getMinorTickSpacing() {
        return this.myMinorTickSpacing;
    }

    public void setMinorTickSpacing(T minorTickSpacing) {
        T oldValue = this.myMinorTickSpacing;
        this.myMinorTickSpacing = minorTickSpacing;
        this.firePropertyChange("paintMinorTicks", oldValue, this.myMinorTickSpacing);
    }

    public void setText(String text) {
        String oldValue = this.myText;
        this.myText = text;
        this.firePropertyChange("text", oldValue, this.myText);
    }

    public String getText() {
        return this.myText;
    }

    public boolean isValueDisplayed() {
        return this.myDisplayValue;
    }

    public void setValueIsDisplayed(boolean displayValue) {
        boolean oldValue = displayValue;
        this.myDisplayValue = displayValue;
        this.firePropertyChange("valueIsDisplayed", oldValue, this.myDisplayValue);
    }

    public void setValueFormatter(InternationalFormatter formatter) {
        InternationalFormatter oldValue = this.myValueFormatter;
        this.myValueFormatter = formatter;
        this.firePropertyChange("valueFormatter", oldValue, this.myValueFormatter);
    }

    public int getInnerMargin() {
        return this.myInnerMargin;
    }

    public void setInnerMargin(int innerMargin) {
        int oldValue = this.myInnerMargin;
        this.myInnerMargin = innerMargin;
        this.firePropertyChange("innerMargin", oldValue, this.myInnerMargin);
    }

    private static NumberFormatter createDoubleFormatter(int maximumfractionDigits, int minfractionDigits) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMinimumFractionDigits(minfractionDigits);
        format.setMaximumFractionDigits(maximumfractionDigits);
        format.setGroupingUsed(false);
        return new NumberFormatter(format);
    }

    private static NumberFormatter createIntegerFormatter() {
        return Speedometer.createDoubleFormatter(0, 0);
    }

    public double getMinAngle() {
        return this.myMinAngle;
    }

    public void setMinAngle(double minAngle) {
        double oldValue = this.myMinAngle;
        this.myMinAngle = minAngle;
        this.firePropertyChange("minAngle", oldValue, this.myMinAngle);
    }

    public double getMaxAngle() {
        return this.myMaxAngle;
    }

    public void setMaxAngle(double maxAngle) {
        double oldValue = this.myMaxAngle;
        this.myMaxAngle = maxAngle;
        this.firePropertyChange("maxAngle", oldValue, this.myMaxAngle);
    }

    public Font getCurrentValueFont() {
        return this.myCurrentValueFont;
    }

    public void setCurrentValueFont(Font currentValueFont) {
        Font oldValue = this.myCurrentValueFont;
        this.myCurrentValueFont = currentValueFont;
        this.firePropertyChange("currentValueFont", oldValue, this.myCurrentValueFont);
    }

    public Font getTextFont() {
        return this.myTextFont;
    }

    public void setTextFont(Font textFont) {
        Font oldValue = this.myTextFont;
        this.myTextFont = textFont;
        this.firePropertyChange("textFont", oldValue, this.myTextFont);
    }
}

