/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.speedometer;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.painters.ConicalGradientPaint;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.speedometer.Speedometer;
import com.nokia.widgets.util.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;

public class SpeedometerUI<T extends Number>
extends ComponentUI
implements PropertyChangeListener,
ActionListener {
    private static final BasicStroke POINTER_STROKE = new BasicStroke(4.0f);
    private static final BasicStroke BORDER_STROKE = new BasicStroke(2.0f);
    private static final Color[] LEGEND_ALPHA = new Color[]{NetUtils.getColor(Color.RED, 215), NetUtils.getColor(Color.RED, 60), NetUtils.getColor(Color.RED, 0)};
    private static final Color[] LEGEND_COLORS = new Color[]{Color.YELLOW, Color.RED, NetUtils.getColor(Color.RED, 0), NetUtils.getColor(Color.GREEN, 0), Color.GREEN};
    private static Color[] INNER_GLOW_FILTER = new Color[]{NetUtils.getColor(Color.RED, 0), NetUtils.getColor(Color.RED, 80), NetUtils.getColor(Color.RED, 120)};
    private Speedometer<T> mySpeedometer;
    private Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private BufferedImage myInnerGlowImage;
    private BufferedImage myBackgroundImage;
    private Timer myTimer = new Timer(6, this);
    private double myAnimatedThetaValue = -1.0;
    private double myAnimationStep;
    private BasicStroke myMajorTickStroke = new BasicStroke(3.0f, 1, 1);
    private BasicStroke myMinorTickStroke = new BasicStroke(1.0f, 1, 1);

    @Override
    public void installUI(JComponent c) {
        this.mySpeedometer = (Speedometer)c;
        this.mySpeedometer.addPropertyChangeListener(this);
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.mySpeedometer.removePropertyChangeListener(this);
        this.mySpeedometer = null;
    }

    @Override
    public void paint(Graphics g, JComponent speedometer) {
        NetUtils.antiAliasingOn(g);
        super.paint(g, speedometer);
        Insets insets = this.getInsets(this.mySpeedometer);
        g.translate(insets.left, insets.right);
        this.paintBackground(g);
        this.paintText(g);
        g.setColor(this.mySpeedometer.getForeground());
        this.paintLabelsAndTicks(g);
        this.paintPointer(g);
        if (this.mySpeedometer.isOuterGlowShown()) {
            this.paintInnerGlow(g);
        }
    }

    private void paintInnerGlow(Graphics g) {
        int radius = this.mySpeedometer.getRadius();
        int innerGlowSize = radius * 2 + 3;
        Graphics2D imgG = null;
        if (this.myInnerGlowImage == null || this.myInnerGlowImage.getWidth() != innerGlowSize) {
            this.myInnerGlowImage = ImageUtils.createCompatibleTranslucentImage(innerGlowSize, innerGlowSize);
            imgG = this.myInnerGlowImage.createGraphics();
            NetUtils.antiAliasingOn(imgG);
            ConicalGradientPaint gradientPaint = new ConicalGradientPaint(new Point(radius, radius), new float[]{0.0f, 0.35f, 0.4f, 0.6f, 0.65f}, LEGEND_COLORS);
            imgG.setPaint(gradientPaint);
            imgG.fillOval(0, 0, this.myInnerGlowImage.getWidth(), this.myInnerGlowImage.getHeight());
            imgG.setComposite(AlphaComposite.DstIn);
            float[] fractions2 = new float[]{0.5f, 0.9f, 1.0f};
            imgG.setPaint(new RadialGradientPaint(radius, (float)radius, radius, fractions2, INNER_GLOW_FILTER));
            imgG.fillOval(-1, -1, 2 * radius + 2, 2 * radius + 2);
            this.myInnerGlowImage.flush();
            imgG.dispose();
        }
        g.drawImage(this.myInnerGlowImage, -1, -1, null);
    }

    private void paintText(Graphics g) {
        String text;
        NetUtils.antiAliasingOff(g);
        NetLookAndFeel.toggleTextAntialiasing(g);
        int radius = this.mySpeedometer.getRadius();
        g.translate(radius, radius);
        if (this.mySpeedometer.isValueDisplayed()) {
            this.paintCurrentValue(g, radius);
        }
        if ((text = this.mySpeedometer.getText()) != null && !text.trim().isEmpty()) {
            this.paintText(g, radius, text);
        }
        NetUtils.antiAliasingOn(g);
        g.translate(-radius, -radius);
    }

    private void paintText(Graphics g, int radius, String text) {
        g.setFont(this.mySpeedometer.getTextFont());
        Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(text, g);
        g.translate((int)(-stringBounds.getWidth() / 2.0), (int)stringBounds.getHeight());
        g.setColor(Color.BLACK);
        g.drawString(text, -1, (int)(0.63 * (double)radius + 1.0));
        g.setColor(this.mySpeedometer.getForeground());
        g.drawString(text, -1, (int)(0.63 * (double)radius + 1.0));
        g.translate((int)(stringBounds.getWidth() / 2.0), (int)(-stringBounds.getHeight()));
    }

    private void paintCurrentValue(Graphics g, int radius) {
        g.setFont(this.mySpeedometer.getCurrentValueFont());
        String value = this.mySpeedometer.getFormattedValue(((Number)this.mySpeedometer.getValue()).doubleValue());
        Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(value, g);
        g.translate((int)(-stringBounds.getWidth() / 2.0), 0);
        g.setColor(Color.BLACK);
        g.drawString(value, -1, (int)(0.61 * (double)radius + 1.0));
        g.setColor(this.mySpeedometer.getForeground());
        g.drawString(value, -1, (int)(0.61 * (double)radius));
        g.translate((int)(stringBounds.getWidth() / 2.0), 0);
    }

    private void paintBackground(Graphics g) {
        Insets insets = this.getInsets(this.mySpeedometer);
        int compWidth = this.mySpeedometer.getWidth();
        int compHeight = this.mySpeedometer.getHeight();
        if (this.myBackgroundImage == null || this.myBackgroundImage.getWidth() != compWidth || this.myBackgroundImage.getHeight() != compHeight) {
            this.myBackgroundImage = ImageUtils.createCompatibleTranslucentImage(compWidth, compHeight);
            Graphics2D g2 = this.myBackgroundImage.createGraphics();
            NetUtils.antiAliasingOn(g2);
            Paint oldPaint = g2.getPaint();
            if (this.mySpeedometer.isOuterGlowShown()) {
                this.paintOuterGlow(g2, compWidth, compHeight);
            }
            g2.translate(insets.left, insets.right);
            g2.setColor(new Color(86988));
            int width = 2 * this.mySpeedometer.getRadius() + 1;
            int height = 2 * this.mySpeedometer.getRadius() + 1;
            g2.fillOval(0, 0, width, height);
            Paint paint = new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.4f), 0.0f, height, new Color(0.0f, 0.0f, 0.0f, 0.0f));
            g2.setPaint(paint);
            g2.fillOval(0, 0, width - 1, height - 1);
            paint = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f), 0.0f, height, new Color(1.0f, 1.0f, 1.0f, 0.4f));
            g2.setPaint(paint);
            g2.fillOval(0, 0, width - 1, height - 1);
            paint = new RadialGradientPaint(new Point2D.Double((double)width / 2.0, (double)height / 2.0), (float)width / 2.0f, new float[]{0.0f, 1.0f}, new Color[]{new Color(6, 76, 160, 127), new Color(0.0f, 0.0f, 0.0f, 0.8f)});
            g2.setPaint(paint);
            g2.fillOval(0, 0, width - 1, height - 1);
            paint = new RadialGradientPaint(new Point2D.Double((double)width / 2.0, (double)height * 2.4), (float)width / 2.3f, new Point2D.Double((double)width / 2.0, (double)height * 2.65 + 6.0), new float[]{0.0f, 0.8f}, new Color[]{new Color(64, 142, 225, 150), new Color(64, 142, 225, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, AffineTransform.getScaleInstance(0.95, 0.34));
            g2.setPaint(paint);
            paint = new RadialGradientPaint(new Point2D.Double((double)width / 2.0, (double)height / 2.0), (float)width / 1.4f, new Point2D.Double(45.0, 25.0), new float[]{0.0f, 0.5f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 1.0f, 1.0f, 0.0f)}, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            g2.setPaint(paint);
            g2.fillOval(0, 0, width - 1, height - 1);
            g2.setPaint(oldPaint);
            g2.setColor(this.mySpeedometer.getBackground());
            int radius = this.mySpeedometer.getRadius();
            g2.translate(radius, radius);
            Color pointerColor = this.mySpeedometer.getPointerColor();
            g2.setPaint(new RadialGradientPaint(0.0f, 0.0f, 20.0f, new float[]{0.27f, 0.99f}, new Color[]{NetUtils.getColor(pointerColor, 234), NetUtils.getColor(pointerColor, 4)}));
            g2.fillOval(-20, -20, 40, 40);
            g2.translate(-radius, -radius);
            g2.translate(-insets.left, -insets.top);
            g2.setColor(Color.WHITE);
            g2.setStroke(BORDER_STROKE);
            g2.drawOval(insets.top, insets.left, this.mySpeedometer.getRadius() * 2, this.mySpeedometer.getRadius() * 2);
            g2.translate(insets.left, insets.top);
            g2.dispose();
        }
        g.drawImage(this.myBackgroundImage, -insets.top, -insets.left, null);
    }

    private void paintOuterGlow(Graphics2D g, int width, int height) {
        NetUtils.antiAliasingOn(g);
        Paint oldPaint = g.getPaint();
        ConicalGradientPaint paint = new ConicalGradientPaint(new Point(width / 2, height / 2), new float[]{0.0f, 0.35f, 0.4f, 0.6f, 0.65f}, LEGEND_COLORS);
        Composite oldComposite = g.getComposite();
        g.setPaint(paint);
        g.fill(new Arc2D.Float(0.0f, 0.0f, width, height, -90.0f, 360.0f, 2));
        g.setComposite(AlphaComposite.DstIn);
        float frac = (float)this.mySpeedometer.getBorder().getBorderInsets(this.mySpeedometer).top / (float)(this.mySpeedometer.getWidth() / 2);
        float[] fractions = new float[]{1.0f - frac, 1.0f - 0.5f * frac, 1.0f};
        g.setPaint(new RadialGradientPaint(width / 2, (float)(height / 2), height / 2, fractions, LEGEND_ALPHA));
        g.fillOval(-1, -1, width + 2, height + 2);
        g.setPaint(oldPaint);
        g.setComposite(oldComposite);
    }

    private void paintPointer(Graphics g) {
        double theta = this.myTimer.isRunning() ? this.myAnimatedThetaValue : this.getThetaForValue(((Number)this.mySpeedometer.getValue()).doubleValue());
        int radius = this.mySpeedometer.getRadius();
        int pointerLength = radius - 10;
        Color color = this.mySpeedometer.getPointerColor();
        g.setColor(color);
        g.translate(radius, radius);
        int centerSize = 18;
        g.fillOval(-centerSize / 2, -centerSize / 2, centerSize, centerSize);
        this.paintPointerShaft(g, theta, color, centerSize);
        g.setColor(NetUtils.getColor(color, 90));
        ((Graphics2D)g).setStroke(POINTER_STROKE);
        int innerRadiusX = (int)((double)pointerLength * Math.cos(theta));
        int innerRadiusY = (int)((double)pointerLength * Math.sin(theta));
        g.drawLine(0, 0, innerRadiusX, innerRadiusY);
        ((Graphics2D)g).setStroke(BORDER_STROKE);
        g.setColor(color);
        g.drawLine(0, 0, innerRadiusX, innerRadiusY);
        g.translate(-radius, -radius);
    }

    private void paintPointerShaft(Graphics g, double theta, Color color, int centerSize) {
        int shaftEndX = (int)((double)(centerSize * 2) * Math.cos(theta));
        int shaftEndY = (int)((double)(centerSize * 2) * Math.sin(theta));
        int shaftEndX2 = (int)((double)(centerSize / 2) * Math.cos(theta - 1.5707963267948966));
        int shaftEndY2 = (int)((double)(centerSize / 2) * Math.sin(theta - 1.5707963267948966));
        g.setColor(NetUtils.getColor(color, 110));
        int[] nArray = new int[3];
        nArray[1] = shaftEndX;
        nArray[2] = shaftEndX2;
        int[] nArray2 = new int[3];
        nArray2[1] = shaftEndY;
        nArray2[2] = shaftEndY2;
        g.fillPolygon(nArray, nArray2, 3);
        int shaftEndX3 = (int)((double)((centerSize + 2) / 2) * Math.cos(theta + 1.5707963267948966));
        int shaftEndY3 = (int)((double)((centerSize + 2) / 2) * Math.sin(theta + 1.5707963267948966));
        int[] nArray3 = new int[3];
        nArray3[1] = shaftEndX;
        nArray3[2] = shaftEndX3;
        int[] nArray4 = new int[3];
        nArray4[1] = shaftEndY;
        nArray4[2] = shaftEndY3;
        g.fillPolygon(nArray3, nArray4, 3);
    }

    public void paintLabelsAndTicks(Graphics g) {
        double maxValue = this.mySpeedometer.getMaximum().doubleValue();
        double minValue = this.mySpeedometer.getMinimum().doubleValue();
        double tickSpacing = ((Number)this.mySpeedometer.getTickSpacing()).doubleValue();
        FontMetrics fm = g.getFontMetrics();
        g.setFont(this.mySpeedometer.getFont());
        if (this.mySpeedometer.getPaintLabels() || this.mySpeedometer.getPaintMajorTicks()) {
            double value = minValue;
            while (value <= maxValue + 0.001) {
                double theta = this.getThetaForValue(value);
                if (this.mySpeedometer.getPaintLabels()) {
                    this.paintLabel(g, fm, value, theta);
                }
                if (this.mySpeedometer.getPaintMajorTicks()) {
                    this.paintTick(g, theta, true);
                }
                value += tickSpacing;
            }
        }
        if (this.mySpeedometer.getPaintMinorTicks()) {
            double minorSpacing = ((Number)this.mySpeedometer.getMinorTickSpacing()).doubleValue();
            double value = this.mySpeedometer.getMinimum().doubleValue();
            while (value <= this.mySpeedometer.getMaximum().doubleValue()) {
                this.paintTick(g, this.getThetaForValue(value), false);
                value += minorSpacing;
            }
        }
    }

    private int getInnerRadius() {
        return this.mySpeedometer.getRadius() - this.mySpeedometer.getMajorTickLength() - this.mySpeedometer.getInnerMargin();
    }

    protected void paintLabel(Graphics g, FontMetrics fm, double value, double theta) {
        int x = (int)((double)this.getInnerRadius() * Math.cos(theta));
        int y = (int)((double)this.getInnerRadius() * Math.sin(theta));
        int radius = this.mySpeedometer.getRadius();
        g.translate(radius, radius);
        String formattedTickLabel = this.mySpeedometer.getFormattedTickLabel(value);
        Rectangle2D stringBounds = fm.getStringBounds(formattedTickLabel, g);
        NetUtils.antiAliasingOff(g);
        NetLookAndFeel.toggleTextAntialiasing(g);
        int offset = 0;
        if (theta < 0.0 && theta > -1.5707963267948966) {
            double diff = (1.5707963267948966 - Math.abs(theta)) / 1.5707963267948966;
            offset = (int)(-8.0 * diff);
        }
        if (theta > 0.0) {
            offset = -11;
        }
        g.drawString(formattedTickLabel, (int)((double)x - stringBounds.getWidth() / 2.0) + offset, (int)((double)y + stringBounds.getHeight() / 2.0) - 3);
        NetUtils.antiAliasingOn(g);
        g.translate(-radius, -radius);
    }

    private void paintTick(Graphics g, double theta, boolean isMajor) {
        int radius = this.mySpeedometer.getRadius();
        int tickLength = isMajor ? this.mySpeedometer.getMajorTickLength() : this.mySpeedometer.getMinorTickLength();
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        int tickXStart = (int)((double)radius * cos);
        int tickYStart = (int)((double)radius * sin);
        int tickXEnd = (int)((double)(radius - tickLength) * cos);
        int tickYEnd = (int)((double)(radius - tickLength) * sin);
        g.translate(radius, radius);
        ((Graphics2D)g).setStroke(isMajor ? this.myMajorTickStroke : this.myMinorTickStroke);
        g.drawLine(tickXStart, tickYStart, tickXEnd, tickYEnd);
        g.translate(-radius, -radius);
    }

    protected double getThetaForValue(double value) {
        double min = this.mySpeedometer.getMinimum().doubleValue();
        double max = this.mySpeedometer.getMaximum().doubleValue();
        double minTheta = this.mySpeedometer.getMinAngle();
        double maxTheta = this.mySpeedometer.getMaxAngle();
        double extent = value - min;
        return Math.max(minTheta, Math.min(minTheta + extent / (max - min) * (maxTheta - minTheta), maxTheta));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int radius = this.mySpeedometer.getRadius();
        Insets insets = this.getInsets(c);
        return new Dimension(radius * 2 + insets.left + insets.right, radius * 2 + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    private Insets getInsets(JComponent c) {
        return this.mySpeedometer.getBorder() != null ? this.mySpeedometer.getBorder().getBorderInsets(c) : this.ZERO_INSETS;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.mySpeedometer == null) {
            return;
        }
        String propertyName = evt.getPropertyName();
        if ("radius".equals(propertyName)) {
            this.mySpeedometer.revalidate();
            this.mySpeedometer.repaint();
        } else if ("value".equals(propertyName)) {
            Number oldValue = (Number)evt.getOldValue();
            this.myAnimatedThetaValue = this.getThetaForValue(oldValue.doubleValue());
            Number targetValue = (Number)evt.getNewValue();
            double targetTheta = this.getThetaForValue(targetValue.doubleValue());
            double distance = targetTheta - this.myAnimatedThetaValue;
            double defaultStep = 0.039269908169872414;
            this.myAnimationStep = distance > 0.0 ? Math.max(defaultStep, distance / 60.0) : Math.min(-defaultStep, distance / 60.0);
            this.myTimer.restart();
        } else {
            if ("showOuterGlow".equals(propertyName) || "pointerColor".equals(propertyName)) {
                this.myBackgroundImage = null;
            }
            this.mySpeedometer.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double targetTheta = this.getThetaForValue(((Number)this.mySpeedometer.getValue()).doubleValue());
        if (this.myAnimationStep > 0.0) {
            if (this.myAnimatedThetaValue + this.myAnimationStep < targetTheta) {
                this.myAnimatedThetaValue = this.myAnimatedThetaValue + 4.0 * this.myAnimationStep > targetTheta ? (this.myAnimatedThetaValue += 0.5 * this.myAnimationStep) : (this.myAnimatedThetaValue += this.myAnimationStep);
            } else {
                this.myTimer.stop();
            }
        } else if (this.myAnimatedThetaValue + this.myAnimationStep > targetTheta) {
            this.myAnimatedThetaValue = this.myAnimatedThetaValue + 4.0 * this.myAnimationStep < targetTheta ? (this.myAnimatedThetaValue += 0.5 * this.myAnimationStep) : (this.myAnimatedThetaValue += this.myAnimationStep);
        } else {
            this.myTimer.stop();
        }
        this.mySpeedometer.repaint();
    }
}

