/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.spinner;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.spinner.SpinnerDoubleEditor;
import com.nokia.widgets.spinner.SpinnerDoubleModel;
import com.nokia.widgets.spinner.SpinnerIntegerEditor;
import com.nokia.widgets.spinner.SpinnerIntegerModel;
import com.nokia.widgets.spinner.SpinnerLongEditor;
import com.nokia.widgets.spinner.SpinnerLongModel;
import com.nokia.widgets.spinner.SpinnerNumberEditor;
import com.nokia.widgets.text.PTextComponent;
import com.nokia.widgets.text.PValidationListener;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;

public class PSpinner
extends JSpinner
implements PTextComponent {
    private static final Action DISABLED_ACTION = new DisabledAction();
    private boolean myTextFieldExplicitlySet = false;

    public PSpinner() {
    }

    public PSpinner(SpinnerModel model) {
        super(model);
    }

    public PSpinner(JFormattedTextField textField) {
        this.setTextFieldToEditor(textField);
    }

    public PSpinner(SpinnerModel model, JFormattedTextField textField) {
        super(model);
        this.setTextFieldToEditor(textField);
    }

    public void setSizeVariant(String sizeVariant) {
        this.putClientProperty("JComponent.sizeVariant", sizeVariant);
    }

    public void setReadOnly(boolean readOnly) {
        this.putClientProperty("OrangeTouch.readOnly", readOnly);
    }

    public boolean isReadOnly() {
        return ClientPropertyUtil.booleanValue(this, "OrangeTouch.readOnly");
    }

    @Override
    public void setEditor(JComponent editor) {
        JComponent oldEditor = this.getEditor();
        if (oldEditor instanceof SpinnerNumberEditor) {
            ((SpinnerNumberEditor)oldEditor).dismiss(this);
        }
        super.setEditor(editor);
        if (this.myTextFieldExplicitlySet && oldEditor instanceof JSpinner.DefaultEditor && editor instanceof JSpinner.DefaultEditor) {
            this.setTextFieldToEditor(((JSpinner.DefaultEditor)oldEditor).getTextField());
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected JComponent createEditor(SpinnerModel model) {
        if (model instanceof SpinnerDoubleModel) {
            SpinnerDoubleModel doubleModel = (SpinnerDoubleModel)model;
            double minimum = (Double)doubleModel.getMinimum();
            double stepSize = (Double)doubleModel.getStepSize();
            double maximum = (Double)doubleModel.getMaximum();
            return new SpinnerDoubleEditor(this, doubleModel.getMaxDecimals(), minimum, maximum, stepSize, doubleModel.isNonSequenceValuesAllowed());
        }
        if (model instanceof SpinnerIntegerModel) {
            SpinnerIntegerModel integerModel = (SpinnerIntegerModel)model;
            int minimum = (Integer)integerModel.getMinimum();
            int maximum = (Integer)integerModel.getMaximum();
            int stepSize = (Integer)integerModel.getStepSize();
            return new SpinnerIntegerEditor(this, minimum, maximum, stepSize, integerModel.isNonSequenceValuesAllowed());
        }
        if (model instanceof SpinnerLongModel) {
            SpinnerLongModel longModel = (SpinnerLongModel)model;
            long minimum = (Long)longModel.getMinimum();
            long maximum = (Long)longModel.getMaximum();
            long stepSize = (Long)longModel.getStepSize();
            return new SpinnerLongEditor(this, minimum, maximum, stepSize, longModel.isNonSequenceValuesAllowed());
        }
        return super.createEditor(model);
    }

    public void setUnmodifiedValue(Object unmodifiedValue) {
        this.putClientProperty("BlueTouch.unmodifiedValue", unmodifiedValue);
    }

    public Object getUnmodifiedValue() {
        return this.getClientProperty("BlueTouch.unmodifiedValue");
    }

    public boolean isModified() {
        return Boolean.TRUE.equals(this.getClientProperty("BlueTouch.isModified"));
    }

    public void setValueComparator(Comparator<?> comparator) {
        this.putClientProperty(ClientProperties.VALUE_COMPARATOR, comparator);
    }

    @Override
    public Object getNextValue() {
        Object value = super.getNextValue();
        if (value == null) {
            this.flashField();
        }
        return value;
    }

    @Override
    public Object getPreviousValue() {
        Object value = super.getPreviousValue();
        if (value == null) {
            this.flashField();
        }
        return value;
    }

    public void setTextFieldToEditor(JFormattedTextField textField) {
        if (textField == null) {
            throw new IllegalArgumentException("Cannot set null text field to spinner editor.");
        }
        JFormattedTextField toBeRemoved = (JFormattedTextField)this.getEditor().getComponents()[0];
        if (textField == toBeRemoved) {
            return;
        }
        toBeRemoved.removePropertyChangeListener((JSpinner.DefaultEditor)this.getEditor());
        this.getEditor().removeAll();
        this.configureTextField(toBeRemoved, textField);
        textField.addPropertyChangeListener((JSpinner.DefaultEditor)this.getEditor());
        this.getEditor().add(textField);
        ActionMap ftfMap = textField.getActionMap();
        if (ftfMap != null) {
            ftfMap.put("increment", DISABLED_ACTION);
            ftfMap.put("decrement", DISABLED_ACTION);
        }
        this.firePropertyChange("textField", toBeRemoved, textField);
        this.myTextFieldExplicitlySet = true;
        this.revalidate();
        this.repaint();
    }

    protected void configureTextField(JFormattedTextField oldTextField, JFormattedTextField newTextField) {
        newTextField.setName(oldTextField.getName());
        newTextField.setValue(oldTextField.getValue());
        newTextField.setToolTipText(oldTextField.getToolTipText());
        newTextField.setHorizontalAlignment(oldTextField.getHorizontalAlignment());
        newTextField.setColumns(oldTextField.getColumns());
        newTextField.setFormatterFactory(oldTextField.getFormatterFactory());
    }

    public void setColumns(int columns) {
        if (this.getEditor() instanceof JSpinner.DefaultEditor) {
            JFormattedTextField field = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
            field.setColumns(columns);
        } else if (this.getEditor() instanceof JTextField) {
            ((JTextField)this.getEditor()).setColumns(columns);
        }
    }

    public PTextComponent getTextComponent() {
        if (this.getEditor() instanceof JSpinner.DefaultEditor) {
            JFormattedTextField field = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
            if (field instanceof PTextComponent) {
                return (PTextComponent)((Object)field);
            }
        } else if (this.getEditor() instanceof PTextComponent) {
            return (PTextComponent)((Object)this.getEditor());
        }
        return null;
    }

    @Override
    public void addValidationListener(PValidationListener listener) {
        if (this.getTextComponent() != null) {
            this.getTextComponent().addValidationListener(listener);
        }
    }

    @Override
    public void removeValidationListener(PValidationListener listener) {
        if (this.getTextComponent() != null) {
            this.getTextComponent().removeValidationListener(listener);
        }
    }

    @Override
    public void setMandatoryEntry(boolean mandatory) {
        if (this.getTextComponent() != null) {
            this.getTextComponent().setMandatoryEntry(mandatory);
        }
    }

    @Override
    public boolean isMandatoryEntry() {
        if (this.getTextComponent() != null) {
            this.getTextComponent().isMandatoryEntry();
        }
        return false;
    }

    @Override
    public boolean isMissing() {
        if (this.getTextComponent() != null) {
            this.getTextComponent().isMissing();
        }
        return false;
    }

    @Override
    public void flashField() {
        if (this.getTextComponent() != null) {
            this.getTextComponent().flashField();
        }
    }

    private static class DisabledAction
    implements Action {
        private DisabledAction() {
        }

        @Override
        public Object getValue(String key) {
            return null;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }
}

