/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.spinner;

import com.nokia.widgets.spinner.PSpinner;
import com.nokia.widgets.spinner.SpinnerNumberEditor;
import com.nokia.widgets.text.DecimalDocument;
import com.nokia.widgets.text.DiscontinuousNumberRangeValidator;
import com.nokia.widgets.text.NumberRangeValidator;
import com.nokia.widgets.text.TextFieldValidationUtils;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class SpinnerDoubleEditor
extends SpinnerNumberEditor {
    private NumberRangeValidator myValidator;
    private DecimalDocument myDocument;

    public SpinnerDoubleEditor(PSpinner spinner, int maxDecimDigits, double minValue, double maxValue, double step) {
        this(spinner, maxDecimDigits, minValue, maxValue, step, false);
    }

    public SpinnerDoubleEditor(PSpinner spinner, int maxDecimDigits, double minValue, double maxValue, double step, boolean allowNonSequenceValues) {
        super(spinner);
        this.setColumns(TextFieldValidationUtils.getColumns(maxDecimDigits, minValue, maxValue, new double[0]));
        this.myValidator = allowNonSequenceValues ? new NumberRangeValidator(minValue, maxValue) : new DiscontinuousNumberRangeValidator(minValue, maxValue, step);
        this.addValidationListener(this.myValidator);
        this.myDocument = new DecimalDocument(maxDecimDigits, minValue, maxValue);
        BigDecimal newValue = (BigDecimal)spinner.getValue();
        if (newValue != null) {
            this.myDocument.setValue(newValue);
        }
        this.myDocument.addDocumentListener(this);
        this.setDocument(this.myDocument);
    }

    @Override
    protected int getColumnWidth() {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        return metrics.charWidth('0') + 1;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner = (JSpinner)e.getSource();
        Object value = spinner.getValue();
        if (spinner.getModel() instanceof SpinnerNumberModel) {
            SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
            Double min = (Double)model.getMinimum();
            Double max = (Double)model.getMaximum();
            if (!new Double(this.myValidator.getMinValue()).equals(min) && min instanceof Double) {
                double minValue = min;
                this.myValidator.setMinValue(minValue);
                this.myDocument.setMinValue(minValue);
            }
            if (!new Double(this.myValidator.getMaxValue()).equals(max) && max instanceof Double) {
                double maxValue = max;
                this.myValidator.setMaxValue(maxValue);
                this.myDocument.setMaxValue(maxValue);
            }
        }
        if (this.getDocument() instanceof DecimalDocument && value != null) {
            ((DecimalDocument)this.getDocument()).setValue((BigDecimal)value);
        } else {
            super.stateChanged(e);
        }
    }

    @Override
    protected void setSpinnerValue(JSpinner spinner, String text) {
        spinner.setValue(Double.valueOf(text));
    }
}

