/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.spinner;

import java.math.BigDecimal;
import javax.swing.SpinnerNumberModel;

public class SpinnerDoubleModel
extends SpinnerNumberModel {
    private int myMaxDecimals;
    private BigDecimal myValue;
    private boolean myNonSequenceValuesAllowed = false;

    public SpinnerDoubleModel(double value, double minimum, double maximum, double stepSize, int maxDecimals) {
        this(value, minimum, maximum, stepSize, maxDecimals, false);
    }

    public SpinnerDoubleModel(double value, double minimum, double maximum, double stepSize, int maxDecimals, boolean allowNonSequenceValues) {
        super(value, minimum, maximum, stepSize);
        this.myValue = BigDecimal.valueOf(value);
        this.myMaxDecimals = maxDecimals;
        this.myNonSequenceValuesAllowed = allowNonSequenceValues;
    }

    public int getMaxDecimals() {
        return this.myMaxDecimals;
    }

    public boolean isNonSequenceValuesAllowed() {
        return this.myNonSequenceValuesAllowed;
    }

    @Override
    public void setValue(Object value) {
        if (value == null && this.myValue == null) {
            return;
        }
        if (value != null && value.equals(this.myValue)) {
            return;
        }
        if (value instanceof Double) {
            this.myValue = BigDecimal.valueOf((Double)value);
            this.fireStateChanged();
        } else if (value instanceof BigDecimal) {
            this.myValue = (BigDecimal)value;
            this.fireStateChanged();
        } else if (value == null) {
            this.myValue = null;
            this.fireStateChanged();
        }
    }

    @Override
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public Number getNumber() {
        return this.myValue;
    }

    @Override
    public Object getNextValue() {
        if (this.myValue == null) {
            return this.getMinimum();
        }
        return this.incrementValue(1);
    }

    @Override
    public Object getPreviousValue() {
        if (this.myValue == null) {
            return this.getMaximum();
        }
        return this.incrementValue(-1);
    }

    private BigDecimal incrementValue(int dir) {
        BigDecimal value = (BigDecimal)this.getValue();
        BigDecimal stepSize = BigDecimal.valueOf((Double)this.getStepSize());
        BigDecimal maximum = BigDecimal.valueOf((Double)this.getMaximum());
        BigDecimal minimum = BigDecimal.valueOf((Double)this.getMinimum());
        BigDecimal newValue = value.add(stepSize.multiply(BigDecimal.valueOf(dir)));
        BigDecimal diff = newValue.subtract(minimum);
        BigDecimal remainder = diff.remainder(stepSize);
        int compare = remainder.compareTo(BigDecimal.ZERO);
        if (compare != 0) {
            newValue = dir > 0 ? (compare > 0 ? newValue.subtract(remainder) : newValue.subtract(stepSize.add(remainder))) : (compare > 0 ? newValue.add(stepSize.subtract(remainder)) : newValue.subtract(remainder));
        }
        newValue = newValue.setScale(this.myMaxDecimals, 5);
        if (maximum != null && maximum.compareTo(newValue) < 0) {
            return null;
        }
        if (minimum != null && minimum.compareTo(newValue) > 0) {
            if (dir < 0) {
                return null;
            }
            return minimum;
        }
        return newValue;
    }
}

