/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.spinner;

import com.nokia.widgets.spinner.SpinnerNumberEditor;
import com.nokia.widgets.text.DiscontinuousNumberRangeValidator;
import com.nokia.widgets.text.IntegerDocument;
import com.nokia.widgets.text.NumberRangeValidator;
import javax.swing.JSpinner;

public class SpinnerIntegerEditor
extends SpinnerNumberEditor {
    public SpinnerIntegerEditor(JSpinner spinner, int minValue, int maxValue, int stepSize) {
        this(spinner, minValue, maxValue, stepSize, false);
    }

    public SpinnerIntegerEditor(JSpinner spinner, int minValue, int maxValue, int stepSize, boolean allowNonSequenceValues) {
        super(spinner);
        if (allowNonSequenceValues) {
            this.addValidationListener(new NumberRangeValidator(minValue, maxValue));
        } else {
            this.addValidationListener(new DiscontinuousNumberRangeValidator(minValue, maxValue, stepSize));
        }
        IntegerDocument doc = new IntegerDocument(minValue, maxValue);
        doc.setValue((Integer)spinner.getValue());
        doc.addDocumentListener(this);
        this.setDocument(doc);
    }

    @Override
    protected void setSpinnerValue(JSpinner spinner, String text) {
        spinner.setValue(Integer.valueOf(text));
    }
}

