/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.spinner;

import javax.swing.SpinnerNumberModel;

public class SpinnerIntegerModel
extends SpinnerNumberModel {
    private Integer myValue;
    private boolean myNonSequenceValuesAllowed = false;

    public SpinnerIntegerModel(int value, int minimum, int maximum, int stepSize) {
        this(value, minimum, maximum, stepSize, false);
    }

    public SpinnerIntegerModel(int value, int minimum, int maximum, int stepSize, boolean allowNonSequenceValues) {
        super(value, minimum, maximum, stepSize);
        this.myValue = value;
        this.myNonSequenceValuesAllowed = allowNonSequenceValues;
    }

    public SpinnerIntegerModel() {
        super((Number)0, null, null, (Number)1);
        this.myValue = 0;
    }

    public boolean isNonSequenceValuesAllowed() {
        return this.myNonSequenceValuesAllowed;
    }

    @Override
    public void setValue(Object value) {
        if (value == null && this.myValue == null) {
            return;
        }
        if (value != null && value.equals(this.myValue)) {
            return;
        }
        if (value instanceof Integer) {
            this.myValue = (Integer)value;
            this.fireStateChanged();
        } else if (value == null) {
            this.myValue = null;
            this.fireStateChanged();
        } else if (value instanceof String) {
            String string = (String)value;
            if ("".equals(string) && this.myValue != null) {
                this.myValue = null;
                this.fireStateChanged();
                return;
            }
            try {
                this.myValue = Integer.valueOf(value.toString());
                this.fireStateChanged();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Number getNumber() {
        return this.myValue;
    }

    @Override
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public Object getNextValue() {
        if (this.myValue == null) {
            return this.getMinimum();
        }
        return this.incrementValue(1);
    }

    @Override
    public Object getPreviousValue() {
        if (this.myValue == null) {
            return this.getMaximum();
        }
        return this.incrementValue(-1);
    }

    public Comparable<Integer> getMaximum() {
        return (Integer)super.getMaximum();
    }

    private Integer incrementValue(int dir) {
        Integer remainder;
        Integer newValue = this.myValue + this.getStepSize().intValue() * dir;
        int diff = this.myValue;
        if (this.getMinimum() instanceof Integer) {
            diff -= ((Integer)this.getMinimum()).intValue();
        }
        if ((remainder = Integer.valueOf(diff % this.getStepSize().intValue())) != 0) {
            newValue = dir > 0 ? Integer.valueOf(newValue - remainder) : Integer.valueOf(newValue + this.getStepSize().intValue() - remainder);
        }
        if (this.getMaximum() != null && this.getMaximum().compareTo(newValue) < 0) {
            return null;
        }
        if (this.getMinimum() != null && this.getMinimum().compareTo(newValue) > 0) {
            if (dir < 0) {
                return null;
            }
            return (Integer)this.getMinimum();
        }
        return newValue;
    }
}

