/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.spinner;

import com.nokia.widgets.spinner.SpinnerNumberEditor;
import com.nokia.widgets.text.DiscontinuousNumberRangeValidator;
import com.nokia.widgets.text.LongDocument;
import com.nokia.widgets.text.NumberRangeValidator;
import javax.swing.JSpinner;

public class SpinnerLongEditor
extends SpinnerNumberEditor {
    public SpinnerLongEditor(JSpinner spinner, long minValue, long maxValue, long stepSize) {
        this(spinner, minValue, maxValue, stepSize, false);
    }

    public SpinnerLongEditor(JSpinner spinner, long minValue, long maxValue, long stepSize, boolean allowNonSequenceValues) {
        super(spinner);
        NumberRangeValidator myValidator = this.getValidator(minValue, maxValue, stepSize, allowNonSequenceValues);
        LongDocument document = this.getDocument(spinner, minValue, maxValue);
        this.addValidationListener(myValidator);
        this.setDocument(document);
    }

    private LongDocument getDocument(JSpinner spinner, long minValue, long maxValue) {
        LongDocument document = new LongDocument(minValue, maxValue);
        document.setValue((Long)spinner.getValue());
        document.addDocumentListener(this);
        return document;
    }

    private NumberRangeValidator getValidator(long minValue, long maxValue, long stepSize, boolean allowNonSequenceValues) {
        if (allowNonSequenceValues) {
            return new NumberRangeValidator(minValue, maxValue);
        }
        return new DiscontinuousNumberRangeValidator(minValue, maxValue, stepSize);
    }

    @Override
    protected void setSpinnerValue(JSpinner spinner, String text) {
        spinner.setValue(Long.valueOf(text));
    }
}

