/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.spinner;

import javax.swing.SpinnerNumberModel;

public class SpinnerLongModel
extends SpinnerNumberModel {
    private Long myValue;
    private boolean myNonSequenceValuesAllowed = false;

    public SpinnerLongModel(long value, long minimum, long maximum, long stepSize) {
        this(value, minimum, maximum, stepSize, false);
    }

    public SpinnerLongModel(long value, long minimum, long maximum, long stepSize, boolean allowNonSequenceValues) {
        super(new Long(value), new Long(minimum), new Long(maximum), new Long(stepSize));
        this.myValue = value;
        this.myNonSequenceValuesAllowed = allowNonSequenceValues;
    }

    public SpinnerLongModel() {
        super((Number)0L, null, null, (Number)1L);
        this.myValue = 0L;
    }

    public boolean isNonSequenceValuesAllowed() {
        return this.myNonSequenceValuesAllowed;
    }

    @Override
    public void setValue(Object value) {
        if (value == null && this.myValue == null) {
            return;
        }
        if (value != null && value.equals(this.myValue)) {
            return;
        }
        if (value instanceof Long) {
            this.myValue = (Long)value;
            this.fireStateChanged();
        } else if (value == null) {
            this.myValue = null;
            this.fireStateChanged();
        } else if (value instanceof String) {
            String string = (String)value;
            if ("".equals(string) && this.myValue != null) {
                this.myValue = null;
                this.fireStateChanged();
                return;
            }
            try {
                this.myValue = Long.valueOf(value.toString());
                this.fireStateChanged();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Number getNumber() {
        return this.myValue;
    }

    @Override
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public Object getNextValue() {
        if (this.myValue == null) {
            return this.getMinimum();
        }
        return this.incrementValue(1L);
    }

    @Override
    public Object getPreviousValue() {
        if (this.myValue == null) {
            return this.getMaximum();
        }
        return this.incrementValue(-1L);
    }

    public Comparable<Long> getMaximum() {
        return super.getMaximum();
    }

    public Comparable<Long> getMinimum() {
        return super.getMinimum();
    }

    private Long incrementValue(long dir) {
        Long remainder;
        Long newValue = this.myValue + this.getStepSize().longValue() * dir;
        long diff = this.myValue;
        if (this.getMinimum() instanceof Long) {
            diff -= ((Long)this.getMinimum()).longValue();
        }
        if ((remainder = Long.valueOf(diff % this.getStepSize().longValue())) != 0L) {
            newValue = dir > 0L ? Long.valueOf(newValue - remainder) : Long.valueOf(newValue + this.getStepSize().longValue() - remainder);
        }
        if (this.getMaximum() != null && this.getMaximum().compareTo(newValue) < 0) {
            return null;
        }
        if (this.getMinimum() != null && this.getMinimum().compareTo(newValue) > 0) {
            if (dir < 0L) {
                return null;
            }
            return (Long)this.getMinimum();
        }
        return newValue;
    }
}

