/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.spinner;

import com.nokia.widgets.text.PTextField;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;

public abstract class SpinnerNumberEditor
extends PTextField
implements ChangeListener,
DocumentListener {
    private static final Action DISABLED_ACTION = new DisabledAction();

    public SpinnerNumberEditor(JSpinner spinner) {
        ActionMap textFieldActionMap;
        this.setValidateOnFocusLost(true);
        String toolTipText = spinner.getToolTipText();
        if (toolTipText != null) {
            this.setToolTipText(toolTipText);
        }
        if ((textFieldActionMap = this.getActionMap()) != null) {
            textFieldActionMap.put("increment", DISABLED_ACTION);
            textFieldActionMap.put("decrement", DISABLED_ACTION);
        }
        spinner.addChangeListener(this);
        SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
        this.setText(model.getValue().toString());
        NumberFormatter formatter = new NumberFormatter(NumberFormat.getNumberInstance(spinner.getLocale()));
        try {
            String maxString = formatter.valueToString(model.getMinimum());
            String minString = formatter.valueToString(model.getMaximum());
            this.setColumns(Math.max(maxString.length(), minString.length()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void dismiss(JSpinner spinner) {
        spinner.removeChangeListener(this);
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner = (JSpinner)e.getSource();
        Object value = spinner.getValue();
        this.setText(value != null ? value.toString() : "");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        JSpinner spinner = (JSpinner)this.getParent();
        Document doc = e.getDocument();
        String text = null;
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e1) {
            text = "";
        }
        if (text.length() == 0) {
            spinner.removeChangeListener(this);
            spinner.setValue(null);
            spinner.addChangeListener(this);
        } else {
            spinner.removeChangeListener(this);
            try {
                this.setSpinnerValue(spinner, text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            spinner.addChangeListener(this);
        }
    }

    protected abstract void setSpinnerValue(JSpinner var1, String var2);

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    private static class DisabledAction
    implements Action {
        private DisabledAction() {
        }

        @Override
        public Object getValue(String key) {
            return null;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }
}

