/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.splashscreen;

import com.nokia.laf.borders.DialogShadowBorder;
import com.nokia.widgets.splashscreen.SplashTimer;
import java.awt.Component;
import java.awt.Container;
import java.util.Calendar;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JWindow;
import javax.swing.border.CompoundBorder;

public class SplashScreen
extends JWindow
implements Observer {
    private SplashTimer myTimer;
    private Calendar myVisibleTimeStamp;
    private int displayTimeMillis = 2000;

    public SplashScreen() {
        this((Container)null);
    }

    public SplashScreen(Container content) {
        if (content != null) {
            this.add(content);
        }
        this.getRootPane().setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(), new DialogShadowBorder()));
    }

    public SplashScreen(Container content, int closingTime) {
        this.displayTimeMillis = closingTime;
        this.add(content);
        this.setTimer(this.displayTimeMillis);
    }

    public void setTimer(int timeInMillis) {
        this.displayTimeMillis = timeInMillis;
        if (this.myTimer != null) {
            this.myTimer.deleteObserver(this);
            this.myTimer = null;
        }
        this.myTimer = new SplashTimer(timeInMillis);
        this.myTimer.addObserver(this);
    }

    public void setVisibleImmediately(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public synchronized void setVisible(boolean visible) {
        if (visible) {
            this.myVisibleTimeStamp = Calendar.getInstance();
            this.setLocationRelativeTo(null);
            this.setVisibleImmediately(true);
        } else {
            long delta = Calendar.getInstance().getTimeInMillis() - this.myVisibleTimeStamp.getTimeInMillis();
            if (delta < (long)this.displayTimeMillis) {
                this.setTimer(this.displayTimeMillis);
            } else {
                this.setVisibleImmediately(false);
            }
        }
    }

    @Override
    public Component add(Component c) {
        super.add(c);
        this.pack();
        this.setLocationRelativeTo(null);
        return c;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setVisibleImmediately(false);
    }
}

