/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.systeminfo;

import com.nokia.widgets.systeminfo.SystemInfoInterface;
import java.util.Locale;

public class SystemInfo
implements SystemInfoInterface {
    private static SystemInfo theSystemInfo = new SystemInfo();

    private SystemInfo() {
    }

    public static SystemInfo getInstance() {
        return theSystemInfo;
    }

    @Override
    public String getOperatingSystem() {
        StringBuffer sb = new StringBuffer();
        sb.append(System.getProperty("os.name"));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        return sb.toString();
    }

    @Override
    public String getPatch() {
        return System.getProperty("sun.os.patch.level");
    }

    @Override
    public String getJre() {
        StringBuffer sb = new StringBuffer();
        if (System.getProperty("java.vm.name").toLowerCase().contains("openjdk")) {
            sb.append("OpenJDK ");
        }
        sb.append("JRE ");
        sb.append(System.getProperty("java.runtime.version"));
        return sb.toString();
    }

    @Override
    public String getLocale() {
        return Locale.getDefault().getDisplayName();
    }

    @Override
    public String getCpuString() {
        return System.getProperty("os.arch");
    }

    @Override
    public String getInstallationPath() {
        return System.getProperty("user.dir");
    }
}

