/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.systeminfo;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.labels.PStaticLabel;
import com.nokia.widgets.layout.PVerticalLayout;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.systeminfo.SystemInfo;
import com.nokia.widgets.systeminfo.SystemInfoController;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class SystemInfoView
extends JDialog {
    private static final int[] DEFAULT_BOUNDS = new int[]{400, 300};
    private PLabel myJavaLabel;
    private PStaticLabel myJavaValueLabel;
    private PLabel myLocaleLabel;
    private PStaticLabel myLocaleValueLabel;
    private PLabel myCpuLabel;
    private PStaticLabel myCpuValueLabel;
    private PLabel myOSLabel;
    private PStaticLabel myOSValueLabel;
    private PLabel myPatchLabel;
    private PStaticLabel myPatchValueLabel;
    private PLabel myPathLabel;
    private PStaticLabel myPathValueLabel;
    private SystemInfoController myController;
    private JButton myCloseButton;
    private JFrame myParentFrame;

    public SystemInfoView(SystemInfoController parentCtrl, JFrame parentFrame) {
        super(parentFrame);
        this.myController = parentCtrl;
        this.myParentFrame = parentFrame;
        this.buildUI();
        this.myCloseButton.requestFocus();
        this.pack();
    }

    private void buildUI() {
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints contentPaneConstraints = new GridBagConstraints();
        contentPaneConstraints.gridx = 0;
        contentPaneConstraints.gridy = 0;
        contentPaneConstraints.gridwidth = 0;
        contentPaneConstraints.gridheight = 1;
        contentPaneConstraints.weightx = 1.0;
        contentPaneConstraints.weighty = 1.0;
        contentPaneConstraints.fill = 1;
        PPanel upperPanel = new PPanel(new PVerticalLayout(4, 0, 0, 0));
        upperPanel.setPanelType(ClientProperties.PANEL_USER_BACKGROUND);
        upperPanel.setVisibleLowerEdge(true);
        contentPane.add((Component)upperPanel, contentPaneConstraints);
        this.setSize(new Dimension(DEFAULT_BOUNDS[0], DEFAULT_BOUNDS[1]));
        this.setResizable(false);
        this.setTitle(WidgetResources.getString("PSystemInfo.Title_Text"));
        PPanel listPanel = new PPanel(new GridBagLayout());
        upperPanel.add(listPanel);
        PPanel buttonPanel = new PPanel(new RowAlignLayout());
        buttonPanel.setPanelType(ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        contentPaneConstraints.weightx = 1.0;
        contentPaneConstraints.weighty = 0.0;
        contentPaneConstraints.gridy = -1;
        contentPaneConstraints.fill = 2;
        contentPane.add((Component)buttonPanel, contentPaneConstraints);
        buttonPanel.add(this.createCloseButton());
        buttonPanel.add((Component)this.createCopyButton(), "West");
        SystemInfo systemInfo = SystemInfo.getInstance();
        this.myJavaLabel = PLabel.createSystemText(WidgetResources.getString("PSystemInfo.Jre_Text"));
        this.myJavaValueLabel = new PStaticLabel(systemInfo.getJre());
        this.myLocaleLabel = PLabel.createSystemText(WidgetResources.getString("PSystemInfo.LocaleLabel_Text"));
        this.myLocaleValueLabel = new PStaticLabel(systemInfo.getLocale());
        this.myCpuLabel = PLabel.createSystemText(WidgetResources.getString("PSystemInfo.CPULabel_Text"));
        this.myCpuValueLabel = new PStaticLabel(systemInfo.getCpuString());
        this.myOSLabel = PLabel.createSystemText(WidgetResources.getString("PSystemInfo.OSLabel_Text"));
        this.myOSValueLabel = new PStaticLabel(systemInfo.getOperatingSystem());
        this.myPatchLabel = PLabel.createSystemText(WidgetResources.getString("PSystemInfo.PatchLabel_Text"));
        this.myPatchValueLabel = new PStaticLabel(systemInfo.getPatch());
        this.myPathLabel = PLabel.createSystemText(WidgetResources.getString("PSystemInfo.CurrentPathLabel_Text"));
        this.myPathValueLabel = new PStaticLabel(systemInfo.getInstallationPath());
        this.getRootPane().putClientProperty("OrangeTouch.isLightbox", true);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(12, 26, 5, 12);
        c.gridx = 0;
        c.gridy = 0;
        listPanel.add((Component)this.myJavaLabel, c);
        c.gridy = 1;
        c.insets = new Insets(0, 26, 5, 12);
        listPanel.add((Component)this.myLocaleLabel, c);
        c.gridy = 2;
        listPanel.add((Component)this.myCpuLabel, c);
        c.gridy = 3;
        listPanel.add((Component)this.myOSLabel, c);
        c.gridy = 4;
        listPanel.add((Component)this.myPatchLabel, c);
        c.gridy = 5;
        c.insets = new Insets(0, 26, 12, 12);
        listPanel.add((Component)this.myPathLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(12, 0, 5, 26);
        listPanel.add((Component)this.myJavaValueLabel, c);
        c.gridy = 1;
        c.insets = new Insets(0, 0, 5, 26);
        listPanel.add((Component)this.myLocaleValueLabel, c);
        c.gridy = 2;
        listPanel.add((Component)this.myCpuValueLabel, c);
        c.gridy = 3;
        listPanel.add((Component)this.myOSValueLabel, c);
        c.gridy = 4;
        listPanel.add((Component)this.myPatchValueLabel, c);
        c.gridy = 5;
        c.insets = new Insets(0, 0, 12, 26);
        listPanel.add((Component)this.myPathValueLabel, c);
        upperPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "EXIT");
        upperPanel.getActionMap().put("EXIT", new ExitAction());
        this.setPlace();
        this.pack();
        this.setModal(true);
    }

    private JButton createCopyButton() {
        JButton copyButton = new JButton();
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                SystemInfoView.this.myController.copyToClipboardRequest();
            }
        });
        copyButton.setText(WidgetResources.getString("CopyAction_Text"));
        copyButton.setMnemonic(WidgetResources.getMnemonic("CopyAction_Mnemonic"));
        copyButton.setToolTipText(WidgetResources.getString("PSystemInfo.CopyAction_Tooltip"));
        return copyButton;
    }

    private JButton createCloseButton() {
        this.myCloseButton = new JButton();
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                SystemInfoView.this.myController.hideRequest();
                SystemInfoView.this.setVisible(false);
            }
        });
        this.myCloseButton.setText(WidgetResources.getString("CloseAction_Text"));
        this.getRootPane().setDefaultButton(this.myCloseButton);
        return this.myCloseButton;
    }

    private void setPlace() {
        Rectangle parentBounds = null;
        if (this.myParentFrame != null) {
            parentBounds = this.myParentFrame.getBounds();
            Dimension size = this.getSize();
            int x = (parentBounds.width - size.width) / 2 + parentBounds.x;
            int y = (parentBounds.height - size.height) / 2 + parentBounds.y;
            this.setLocation(x, y);
        } else {
            this.setLocationRelativeTo(null);
        }
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.myJavaLabel.getText());
        sb.append(" ");
        sb.append(this.myJavaValueLabel.getText());
        sb.append(System.getProperty("line.separator"));
        sb.append(this.myLocaleLabel.getText());
        sb.append(" ");
        sb.append(this.myLocaleValueLabel.getText());
        sb.append(System.getProperty("line.separator"));
        sb.append(this.myCpuLabel.getText());
        sb.append(" ");
        sb.append(this.myCpuValueLabel.getText());
        sb.append(System.getProperty("line.separator"));
        sb.append(this.myOSLabel.getText());
        sb.append(" ");
        sb.append(this.myOSValueLabel.getText());
        sb.append(System.getProperty("line.separator"));
        sb.append(this.myPatchLabel.getText());
        sb.append(" ");
        sb.append(this.myPatchValueLabel.getText());
        sb.append(System.getProperty("line.separator"));
        sb.append(this.myPathLabel.getText());
        sb.append(" ");
        sb.append(this.myPathValueLabel.getText());
        return sb.toString();
    }

    private class ExitAction
    extends AbstractAction {
        private ExitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SystemInfoView.this.myController.hideRequest();
        }
    }
}

