/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.tabbutton;

import com.nokia.widgets.layout.PHorizontalLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class TabButtonPanel
extends JPanel {
    private List<JToggleButton> myButtonList;
    private ButtonGroup myButtonGroup;
    private boolean myWithButtonGroup = true;

    public TabButtonPanel() {
        PHorizontalLayout layout = new PHorizontalLayout();
        layout.setHGap(0);
        layout.setVMargin(0);
        layout.setHMargin(0);
        this.setLayout(layout);
        this.myButtonList = new ArrayList<JToggleButton>();
        this.myButtonGroup = new ButtonGroup();
    }

    public TabButtonPanel(List<JToggleButton> tabButtons) {
        this();
        this.addButtons(tabButtons);
    }

    public TabButtonPanel(List<JToggleButton> tabButtons, boolean withButtonGroup) {
        this();
        this.myWithButtonGroup = withButtonGroup;
        this.addButtons(tabButtons);
    }

    public void addButton(JToggleButton button) {
        if (this.myButtonList.isEmpty()) {
            button.putClientProperty("JToggleButton.segmentPosition", "only");
        } else {
            this.adjustBeforeAdd();
            button.putClientProperty("JToggleButton.segmentPosition", "last");
        }
        this.myButtonList.add(button);
        if (this.myWithButtonGroup) {
            this.myButtonGroup.add(button);
        }
        this.add(button);
    }

    public void addButtons(List<JToggleButton> buttons) {
        for (JToggleButton button : buttons) {
            this.addButton(button);
        }
    }

    private void adjustBeforeAdd() {
        if (this.myButtonList.size() == 1) {
            JToggleButton button = this.myButtonList.get(0);
            button.putClientProperty("JToggleButton.segmentPosition", "first");
        } else {
            JToggleButton button = this.myButtonList.get(this.myButtonList.size() - 1);
            button.putClientProperty("JToggleButton.segmentPosition", "middle");
        }
    }

    public void removeButton(JToggleButton button) {
        this.remove(button);
        if (this.myWithButtonGroup) {
            this.myButtonGroup.remove(button);
        }
        this.myButtonList.remove(button);
        this.adjustAfterRemove();
    }

    public void removeButtons(List<JToggleButton> buttons) {
        for (JToggleButton button : buttons) {
            this.removeButton(button);
        }
    }

    private void adjustAfterRemove() {
        if (this.myButtonList.size() == 1) {
            this.myButtonList.get(0).putClientProperty("JToggleButton.segmentPosition", "only");
        } else {
            this.myButtonList.get(0).putClientProperty("JToggleButton.segmentPosition", "first");
            this.myButtonList.get(this.myButtonList.size() - 1).putClientProperty("JToggleButton.segmentPosition", "last");
        }
    }

    public void setSizeVariant(String sizeVariant) {
        for (JToggleButton button : this.myButtonList) {
            button.putClientProperty("JComponent.sizeVariant", sizeVariant);
        }
    }

    @Override
    public void setEnabled(boolean value) {
        for (JToggleButton button : this.myButtonList) {
            button.setEnabled(value);
        }
    }

    public boolean isNextButtonHovered(JToggleButton button) {
        int index = 0;
        for (JToggleButton tempButton : this.myButtonList) {
            index = this.myButtonList.indexOf(tempButton);
            if (button != tempButton || index == this.myButtonList.size() - 1 || !this.myButtonList.get(index + 1).getModel().isRollover()) continue;
            return true;
        }
        return false;
    }
}

