/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.table.PTableCellRenderer;
import com.nokia.widgets.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;

public class ButtonImageRenderer<T extends JComponent>
extends PTableCellRenderer {
    CellRendererPane pane = new CellRendererPane();
    protected T myImageSource;
    protected Image myImage;
    protected boolean myUseButtonImage = true;

    public ButtonImageRenderer(T source) {
        this.myImageSource = source;
        ((JComponent)this.myImageSource).putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        ((JComponent)this.myImageSource).putClientProperty("JComponent.sizeVariant", "small");
    }

    public boolean useButtonImage() {
        return this.myUseButtonImage;
    }

    public void setUseButtonImage(boolean useButtonImage) {
        this.myUseButtonImage = useButtonImage;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ((JComponent)this.myImageSource).setEnabled(enabled);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.pane.getParent() == null) {
            table.add(this.pane);
        } else if (this.pane.getParent() != table) {
            this.pane.getParent().remove(this.pane);
            table.add(this.pane);
        }
        ((JComponent)this.myImageSource).setEnabled(this.isEnabled());
        Rectangle imageRect = table.getCellRect(row, column, false);
        ++imageRect.x;
        ++imageRect.y;
        imageRect.width -= 2;
        imageRect.height -= 2;
        this.pane.add((Component)this.myImageSource);
        ((Component)this.myImageSource).setBounds(imageRect);
        ((Container)this.myImageSource).doLayout();
        int imageWidth = 1;
        int idx = 0;
        while (idx < ((Container)this.myImageSource).getComponentCount()) {
            Component c = ((Container)this.myImageSource).getComponent(idx);
            if (c instanceof JButton) {
                JButton btn = (JButton)c;
                Rectangle bounds = btn.getBounds();
                bounds.translate(imageRect.x, imageRect.y);
                Point rolloveredCell = (Point)table.getClientProperty("BlueTouch.rolloveredCell");
                if (rolloveredCell != null) {
                    boolean contains = bounds.contains(rolloveredCell) && table.isCellEditable(row, column);
                    btn.getModel().setRollover(contains);
                }
                imageWidth = btn.getWidth();
                Color selectionColor = table.getSelectionBackground();
                if (!this.isEnabled()) {
                    btn.setBackground(isSelected ? selectionColor : UIManager.getColor("Table.UnEditableRowBackground1"));
                }
            }
            ++idx;
        }
        if (imageWidth == 0) {
            return this;
        }
        if (this.myImage == null || this.myImage.getWidth(null) != imageWidth || this.myImage.getHeight(null) != imageRect.height) {
            if (this.myImage != null) {
                this.myImage.flush();
            }
            this.myImage = ImageUtils.createCompatibleTranslucentImage(imageWidth, imageRect.height);
        }
        Graphics2D gImage = (Graphics2D)this.myImage.getGraphics().create();
        this.pane.paintComponent(gImage, (Component)this.myImageSource, null, 0, 0, imageWidth, imageRect.height, true);
        gImage.dispose();
        this.pane.removeAll();
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.useButtonImage()) {
            g.drawImage(this.myImage, this.getWidth() - this.myImage.getWidth(null) - 1, 1, null);
        }
    }
}

