/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PTableHeaderRenderer;
import com.nokia.widgets.tristatecheckbox.TristateCheckBox;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class CheckBoxHeaderRenderer
extends PTableHeaderRenderer
implements ActionListener,
PropertyChangeListener {
    private static final Insets CHECKBOX_MARGIN = new Insets(4, 24, 3, 3);
    private static final Insets CHECKBOX_MARGIN_SMALL = new Insets(3, 19, 1, 4);
    private static final Insets CHECKBOX_NO_TEXT_MARGIN = new Insets(4, 38, 3, 8);
    private static final Insets CHECKBOX_NO_TEXT_MARGIN_SMALL = new Insets(2, 34, 3, 4);
    private TristateCheckBox myCheckBox = new TristateCheckBox();
    private JTable myTable;
    private int myColumnIndex;
    private TableModelListener myTableModelListener = new TableModelHandler();

    public CheckBoxHeaderRenderer(JTable table) {
        this.myTable = table;
        this.myCheckBox.setOpaque(false);
        this.myCheckBox.setSizeVariant("small");
        this.myCheckBox.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.myCheckBox);
        this.myCheckBox.addActionListener(this);
        this.myTable.addContainerListener(new ContainerListener(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                CheckBoxHeaderRenderer.this.myTable.getTableHeader().repaint();
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                CheckBoxHeaderRenderer.this.myTable.getTableHeader().repaint();
            }
        });
        this.myTable.getModel().addTableModelListener(this.myTableModelListener);
        this.myTable.addPropertyChangeListener(this);
    }

    public TristateCheckBox getCheckBox() {
        return this.myCheckBox;
    }

    @Override
    protected boolean isHeaderRollovered(int column, JTableHeader header) {
        Point point = (Point)header.getClientProperty("OrangeTouch.headerRolloverLocation");
        Rectangle headerRect = header.getHeaderRect(column);
        if (point != null) {
            Rectangle checkBoxBounds = this.myCheckBox.getBounds();
            checkBoxBounds.translate(headerRect.x, 0);
            boolean mouseIsInsideCheckBox = checkBoxBounds.contains(point);
            this.myCheckBox.getModel().setRollover(mouseIsInsideCheckBox && !this.myCheckBox.isReadOnly());
            header.putClientProperty("OrangeTouch.isMouseOnChild", mouseIsInsideCheckBox);
            if (mouseIsInsideCheckBox) {
                return false;
            }
        }
        return super.isHeaderRollovered(column, header);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.myColumnIndex = table.convertColumnIndexToModel(column);
        this.updateCheckBoxState(table, table.convertColumnIndexToModel(column));
        if (this.getText() != null && this.getText().length() > 0) {
            this.setMargin(ComponentUtils.isSmall(table) ? CHECKBOX_MARGIN_SMALL : CHECKBOX_MARGIN);
        } else {
            this.setMargin(ComponentUtils.isSmall(table) ? CHECKBOX_NO_TEXT_MARGIN_SMALL : CHECKBOX_NO_TEXT_MARGIN);
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        return NetUtils.getPreferredButtonSize(this, this.getIconTextGap(), false);
    }

    protected void updateCheckBoxState(JTable table, int column) {
        TableModel tableModel = this.myTable.getModel();
        if (tableModel.getColumnClass(column) != Boolean.class) {
            return;
        }
        int falseCount = 0;
        int trueCount = 0;
        int disabledFalseCount = 0;
        int disabledTrueCount = 0;
        int rowCount = tableModel.getRowCount();
        int row = 0;
        while (row < rowCount) {
            Object value = tableModel.getValueAt(row, column);
            if (value != null) {
                if (!tableModel.isCellEditable(row, column)) {
                    if (this.isSelected(row, column, value)) {
                        ++disabledTrueCount;
                    } else {
                        ++disabledFalseCount;
                    }
                } else if (this.isSelected(row, column, value)) {
                    ++trueCount;
                } else {
                    ++falseCount;
                }
            }
            ++row;
        }
        int editableCellRowCount = this.getEditableCellRowCount(column);
        if (!this.myTable.isEnabled()) {
            this.myCheckBox.setEnabled(false);
        } else if (ComponentUtils.isReadOnly(this.myTable)) {
            this.myCheckBox.setReadOnly(true);
        } else {
            this.myCheckBox.setEnabled(true);
            this.myCheckBox.setReadOnly(false);
        }
        this.myCheckBox.setEnabled(this.myTable.isEnabled());
        if (editableCellRowCount == 0) {
            this.myCheckBox.setPending(false);
            this.myCheckBox.setEnabled(false);
            if (this.myTable.getRowCount() == disabledFalseCount) {
                this.myCheckBox.setSelected(false);
            } else if (this.myTable.getRowCount() == disabledTrueCount) {
                this.myCheckBox.setSelected(true);
            }
        } else if (trueCount == editableCellRowCount) {
            this.myCheckBox.setPending(false);
            this.myCheckBox.setSelected(true);
        } else if (falseCount == editableCellRowCount) {
            this.myCheckBox.setPending(false);
            this.myCheckBox.setSelected(false);
        } else {
            this.myCheckBox.setPending(true);
        }
    }

    private int getEditableCellRowCount(int columnIndex) {
        int result = 0;
        int rowIndex = 0;
        while (rowIndex < this.myTable.getModel().getRowCount()) {
            if (this.myTable.getModel().isCellEditable(rowIndex, columnIndex)) {
                ++result;
            }
            ++rowIndex;
        }
        return result;
    }

    protected boolean isSelected(int rowIndex, int columnIndex, Object value) {
        return Boolean.TRUE.equals(value);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle iconRectMidPosition = NetUtils.calculateMidPosition(this.getBounds(), 14, 17, null);
        Rectangle headerRect = this.myTable.getTableHeader().getHeaderRect(this.myTable.convertColumnIndexToView(this.myColumnIndex));
        Insets insets = this.myTable.getTableHeader().getInsets();
        iconRectMidPosition.translate(headerRect.x, headerRect.y - insets.top);
        if (this.getText() != null && this.getText().length() > 0) {
            iconRectMidPosition.x = 4;
        }
        iconRectMidPosition.y += 2;
        this.myCheckBox.setBounds(iconRectMidPosition);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        TableModel tableModel;
        if (!this.myTable.isEnabled() || ComponentUtils.isReadOnly(this.myTable)) {
            return;
        }
        TableModel tableModel2 = tableModel = this.myTable.getModel() instanceof PSortableTableModel ? ((PSortableTableModel)this.myTable.getModel()).getWrappedModel() : this.myTable.getModel();
        if (!ComponentUtils.isRolloveredColumn(this.myTable.getTableHeader(), this.myTable.convertColumnIndexToView(this.myColumnIndex)) || tableModel.getColumnClass(this.myColumnIndex) != Boolean.class) {
            return;
        }
        if (this.myTable.getCellEditor() != null) {
            this.myTable.getCellEditor().stopCellEditing();
        }
        boolean selected = this.myCheckBox.isSelected();
        int rowIndex = 0;
        while (rowIndex < tableModel.getRowCount()) {
            if (tableModel.isCellEditable(rowIndex, this.myColumnIndex)) {
                tableModel.setValueAt(selected, rowIndex, this.myColumnIndex);
            }
            ++rowIndex;
        }
        this.myTable.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            TableModel newModel;
            TableModel oldModel = (TableModel)evt.getOldValue();
            if (oldModel != null) {
                oldModel.removeTableModelListener(this.myTableModelListener);
            }
            if ((newModel = (TableModel)evt.getNewValue()) != null) {
                newModel.addTableModelListener(this.myTableModelListener);
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            JTableHeader tableHeader = CheckBoxHeaderRenderer.this.myTable.getTableHeader();
            tableHeader.repaint(tableHeader.getHeaderRect(CheckBoxHeaderRenderer.this.myTable.convertColumnIndexToView(CheckBoxHeaderRenderer.this.myColumnIndex)));
        }
    }
}

