/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ComparatorFactory {
    private static Map theComparators = new HashMap();
    private static Pattern thePattern = Pattern.compile("(\\d+)|(\\D+)");

    public static Comparator getComparator(Class clazz) {
        Class c = null;
        c = clazz == null ? StringComparator.class : (Number.class.isAssignableFrom(clazz) ? NumberComparator.class : (String.class.isAssignableFrom(clazz) ? StringComparator.class : (Comparable.class.isAssignableFrom(clazz) ? ComparableComparator.class : (Calendar.class.isAssignableFrom(clazz) ? CalendarComparator.class : StringComparator.class))));
        if (theComparators.containsKey(c)) {
            return (Comparator)theComparators.get(c);
        }
        try {
            NullComparator rc = new NullComparator((Comparator)c.newInstance());
            theComparators.put(c, rc);
            return rc;
        }
        catch (Exception ex) {
            throw new RuntimeException("instantiating Comparator " + c + " failed", ex);
        }
    }

    static class CalendarComparator
    extends ComparableComparator {
        CalendarComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Calendar c1 = (Calendar)o1;
            Date d1 = c1.getTime();
            Calendar c2 = (Calendar)o2;
            Date d2 = c2.getTime();
            return super.compare(d1, d2);
        }
    }

    static class ComparableComparator
    implements Comparator {
        ComparableComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }

    static class NullComparator
    implements Comparator {
        private Comparator myDecoratedComparator;

        public NullComparator(Comparator decoratedComparator) {
            this.myDecoratedComparator = decoratedComparator;
        }

        public int compare(Object o1, Object o2) {
            if (o1 != null && o2 != null) {
                return this.myDecoratedComparator.compare(o1, o2);
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            return 0;
        }
    }

    static class NumberComparator
    implements Comparator {
        NumberComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Number)) {
                return -1;
            }
            if (!(o2 instanceof Number)) {
                return 1;
            }
            if (!(o1 instanceof Number) && !(o2 instanceof Number)) {
                return 0;
            }
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            return new Double(n1.doubleValue()).compareTo(new Double(n2.doubleValue()));
        }
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            String firstStr = o1.toString().toUpperCase();
            String secondStr = o2.toString().toUpperCase();
            Matcher firstMatcher = thePattern.matcher(firstStr);
            Matcher secondMatcher = thePattern.matcher(secondStr);
            int result = 0;
            while (firstMatcher.find() && secondMatcher.find()) {
                String firstToken = firstMatcher.group();
                String secondToken = secondMatcher.group();
                if (Character.isDigit(firstToken.charAt(0)) && Character.isDigit(secondToken.charAt(0))) {
                    NumberComparator comparator = new NumberComparator();
                    result = comparator.compare(Double.valueOf(firstToken), Double.valueOf(secondToken));
                } else {
                    result = firstToken.compareTo(secondToken);
                }
                if (result == 0) continue;
                return result;
            }
            return firstStr.length() - secondStr.length();
        }
    }
}

