/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import java.util.HashMap;
import java.util.Map;
import javax.swing.ListCellRenderer;

public class FilterConfiguration {
    private Map<Integer, FilterColumnConfiguration> myConfigurations = new HashMap<Integer, FilterColumnConfiguration>();

    public boolean setFilterComboBoxRenderer(int columnIndex, ListCellRenderer renderer) {
        FilterColumnConfiguration config = this.getFilterConfiguration(columnIndex);
        ListCellRenderer oldValue = config.getRenderer();
        config.setRenderer(renderer);
        return oldValue != renderer;
    }

    public ListCellRenderer getFilterComboBoxRenderer(int modelColumn) {
        return this.getFilterConfiguration(modelColumn).getRenderer();
    }

    public boolean setFilterComboBoxVisible(int columnIndex, boolean visible) {
        FilterColumnConfiguration config = this.getFilterConfiguration(columnIndex);
        boolean oldValue = config.isFilterComboBoxVisible();
        config.setFilterComboBoxVisible(visible);
        return oldValue ^ visible;
    }

    public boolean isFilterComboBoxVisible(int columnIndex) {
        return this.getFilterConfiguration(columnIndex).isFilterComboBoxVisible();
    }

    public boolean setFilteringEnabled(int columnIndex, boolean enabled) {
        FilterColumnConfiguration config = this.getFilterConfiguration(columnIndex);
        boolean oldValue = config.isFilteringEnabled();
        config.setFilteringEnabled(enabled);
        return enabled ^ oldValue;
    }

    public boolean isFilteringEnabled(int columnIndex) {
        return this.getFilterConfiguration(columnIndex).isFilteringEnabled();
    }

    private FilterColumnConfiguration getFilterConfiguration(int columnIndex) {
        FilterColumnConfiguration config = this.myConfigurations.get(columnIndex);
        if (config != null) {
            return config;
        }
        config = new FilterColumnConfiguration();
        this.myConfigurations.put(columnIndex, config);
        return config;
    }

    private static class FilterColumnConfiguration {
        private boolean myFilterComboBoxVisible = true;
        private boolean myFilterComboBoxEnabled = true;
        private ListCellRenderer myRenderer = null;

        private FilterColumnConfiguration() {
        }

        public boolean isFilterComboBoxVisible() {
            return this.myFilterComboBoxVisible;
        }

        public boolean isFilteringEnabled() {
            return this.myFilterComboBoxEnabled;
        }

        public ListCellRenderer getRenderer() {
            return this.myRenderer;
        }

        public void setFilterComboBoxVisible(boolean visible) {
            this.myFilterComboBoxVisible = visible;
        }

        public void setFilteringEnabled(boolean enabled) {
            this.myFilterComboBoxEnabled = enabled;
        }

        public void setRenderer(ListCellRenderer renderer) {
            this.myRenderer = renderer;
        }
    }
}

