/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.laf.combobox.NetComboBoxRenderer;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class InlineFilterListCellRenderer
extends NetComboBoxRenderer {
    private JTable myTable;
    private int myColumnIndex;
    private boolean myPaintingNoFilterOption = false;

    public InlineFilterListCellRenderer(JComboBox combo, JTable table, int columnIndex) {
        super(combo);
        this.myTable = table;
        this.myColumnIndex = columnIndex;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.myPaintingNoFilterOption = false;
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (index <= 0) {
            this.setText(WidgetResources.getString("Table.showAll"));
            this.myPaintingNoFilterOption = !isSelected;
            return this;
        }
        if ("".equals(this.getText())) {
            this.setText(WidgetResources.getString("Table.blanks"));
            return this;
        }
        int viewColumn = this.myTable.convertColumnIndexToView(this.myColumnIndex);
        Class<?> columnClass = this.myTable.getColumnClass(viewColumn);
        PSortableTableModel sortModel = (PSortableTableModel)this.myTable.getModel();
        int tableRow = sortModel.getFirstRowOfValue(value, this.myColumnIndex);
        if (columnClass != Boolean.class) {
            int originalIndex;
            if (tableRow >= 0 && (originalIndex = sortModel.getOriginalIndex(tableRow)) >= 0) {
                this.setText(sortModel.getStringValueAt(originalIndex, this.myColumnIndex));
            }
            return this;
        }
        TableCellRenderer renderer = this.myTable.getCellRenderer(index, viewColumn);
        Component component = renderer.getTableCellRendererComponent(this.myTable, value, isSelected, cellHasFocus, tableRow, viewColumn);
        component.setBackground(this.getBackground());
        return component;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myPaintingNoFilterOption) {
            g.setColor(UIManager.getColor("Table.UnEditableGridHorizontal1"));
            g.drawLine(3, this.getHeight() - 1, this.getWidth() - 4, this.getHeight() - 1);
        }
    }
}

