/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.NetTableCellBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.IconBorder;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.table.PTableCellRenderer;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class PComboBoxRenderer
extends PTableCellRenderer {
    private PArrowIcon myArrowIcon = new PArrowIcon(4, 3, NetLookAndFeel.getFocusColor());
    private static int BUTTON_WIDTH = 15;
    private Border myBorder = null;
    private boolean myEditableComboBox = false;
    private boolean myTableEnabled = true;
    private boolean myHorizontalAlignmentExplicitlySet = false;

    public PComboBoxRenderer() {
        this(false);
    }

    public PComboBoxRenderer(int horizontalAlignment) {
        this(false);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public PComboBoxRenderer(boolean editable) {
        this.putClientProperty("OrangeTouch.mandatoryAsteriskXOffset", -11);
        this.putClientProperty("JComponent.sizeVariant", "small");
        IconBorder iconBorder = new IconBorder(this.myArrowIcon);
        iconBorder.setMargin(new Insets(0, 0, 0, 3));
        iconBorder.setIconPadding(7);
        iconBorder.setIconHorizontalAlignment(4);
        this.myBorder = new CompoundBorder(new NetTableCellBorder(), iconBorder);
        this.myEditableComboBox = editable;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.myTableEnabled = table.isEnabled();
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Number && !this.myHorizontalAlignmentExplicitlySet) {
            this.setHorizontalAlignment(4);
            this.myHorizontalAlignmentExplicitlySet = false;
        }
        this.setBorder(this.myBorder);
        return this;
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        super.setHorizontalAlignment(alignment);
        this.myHorizontalAlignmentExplicitlySet = true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean rollovered = ClientPropertyUtil.booleanValue(this, "Table.isRollovered") && this.myTableEnabled;
        boolean editable = ClientPropertyUtil.booleanValue(this, "Table.isEditable") && this.myTableEnabled;
        boolean selected = ClientPropertyUtil.booleanValue(this, "Table.isSelected");
        Object oldAa = NetUtils.antiAliasingOn(g);
        Color oldColor = g.getColor();
        Color arrowColor = NetTheme.getComponentOutlineColor();
        if (!editable && selected) {
            arrowColor = NetTheme.getComponentOutlineColor();
            this.setForeground(UIManager.getColor("textHighlightText"));
        } else if (rollovered && editable) {
            arrowColor = NetLookAndFeel.getBlack();
        } else if (editable) {
            arrowColor = UIManager.getColor("Spinner.table.arrowColor");
        }
        this.myArrowIcon.setArrowColor(arrowColor);
        super.paintComponent(g);
        int lineXLocation = this.getWidth() - BUTTON_WIDTH;
        if (this.myEditableComboBox && editable) {
            g.setColor(UIManager.getColor("Table.editorBorder"));
            g.drawLine(lineXLocation, 2, lineXLocation, this.getHeight() - 3);
        }
        if (rollovered && editable) {
            g.setColor(NetUtils.decodeColor("#F8F8F8"));
            Shape rect = NetUtils.getRoundedRect(this, lineXLocation + 1, 3, 14, this.getHeight() - 3, 10, 2);
            GradientUtils.drawVerticalGradient((JComponent)this, g, "ComboBox.nsnRolloverGradient", rect);
            g.setColor(NetTheme.getComponentOutlineColor());
            g.drawLine(lineXLocation, 2, lineXLocation, this.getHeight() - 3);
        }
        g.setColor(oldColor);
        NetUtils.setAntialiasing(g, oldAa);
    }
}

