/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.laf.NetBorderFactory;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.table.TristateValue;
import com.nokia.widgets.tristatecheckbox.TristateCheckBox;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PDefaultCellEditor
extends DefaultCellEditor {
    protected static final Border TEXTFIELD_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(NetBorderFactory.getBasicNetBorder(NetLookAndFeel.getFocusColor()), BorderFactory.createEmptyBorder(0, 0, 0, 1)));
    private Container myTable;

    public PDefaultCellEditor(JTextField textField, int clickCountToStart) {
        this(textField);
        this.setClickCountToStart(clickCountToStart);
    }

    public PDefaultCellEditor(JTextField textField) {
        super(textField);
        textField.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        textField.setBorder(TEXTFIELD_BORDER);
    }

    public PDefaultCellEditor(JCheckBox checkBox) {
        super(checkBox);
    }

    public PDefaultCellEditor(JComboBox comboBox) {
        super(comboBox);
    }

    public PDefaultCellEditor(final JRadioButton radioButton) {
        super(new JCheckBox());
        this.editorComponent = radioButton;
        this.editorComponent.setOpaque(false);
        radioButton.setFocusPainted(false);
        radioButton.setHorizontalAlignment(0);
        this.delegate = new DefaultCellEditor.EditorDelegate(this){

            @Override
            public void setValue(Object value) {
                boolean selected = false;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                } else if (value instanceof String) {
                    selected = "true".equals(value);
                }
                radioButton.setSelected(selected);
            }

            @Override
            public Object getCellEditorValue() {
                return radioButton.isSelected();
            }
        };
        radioButton.addActionListener(this.delegate);
        radioButton.setRequestFocusEnabled(false);
    }

    public PDefaultCellEditor(final JSpinner spinner) {
        super(new JCheckBox());
        this.editorComponent = spinner;
        if (spinner.getEditor() instanceof JTextField) {
            ((JTextField)spinner.getEditor()).setHorizontalAlignment(4);
        } else if (spinner.getEditor() instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setHorizontalAlignment(4);
        }
        spinner.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        if (spinner.getEditor() != null) {
            spinner.getEditor().putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        this.delegate = new DefaultCellEditor.EditorDelegate(this){

            @Override
            public void setValue(Object value) {
                spinner.setValue(value);
            }

            @Override
            public Object getCellEditorValue() {
                return spinner.getValue();
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                try {
                    spinner.commitEdit();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                return super.stopCellEditing();
            }
        };
    }

    public PDefaultCellEditor(final TristateCheckBox tristateCheckBox) {
        super(tristateCheckBox);
        this.editorComponent = tristateCheckBox;
        tristateCheckBox.setHorizontalAlignment(0);
        tristateCheckBox.setBackground(Color.WHITE);
        tristateCheckBox.setOpaque(true);
        tristateCheckBox.setRequestFocusEnabled(false);
        tristateCheckBox.setFocusPainted(false);
        tristateCheckBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        JPopupMenu menu = tristateCheckBox.getPopupMenu();
        if (menu != null) {
            menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
                    PDefaultCellEditor.this.myTable = PDefaultCellEditor.this.editorComponent.getParent();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PDefaultCellEditor.this.stopCellEditing();
                            if (PDefaultCellEditor.this.myTable != null) {
                                PDefaultCellEditor.this.myTable.requestFocusInWindow();
                            }
                        }
                    });
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent event) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PDefaultCellEditor.this.cancelCellEditing();
                            if (PDefaultCellEditor.this.myTable != null) {
                                PDefaultCellEditor.this.myTable.requestFocusInWindow();
                            }
                        }
                    });
                }
            });
        }
        this.delegate = new DefaultCellEditor.EditorDelegate(this){

            @Override
            public void setValue(Object value) {
                TristateValue tristate = (TristateValue)((Object)value);
                if (tristate == null) {
                    tristateCheckBox.setPending(false);
                    tristateCheckBox.setSelected(false);
                } else if (TristateValue.ALL.equals((Object)tristate)) {
                    tristateCheckBox.setSelected(true);
                    tristateCheckBox.setPending(false);
                } else if (TristateValue.PARTIAL.equals((Object)tristate)) {
                    tristateCheckBox.setPending(true);
                } else {
                    tristateCheckBox.setPending(false);
                    tristateCheckBox.setSelected(false);
                }
            }

            @Override
            public Object getCellEditorValue() {
                if (tristateCheckBox.isPending()) {
                    return TristateValue.PARTIAL;
                }
                if (tristateCheckBox.isSelected()) {
                    return TristateValue.ALL;
                }
                return TristateValue.NONE;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                return super.stopCellEditing();
            }
        };
    }
}

