/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.NetTableCellBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.IconBorder;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.table.PTableCellRenderer;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class PSpinnerRenderer
extends PTableCellRenderer {
    private PArrowIcon myDownArrowIcon = new PArrowIcon(4, 3, NetTheme.getComponentOutlineColor());
    private PArrowIcon myUpArrowIcon = new PArrowIcon(4, 3, (Color)NetTheme.getComponentOutlineColor(), 1);
    private boolean myTableEnabled = true;
    private Border myBorder = null;

    public PSpinnerRenderer() {
        this.putClientProperty("OrangeTouch.mandatoryAsteriskXOffset", -18);
        this.putClientProperty("JComponent.sizeVariant", "small");
        IconBorder iconBorder = new IconBorder(new SpinnerArrowIcon());
        iconBorder.setMargin(new Insets(1, 0, 1, 5));
        iconBorder.setIconPadding(8);
        iconBorder.setIconHorizontalAlignment(4);
        this.myBorder = new CompoundBorder(new NetTableCellBorder(), iconBorder);
        this.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.myTableEnabled = table.isEnabled();
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(this.myBorder);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean rollovered = ClientPropertyUtil.booleanValue(this, "Table.isRollovered") && this.myTableEnabled;
        boolean editable = ClientPropertyUtil.booleanValue(this, "Table.isEditable");
        int lineX = this.getWidth() - 19;
        Color arrowColor = NetTheme.getComponentOutlineColor();
        if (rollovered && editable) {
            arrowColor = NetLookAndFeel.getBlack();
        } else if (editable) {
            arrowColor = UIManager.getColor("Spinner.table.arrowColor");
        }
        this.myUpArrowIcon.setArrowColor(arrowColor);
        this.myDownArrowIcon.setArrowColor(arrowColor);
        super.paintComponent(g);
        if (rollovered && editable) {
            g.setColor(UIManager.getColor("Spinner.table.fillColor"));
            Shape rect = NetUtils.getRoundedRect(this, lineX + 1, 3, 15, this.getHeight() - 4, 10, 2);
            ((Graphics2D)g).fill(rect);
        }
        g.setColor(UIManager.getColor("Spinner.table.lineColor"));
        if (editable) {
            g.drawLine(lineX, 2, lineX, this.getHeight() - 3);
            g.drawLine(lineX, this.getHeight() / 2, this.getWidth() - 2, this.getHeight() / 2);
        }
    }

    private class SpinnerArrowIcon
    implements Icon {
        private int ICON_GAP = 4;

        private SpinnerArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            PSpinnerRenderer.this.myUpArrowIcon.paintIcon(c, g, x, y);
            PSpinnerRenderer.this.myDownArrowIcon.paintIcon(c, g, x, y + PSpinnerRenderer.this.myUpArrowIcon.getIconHeight() + this.ICON_GAP);
        }

        @Override
        public int getIconWidth() {
            return PSpinnerRenderer.this.myUpArrowIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return PSpinnerRenderer.this.myUpArrowIcon.getIconHeight() + this.ICON_GAP + PSpinnerRenderer.this.myDownArrowIcon.getIconHeight();
        }
    }
}

