/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.laf.NetTableHeaderUI;
import com.nokia.widgets.table.FilterConfiguration;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PTable
extends JTable {
    public static final int TOOLTIP_OFFSET_Y = 20;
    public static final int HIGHLIGHT_HEADER_GROUP_ROW = -2;
    private boolean myPacked = false;
    private Point myCurrentTipLocation = new Point(-1, -1);

    public PTable() {
    }

    public PTable(TableModel dm) {
        super(dm);
    }

    public PTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public PTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public PTable(Vector<?> rowData, Vector<?> columnNames) {
        super(rowData, columnNames);
    }

    public PTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public PTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public int getViewRow(int modelRow) {
        if (modelRow < 0) {
            return modelRow;
        }
        if (this.getModel() instanceof PSortableTableModel) {
            return ((PSortableTableModel)this.getModel()).getSortedIndex(modelRow);
        }
        return modelRow;
    }

    public int getModelRow(int viewRow) {
        if (viewRow < 0) {
            return viewRow;
        }
        if (this.getModel() instanceof PSortableTableModel) {
            return ((PSortableTableModel)this.getModel()).getOriginalIndex(viewRow);
        }
        return viewRow;
    }

    public void setAlternate(boolean alternate) {
        this.putClientProperty("OrangeTouch.alternate", alternate);
    }

    @Override
    public void doLayout() {
        this.putClientProperty("OrangeTouch.inDoLayout", true);
        super.doLayout();
        this.putClientProperty("OrangeTouch.inDoLayout", false);
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle result = super.getCellRect(row, column, includeSpacing);
        result.x += this.getInsets().left;
        if (column == this.getColumnCount() - 1 && this.getParent() instanceof JViewport) {
            ++result.width;
        }
        return result;
    }

    @Override
    public int getWidth() {
        int result = super.getWidth();
        if (ClientPropertyUtil.booleanValue(this, "OrangeTouch.inDoLayout")) {
            Insets insets = this.getInsets();
            return result - (insets.left + insets.right);
        }
        return result;
    }

    public boolean isAlternate() {
        Object property = this.getClientProperty("OrangeTouch.alternate");
        if (property == null) {
            return true;
        }
        return Boolean.TRUE.equals(this.getClientProperty("OrangeTouch.alternate"));
    }

    public void setSimpleFilteringEnabled(boolean enabled) {
        this.putClientProperty("OrangeTouch.simpleFilteringEnabled", enabled);
    }

    public boolean isSimpleFilteringEnabled() {
        return Boolean.TRUE.equals(this.getClientProperty("OrangeTouch.simpleFilteringEnabled"));
    }

    public void setFilteringEnabled(int column, boolean enabled) {
        FilterConfiguration config = this.getInlineFilterConfiguration();
        boolean changed = config.setFilteringEnabled(column, enabled);
        if (changed) {
            this.firePropertyChange("OrangeTouch.inlineFilterConfiguration", null, config);
        }
    }

    public void setFilterComboBoxVisible(int column, boolean visible) {
        FilterConfiguration config = this.getInlineFilterConfiguration();
        boolean changed = config.setFilterComboBoxVisible(column, visible);
        if (changed) {
            this.firePropertyChange("OrangeTouch.inlineFilterConfiguration", null, config);
        }
    }

    public void setSimpleFilterRenderer(int column, ListCellRenderer renderer) {
        FilterConfiguration config = this.getInlineFilterConfiguration();
        boolean changed = config.setFilterComboBoxRenderer(column, renderer);
        if (changed) {
            this.firePropertyChange("OrangeTouch.inlineFilterConfiguration", null, config);
        }
    }

    public void addHeaderGroup(int firstColumn, Object value) {
        TreeMap<Integer, Object> headerGroups = (TreeMap<Integer, Object>)this.getClientProperty("OrangeTouch.headerGroups");
        if (headerGroups == null) {
            headerGroups = new TreeMap<Integer, Object>();
            this.putClientProperty("OrangeTouch.headerGroups", headerGroups);
        }
        headerGroups.put(firstColumn, value);
        if (this.getTableHeader() != null) {
            this.getTableHeader().revalidate();
            this.getTableHeader().repaint();
        }
    }

    public void setHeaderGroupFont(Font font) {
        this.putClientProperty("OrangeTouch.headerGroups.font", font);
    }

    public void removeHeaderGroup(int firstColumn) {
        Object removedValue;
        Map headerGroups = (Map)this.getClientProperty("OrangeTouch.headerGroups");
        if (headerGroups != null && (removedValue = headerGroups.remove(firstColumn)) != null && this.getTableHeader() != null) {
            this.getTableHeader().revalidate();
            this.getTableHeader().repaint();
        }
    }

    public void removeAllHeaderGroups() {
        if (this.getClientProperty("OrangeTouch.headerGroups") != null) {
            this.putClientProperty("OrangeTouch.headerGroups", null);
            if (this.getTableHeader() != null) {
                this.getTableHeader().revalidate();
                this.getTableHeader().repaint();
            }
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.putClientProperty("OrangeTouch.readOnly", readOnly);
    }

    public boolean isReadOnly() {
        return ClientPropertyUtil.booleanValue(this, "OrangeTouch.readOnly");
    }

    public void setEmptyText(Object value) {
        this.putClientProperty("OrangeTouch.emptyText", value);
    }

    public Object getEmptyText() {
        return this.getClientProperty("OrangeTouch.emptyText");
    }

    public void setCalculateHeaderHeightFromRendererHeights(boolean calculate) {
        this.putClientProperty("OrangeTouch.calculateHeaderHeightFromRendererHeights", calculate);
    }

    public boolean isCalculateHeaderHeightFromRendererHeights() {
        Object value = this.getClientProperty("OrangeTouch.calculateHeaderHeightFromRendererHeights");
        return Boolean.TRUE.equals(value);
    }

    public void packColumns(int margin) {
        this.myPacked = true;
        TableColumnModel colModel = this.getColumnModel();
        int column = 0;
        while (column < this.getColumnCount()) {
            TableColumn tableColumn = colModel.getColumn(column);
            int width = this.getHeaderRendererPreferredWidth(tableColumn);
            int row = 0;
            while (row < this.getRowCount()) {
                TableCellRenderer renderer = this.getCellRenderer(row, column);
                Component comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, column), false, false, row, column);
                width = Math.max(width, comp.getPreferredSize().width);
                ++row;
            }
            tableColumn.setPreferredWidth(width += colModel.getColumnMargin() + margin);
            ++column;
        }
    }

    public void packColumns() {
        this.packColumns(0);
    }

    public void packRows() {
        int row = 0;
        while (row < this.getRowCount()) {
            int height = 0;
            int column = 0;
            while (column < this.getColumnCount()) {
                TableCellRenderer renderer = this.getCellRenderer(row, column);
                Component comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, column), false, false, row, column);
                height = Math.max(height, comp.getPreferredSize().height);
                ++column;
            }
            if (this.getRowHeight(row) < (height += this.getRowMargin())) {
                this.setRowHeight(row, height);
            }
            ++row;
        }
    }

    public void packCells() {
        this.packCells(0);
    }

    public void packCells(int horizontalMargin) {
        this.myPacked = true;
        TableColumnModel colModel = this.getColumnModel();
        int[] rowHeights = new int[this.getRowCount()];
        int column = 0;
        while (column < this.getColumnCount()) {
            TableColumn tableColumn = colModel.getColumn(column);
            int columnWidth = this.getHeaderRendererPreferredWidth(tableColumn);
            int row = 0;
            while (row < this.getRowCount()) {
                TableCellRenderer renderer = this.getCellRenderer(row, column);
                Component comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, column), false, false, row, column);
                columnWidth = Math.max(columnWidth, comp.getPreferredSize().width);
                rowHeights[row] = Math.max(rowHeights[row], comp.getPreferredSize().height);
                ++row;
            }
            tableColumn.setPreferredWidth(columnWidth += colModel.getColumnMargin() + horizontalMargin);
            ++column;
        }
        int tableRowMargin = this.getRowMargin();
        int row = 0;
        while (row < this.getRowCount()) {
            if (this.getRowHeight(row) < rowHeights[row] + tableRowMargin) {
                this.setRowHeight(row, rowHeights[row] + tableRowMargin);
            }
            ++row;
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension result = super.getPreferredScrollableViewportSize();
        if (this.myPacked) {
            result.width = this.getPreferredSize().width;
        }
        return result;
    }

    public void packHeader(int margin) {
        this.myPacked = true;
        TableColumnModel colModel = this.getColumnModel();
        int column = 0;
        while (column < this.getColumnCount()) {
            TableColumn tableColumn = colModel.getColumn(column);
            int width = this.getHeaderRendererPreferredWidth(tableColumn);
            tableColumn.setPreferredWidth(width += colModel.getColumnMargin() + margin);
            ++column;
        }
    }

    public void packHeader() {
        this.packHeader(0);
    }

    public void highlight(String text) {
        this.putClientProperty("OrangeTouch.highlightText", text);
        this.repaint();
    }

    private int getHeaderRendererPreferredWidth(TableColumn tableColumn) {
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null && this.getTableHeader() != null) {
            renderer = this.getTableHeader().getDefaultRenderer();
        }
        if (renderer != null) {
            Component comp = renderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, -1, tableColumn.getModelIndex());
            return comp.getPreferredSize().width;
        }
        return 0;
    }

    public void setTableColumnArray(TableColumn[] columns) {
        int count = this.getColumnCount();
        int j = 0;
        while (j < count) {
            this.removeColumn(this.getColumnModel().getColumn(this.getColumnCount() - 1));
            ++j;
        }
        int i = 0;
        while (i < columns.length) {
            this.addColumn(columns[i]);
            ++i;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (ComponentUtils.isReadOnly(this)) {
            return false;
        }
        return super.isCellEditable(row, column);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (ComponentUtils.isReadOnly(this)) {
            return false;
        }
        return super.editCellAt(row, column, e);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean noCustomHandling;
        int keyCode = ks.getKeyCode();
        boolean bl = noCustomHandling = keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40 || keyCode == 32 || keyCode == 36 || keyCode == 35;
        if (noCustomHandling) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        if (e.isAltDown() || e.isControlDown() || keyCode == 112) {
            return false;
        }
        if (e.getKeyChar() == '\u001b' && !this.isEditing()) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    private FilterConfiguration getInlineFilterConfiguration() {
        Object value = this.getClientProperty("OrangeTouch.inlineFilterConfiguration");
        if (value != null) {
            return (FilterConfiguration)value;
        }
        FilterConfiguration config = new FilterConfiguration();
        this.putClientProperty("OrangeTouch.inlineFilterConfiguration", config);
        return config;
    }

    public void clearInlineFilter() {
        JTableHeader header = this.getTableHeader();
        if (header.getUI() instanceof NetTableHeaderUI) {
            NetTableHeaderUI netTableUI = (NetTableHeaderUI)header.getUI();
            netTableUI.clearInlineFilters();
            this.repaint();
        }
    }

    public void setErrorCountsVisibleInHeader(boolean visible) {
        this.putClientProperty("OrangeTouch.errorCountVisibleInHeader", visible);
    }

    public void setStandalone(boolean standalone) {
        this.putClientProperty("OrangeTouch.isStandalone", standalone);
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        Point mousePoint = event.getPoint();
        int row = this.rowAtPoint(mousePoint);
        int column = this.columnAtPoint(mousePoint);
        String toolTipText = this.getToolTipText(event);
        if (!(toolTipText == null || toolTipText.isEmpty() || row == this.myCurrentTipLocation.x && column == this.myCurrentTipLocation.y)) {
            this.myCurrentTipLocation.setLocation(row, column);
            return new Point(mousePoint.x, mousePoint.y + 20);
        }
        return super.getToolTipLocation(event);
    }
}

