/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.NetToggleButtonUI;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PValidatableTableModel;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PTableHeaderRenderer
extends JToggleButton
implements TableCellRenderer {
    protected JTableHeader myTableHeader;
    protected static final Icon ARROW_UP;
    protected static final Icon ARROW_DOWN;
    private boolean myGroupHeaderRenderer = false;
    private int myErrorCount = -1;
    private boolean myFilterered = false;
    protected boolean myHorizontalAlignmenExplicitlySet = false;
    protected static final Insets DEFAULT_MARGIN;
    protected static final Insets DEFAULT_MARGIN_SMALL;

    static {
        DEFAULT_MARGIN = new Insets(4, 8, 3, 8);
        DEFAULT_MARGIN_SMALL = new Insets(3, 4, 2, 4);
        ARROW_UP = new PArrowIcon(4, 4, (Color)NetLookAndFeel.getControlTextColor(), 1);
        ARROW_DOWN = new PArrowIcon(4, 4, (Color)NetLookAndFeel.getControlTextColor(), 5);
    }

    public PTableHeaderRenderer() {
        this.setUI(new HeaderToggleButtonUI());
        this.putClientProperty("OrangeTouch.automaticTooltipEnabled", Boolean.TRUE);
        this.setOpaque(false);
        this.setIconTextGap(5);
    }

    public PTableHeaderRenderer(int horizontalAlignment) {
        this();
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public void setGroupHeaderRenderer() {
        this.myGroupHeaderRenderer = true;
    }

    @Override
    public void updateUI() {
        this.setUI(new HeaderToggleButtonUI());
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        super.setHorizontalAlignment(alignment);
        this.myHorizontalAlignmenExplicitlySet = true;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isModelSortable;
        Class<?> columnClass;
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            if (!this.myHorizontalAlignmenExplicitlySet) {
                this.setHorizontalAlignment(0);
                this.myHorizontalAlignmenExplicitlySet = false;
            }
        } else if (value != null) {
            this.setText(value.toString());
        }
        this.setMargin(ComponentUtils.isSmall(table) ? DEFAULT_MARGIN_SMALL : DEFAULT_MARGIN);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        if (table == null || table.getTableHeader() == null) {
            return this;
        }
        this.myFilterered = Boolean.TRUE.equals(table.getTableHeader().getClientProperty("OrangeTouch.isFiltered"));
        this.myErrorCount = 0;
        if (ClientPropertyUtil.booleanValue(table, "OrangeTouch.errorCountVisibleInHeader", false) && table.getRowCount() > 0) {
            this.myErrorCount = this.getErrorCount(table, column);
        }
        JTableHeader header = table.getTableHeader();
        Object autoTooltip = table.getClientProperty("OrangeTouch.automaticTooltipEnabled");
        boolean rollovered = this.isHeaderRollovered(column, header);
        if (autoTooltip == null || Boolean.TRUE.equals(autoTooltip)) {
            this.putClientProperty("OrangeTouch.automaticTooltipEnabled", rollovered);
        }
        this.setHorizontalTextPosition(10);
        this.setRolloverEnabled(true);
        this.myTableHeader = header;
        Color foreground = header.getForeground();
        this.getModel().setRollover(rollovered);
        this.setForeground(table.isEnabled() ? foreground : UIManager.getColor("Label.disabledForeground"));
        this.setBackground(header.getBackground());
        if (this.myGroupHeaderRenderer) {
            Object font = table.getClientProperty("OrangeTouch.headerGroups.font");
            if (font != null && font instanceof Font) {
                this.setFont((Font)font);
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setForeground(UIManager.getColor("Label.foreground"));
                this.setBackground(Color.WHITE);
            } else {
                this.setFont(header.getFont().deriveFont(1));
            }
        } else {
            this.setFont(header.getFont());
        }
        if (!this.myHorizontalAlignmenExplicitlySet && table != null && column >= 0 && column < table.getColumnCount() && (columnClass = table.getColumnClass(column)) != null) {
            if (Number.class.isAssignableFrom(columnClass)) {
                this.setHorizontalAlignment(4);
            } else if (Boolean.class.isAssignableFrom(columnClass)) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(10);
            }
            this.myHorizontalAlignmenExplicitlySet = false;
        }
        if (this.myGroupHeaderRenderer) {
            this.setHorizontalAlignment(10);
        }
        this.setEnabled(header.isEnabled() && table.isEnabled() && !this.myGroupHeaderRenderer);
        TableColumnModel columnModel = header.getColumnModel();
        if (column >= columnModel.getColumnCount() || column < 0) {
            return this;
        }
        int modelIndex = columnModel.getColumn(column).getModelIndex();
        if (NetUtils.lookAndFeelCanReplace(this.getIcon()) && !this.myGroupHeaderRenderer) {
            HeaderIcon headerIcon = new HeaderIcon();
            this.setIcon(headerIcon);
            this.setRolloverIcon(headerIcon);
            this.setDisabledIcon(headerIcon);
        }
        boolean bl = isModelSortable = table.getModel() != null && table.getModel() instanceof PSortableTableModel;
        if (isModelSortable && !this.myGroupHeaderRenderer) {
            PSortableTableModel sortableModel = (PSortableTableModel)table.getModel();
            this.setEnabled(sortableModel.isColumnSortable(column));
            this.setSortIcons(sortableModel, modelIndex);
            int mnemonic = sortableModel.getSortMnemonicAt(modelIndex);
            this.setMnemonic(mnemonic);
            int displayedMnemonicIndex = sortableModel.getDisplayedSortMnemonicIndexAt(column);
            if (displayedMnemonicIndex > 0) {
                this.setDisplayedMnemonicIndex(displayedMnemonicIndex);
            }
        } else {
            this.setBackground(header.getBackground());
        }
        this.setIconTextGap(this.getIcon() != null && this.getIcon().getIconWidth() > 0 ? 5 : 0);
        return this;
    }

    private int getErrorCount(JTable table, int column) {
        if (!table.isEnabled()) {
            return 0;
        }
        TableModel tableModel = table.getModel();
        if (!(tableModel instanceof PValidatableTableModel)) {
            return 0;
        }
        PValidatableTableModel validatedModel = (PValidatableTableModel)tableModel;
        int errorCount = 0;
        int columnIndex = table.convertColumnIndexToModel(column);
        int rowIndex = 0;
        while (rowIndex < table.getRowCount()) {
            if (validatedModel.isCellEditable(rowIndex, columnIndex) && (!validatedModel.isValid(rowIndex, columnIndex) || validatedModel.isMissing(rowIndex, columnIndex) && validatedModel.isMandatory(rowIndex, columnIndex))) {
                ++errorCount;
            }
            ++rowIndex;
        }
        return errorCount;
    }

    protected boolean isHeaderRollovered(int column, JTableHeader header) {
        return ComponentUtils.isRolloveredColumn(header, column);
    }

    private void setSortIcons(PSortableTableModel sortableModel, int column) {
        Icon icon = this.getIcon();
        if (icon != null && !(icon instanceof UIResource)) {
            return;
        }
        boolean isAscending = sortableModel.getSortDirection(column) == 1;
        HeaderIcon headerIcon = new HeaderIcon();
        if (sortableModel.getSortedColumnIndex() == column) {
            headerIcon.setSortIcon(isAscending ? ARROW_UP : ARROW_DOWN);
        } else if (sortableModel.getSecondarySortedColumnIndex() == column) {
            headerIcon.setSortIcon(isAscending ? ARROW_UP : ARROW_DOWN);
        } else if (sortableModel.getTertiarySortedColumnIndex() == column) {
            headerIcon.setSortIcon(isAscending ? ARROW_UP : ARROW_DOWN);
        } else {
            headerIcon.setSortIcon(null);
        }
        this.setIcon(headerIcon);
        this.setRolloverIcon(headerIcon);
    }

    private class HeaderIcon
    implements Icon,
    UIResource {
        private final int ICON_GAP = 4;
        private Icon mySortIcon;

        private HeaderIcon() {
        }

        public void setSortIcon(Icon sortIcon) {
            this.mySortIcon = sortIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int nextX = x;
            if (PTableHeaderRenderer.this.myErrorCount > 0) {
                nextX += this.paintErrorCount(c, g, x, y);
                nextX += 4;
            }
            if (this.mySortIcon != null) {
                this.mySortIcon.paintIcon(c, g, nextX, y + c.getHeight() / 2 - this.getIconHeight() / 2 + 3);
            }
            if (PTableHeaderRenderer.this.myFilterered) {
                ImageIcon filterIcon = CommonIcons.getFilterIcon();
                int filterIconX = c.getWidth() - filterIcon.getIconWidth() - 4;
                filterIcon.paintIcon(c, g, filterIconX, PTableHeaderRenderer.this.getHeight() / 2 - filterIcon.getIconHeight() / 2);
            }
        }

        private int paintErrorCount(Component c, Graphics g, int x, int y) {
            Object oldAa = NetUtils.antiAliasingOn(g);
            int symbolWidth = this.getErrorSymbolWidth();
            float fontSize = ScaleUtils.scale(10);
            RectangularShape roundRect = NetUtils.getRoundedRect((JComponent)c, x, y, symbolWidth, (int)(fontSize + 6.0f), 14);
            g.setColor(UIManager.getColor("TextField.invalidForeground"));
            ((Graphics2D)g).fill(roundRect);
            g.setColor(UIManager.getColor("TextField.invalidBackground"));
            Font oldFont = g.getFont();
            g.setFont(g.getFont().deriveFont(fontSize).deriveFont(1));
            FontMetrics fm = g.getFontMetrics();
            String errorString = String.valueOf(PTableHeaderRenderer.this.myErrorCount);
            int stringWidth = fm.stringWidth(errorString);
            g.drawString(String.valueOf(PTableHeaderRenderer.this.myErrorCount), x + symbolWidth / 2 - stringWidth / 2, y + fm.getAscent());
            g.setFont(oldFont);
            NetUtils.setAntialiasing(g, oldAa);
            return symbolWidth;
        }

        private int getErrorSymbolWidth() {
            String errors = String.valueOf(PTableHeaderRenderer.this.myErrorCount);
            return ScaleUtils.scale(14 + (errors.length() - 1) * 5);
        }

        @Override
        public int getIconWidth() {
            int result = 0;
            if (PTableHeaderRenderer.this.myErrorCount > 0) {
                result += this.getErrorSymbolWidth();
                if (this.mySortIcon != null) {
                    result += 4;
                }
            }
            if (this.mySortIcon != null) {
                result += this.mySortIcon.getIconWidth();
            }
            if (PTableHeaderRenderer.this.myFilterered) {
                result += CommonIcons.getFilterIcon().getIconWidth() + 1;
                if (this.mySortIcon == null) {
                    result -= 4;
                }
            }
            return result;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    class HeaderToggleButtonUI
    extends NetToggleButtonUI {
        HeaderToggleButtonUI() {
        }

        @Override
        protected Color getDisabledTextColor() {
            if (PTableHeaderRenderer.this.myTableHeader != null && PTableHeaderRenderer.this.myTableHeader.getTable() != null && PTableHeaderRenderer.this.myTableHeader.getTable().isEnabled()) {
                return PTableHeaderRenderer.this.myTableHeader.getForeground();
            }
            return super.getDisabledTextColor();
        }

        @Override
        protected void installKeyboardActions(AbstractButton b) {
        }

        @Override
        public void update(Graphics g, JComponent comp) {
            ColorUIResource topColor;
            boolean paintAsDisabled;
            Container ancestor;
            PTableHeaderRenderer.this.myFilterered = ClientPropertyUtil.booleanValue(comp, "OrangeTouch.isFiltered", false);
            AbstractButton button = (AbstractButton)comp;
            if (!button.isContentAreaFilled()) {
                this.paint(g, comp);
                return;
            }
            JTableHeader tableHeader = PTableHeaderRenderer.this.myTableHeader;
            if (tableHeader == null && (ancestor = PTableHeaderRenderer.this.getParent().getParent()) instanceof JTableHeader) {
                tableHeader = (JTableHeader)ancestor;
            }
            boolean bl = paintAsDisabled = tableHeader != null && !tableHeader.isEnabled() || tableHeader != null && tableHeader.getTable() != null && !tableHeader.getTable().isEnabled();
            if (comp.isOpaque()) {
                GradientUtils.drawVerticalBackgroundGradient(tableHeader, g);
            }
            Object oldAa = NetUtils.antiAliasingOn(g);
            boolean straightLeft = tableHeader != null && tableHeader.getTable() != null && Boolean.TRUE.equals(tableHeader.getTable().getClientProperty("OrangeTouch.isStraightLeftEdge"));
            comp.putClientProperty("OrangeTouch.isStraightLeftEdge", straightLeft);
            Shape fill = this.getFillShape(comp, straightLeft);
            Color color = topColor = PTableHeaderRenderer.this.getBackground() instanceof UIResource ? NetLookAndFeel.getWhite() : PTableHeaderRenderer.this.getBackground();
            if (paintAsDisabled) {
                g.setColor(NetUtils.isInDialog(tableHeader) ? UIManager.getColor("Table.disabledDialogBackground") : NetTheme.getMidGrayOutline());
                ((Graphics2D)g).fill(fill);
            } else {
                GradientUtils.drawVerticalGradient(comp, g, new Color[]{topColor, topColor}, fill);
                boolean isHeaderGroupRenderer = Boolean.TRUE.equals(comp.getClientProperty("OceanTouch.isHeaderGroupRenderer"));
                Color bottomColor = PTableHeaderRenderer.this.getBackground() instanceof UIResource ? UIManager.getColor("TableHeader.bottomColor") : PTableHeaderRenderer.this.getBackground();
                Color headerRendererBottomColor = UIManager.getColor("TableHeader.headerRendererBottomColor");
                GradientUtils.drawVerticalGradient(comp, g, new Color[]{topColor, isHeaderGroupRenderer ? headerRendererBottomColor : bottomColor}, (Shape)new Rectangle2D.Double(1.0, comp.getHeight() / 3 + 3, comp.getWidth() - 2, 2 * comp.getHeight() / 3 - 3));
            }
            NetUtils.setAntialiasing(g, oldAa);
            this.paint(g, comp);
        }

        private Shape getFillShape(JComponent c, boolean straightLeft) {
            boolean isLeftmostCell = Boolean.TRUE.equals(c.getClientProperty("Table.isLeftEnd")) && !straightLeft;
            boolean isRightmostCell = Boolean.TRUE.equals(c.getClientProperty("Table.isRightEnd"));
            int rounding = NetTheme.getNormalRounding();
            if (isLeftmostCell) {
                if (isRightmostCell) {
                    return NetUtils.getRoundedRect(c, 1, 1, c.getWidth() - 1, c.getHeight() - 1, rounding, 5);
                }
                return NetUtils.getRoundedRect(c, 1, 1, c.getWidth() - 1, c.getHeight() - 1, rounding, 3, 5);
            }
            if (isRightmostCell) {
                return NetUtils.getRoundedRect(c, 1, 1, c.getWidth() - 1, c.getHeight() - 1, rounding, 7, 5);
            }
            return new Rectangle2D.Double(1.0, 1.0, c.getWidth(), c.getHeight());
        }

        @Override
        protected void paintText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
            super.paintText(g, button, textRect, text);
            if (PTableHeaderRenderer.this.myTableHeader != null && PTableHeaderRenderer.this.myTableHeader.getToolTipText() == null && Boolean.TRUE.equals(button.getClientProperty("OrangeTouch.automaticTooltipEnabled")) && PTableHeaderRenderer.this.getText() != null) {
                if (text != null && !PTableHeaderRenderer.this.getText().equals(text) && (text.endsWith("...") || text.startsWith("..."))) {
                    PTableHeaderRenderer.this.setToolTipText(PTableHeaderRenderer.this.getText());
                } else {
                    PTableHeaderRenderer.this.setToolTipText(null);
                }
            }
        }
    }
}

