/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.table.ComparatorFactory;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.util.ComponentUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.table.TableModel;

public class PTableModelComparator
implements Comparator {
    private List<PComparatorModule> myCompareModules;
    private TableModel myModel;
    private PSortableTableModel mySortModel;
    private List<Integer> mySortedRows;

    public PTableModelComparator(TableModel model) {
        this.myCompareModules = new ArrayList<PComparatorModule>(model.getColumnCount());
        this.setModel(model);
    }

    void setSortableTableModel(PSortableTableModel sortableModel) {
        this.mySortModel = sortableModel;
    }

    void setSortedRows(List<Integer> sortedRows) {
        this.mySortedRows = new ArrayList<Integer>(sortedRows);
    }

    public void addSortColumn(int colIndex, Comparator<?> comparator) {
        PComparatorModule comparatorModule = null;
        for (PComparatorModule item : this.myCompareModules) {
            if (item.getColIndex() != colIndex) continue;
            comparatorModule = item;
            this.myCompareModules.remove(item);
            break;
        }
        if (comparatorModule == null) {
            Comparator c = null;
            if (comparator == null) {
                Class<?> clazz = this.myModel.getColumnClass(colIndex);
                c = ComparatorFactory.getComparator(clazz);
            } else {
                c = comparator;
            }
            comparatorModule = new PComparatorModule(colIndex, c, 2);
        } else if (comparator != null && !comparatorModule.getComparator().equals(comparator)) {
            comparatorModule.setComparator(comparator);
        }
        this.myCompareModules.add(comparatorModule);
    }

    public Comparator<?> getComparator(int columnIndex) {
        for (PComparatorModule module : this.myCompareModules) {
            if (module.getColIndex() != columnIndex) continue;
            return module.getComparator();
        }
        return ComparatorFactory.getComparator(this.myModel.getColumnClass(columnIndex));
    }

    public void resetSortColumns() {
        this.myCompareModules.clear();
    }

    public int getSortDirection(int colIndex) throws NoSuchElementException {
        for (PComparatorModule item : this.myCompareModules) {
            if (item.getColIndex() != colIndex) continue;
            return item.getSortDirection();
        }
        return -1;
    }

    public void switchDirection() {
        try {
            PComparatorModule cmodule = this.myCompareModules.listIterator(this.myCompareModules.size()).previous();
            cmodule.switchDirection();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void switchDirection(int colIndex) {
        for (PComparatorModule item : this.myCompareModules) {
            if (item.getColIndex() != colIndex) continue;
            item.switchDirection();
        }
    }

    public int compare(Object o1, Object o2) {
        int row1 = (Integer)o1;
        int row2 = (Integer)o2;
        int order = 0;
        ListIterator<PComparatorModule> iter = this.myCompareModules.listIterator(this.myCompareModules.size());
        while (iter.hasPrevious() && order == 0) {
            PComparatorModule cmodule = iter.previous();
            int col = cmodule.getColIndex();
            if (col < 0 || !ComponentUtils.isSortedColumn(this.mySortModel, col)) continue;
            Comparator<?> c = cmodule.getComparator();
            order = c.compare(this.myModel.getValueAt(row1, col), this.myModel.getValueAt(row2, col));
            if (cmodule.getSortDirection() == 1) continue;
            order *= -1;
        }
        if (order == 0 && this.mySortedRows != null) {
            return this.mySortedRows.indexOf(row1) - this.mySortedRows.indexOf(row2);
        }
        return order;
    }

    public void setModel(TableModel model) {
        this.myModel = model;
        this.resetSortColumns();
    }

    public void setDirection(int direction, int columnIndex) {
        try {
            for (PComparatorModule module : this.myCompareModules) {
                if (module.getColIndex() != columnIndex) continue;
                module.setDirection(direction);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private static class PComparatorModule {
        private int myColIndex;
        private Comparator<?> myComparator;
        private int mySortDirection;

        public PComparatorModule(int colIndex, Comparator<?> comparator, int direction) {
            this.myColIndex = colIndex;
            this.myComparator = comparator;
            this.mySortDirection = direction;
        }

        int getColIndex() {
            return this.myColIndex;
        }

        int getSortDirection() {
            return this.mySortDirection;
        }

        void switchDirection() {
            if (this.mySortDirection == 1) {
                this.mySortDirection = 2;
            } else if (this.mySortDirection == 2) {
                this.mySortDirection = 1;
            }
        }

        public void setDirection(int direction) {
            this.mySortDirection = direction;
        }

        Comparator<?> getComparator() {
            return this.myComparator;
        }

        void setComparator(Comparator<?> comparator) {
            this.myComparator = comparator;
        }

        public String toString() {
            return "PComparatorModule [colIndex: " + this.myColIndex + ", comparator: " + this.myComparator + ", sortDirection: " + this.mySortDirection + "]";
        }
    }
}

