/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.table.PCellStatusTableModel;
import com.nokia.widgets.table.PDeletableTableModel;
import com.nokia.widgets.table.PDisabledTableModel;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PTableModelComparator;
import com.nokia.widgets.table.PValidatableTableModel;
import com.nokia.widgets.table.StringConverter;
import com.nokia.widgets.table.TableRowFilter;
import com.nokia.widgets.table.TableSortEvent;
import com.nokia.widgets.table.TableSortListener;
import com.nokia.widgets.util.ComponentUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class PTableModelSorter
extends AbstractTableModel
implements PSortableTableModel,
PDisabledTableModel,
PCellStatusTableModel,
PValidatableTableModel,
TableModelListener {
    private TableRowFilter myFilter;
    private TableModel myModel;
    private PTableModelComparator myComparator;
    private List<Integer> mySortedRows;
    private Map<Integer, MnemonicData> myMnemonicData = new HashMap<Integer, MnemonicData>();
    private Map<Integer, Boolean> mySortableColumnMap = new HashMap<Integer, Boolean>();
    private int mySortedColumn = -1;
    private Map<Integer, Integer> myOriginalRowIndexCache = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> myFilteredRowIndexCache = new HashMap<Integer, Integer>();
    private Map<Integer, Map<Object, Integer>> myFirstRowOfValueCache = new HashMap<Integer, Map<Object, Integer>>();
    private int myCachedRowCount = -1;
    private int mySecondarySortColumn = -1;
    private int myTertiarySortColumn = -1;
    private List<TableSortListener> mySortListeners = new ArrayList<TableSortListener>();
    private StringConverter myStringConverter = new StringConverter();
    private boolean myAlwaysNotifySortListeners = false;

    public PTableModelSorter(TableModel modelIn) {
        this.setModel(modelIn);
    }

    public void setModel(TableModel modelIn) {
        if (this.myModel != null) {
            this.myModel.removeTableModelListener(this);
        }
        this.myModel = modelIn;
        this.initRows();
        this.myModel.addTableModelListener(this);
        this.myComparator = this.createComparator(this.myModel);
        this.myComparator.setSortableTableModel(this);
    }

    protected PTableModelComparator createComparator(TableModel model) {
        return new PTableModelComparator(model);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean shouldSort;
        boolean isSorted = this.getSortedColumnIndex() >= 0;
        int columnIndex = e.getColumn();
        boolean bl = shouldSort = e.getType() != -1 && (columnIndex == -1 || ComponentUtils.isSortedColumn(this, columnIndex));
        if (shouldSort) {
            this.myComparator.setSortedRows(this.mySortedRows);
            if (isSorted && !this.myAlwaysNotifySortListeners) {
                this.fireTableWillBeSorted();
            }
            this.initRows();
        } else if (e.getType() == -1) {
            this.initRows();
            this.myComparator.setSortedRows(this.mySortedRows);
            Collections.sort(this.mySortedRows, this.myComparator);
        }
        this.clearCachedValues();
        if (isSorted && shouldSort) {
            this.sort(false);
        }
        if (this.myFilter != null) {
            this.clearCachedValues();
        }
        super.fireTableChanged(e);
        if (isSorted && shouldSort && !this.myAlwaysNotifySortListeners) {
            this.fireTableSorted();
        }
    }

    @Override
    public int getRowCount() {
        if (this.myFilter == null) {
            return this.myModel.getRowCount();
        }
        if (this.myCachedRowCount != -1) {
            return this.myCachedRowCount;
        }
        int result = this.myModel.getRowCount();
        int row = 0;
        while (row < this.myModel.getRowCount()) {
            if (!this.myFilter.isIncluded(row, this)) {
                --result;
            }
            ++row;
        }
        this.myCachedRowCount = result;
        return result;
    }

    @Override
    public int getColumnCount() {
        return this.myModel.getColumnCount();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myModel.isCellEditable(this.getOriginalIndex(rowIndex), columnIndex);
    }

    @Override
    public int getSortedIndex(int originalRowIndex) {
        int sortedIndex = this.mySortedRows.indexOf(originalRowIndex);
        if (this.myFilter == null) {
            return sortedIndex;
        }
        Integer cachedValue = this.myFilteredRowIndexCache.get(originalRowIndex);
        if (cachedValue != null) {
            return cachedValue;
        }
        int includedRow = -1;
        int filteredRowCount = this.getRowCount();
        int viewRow = 0;
        while (viewRow < this.myModel.getRowCount()) {
            if (this.myFilter.isIncluded(this.mySortedRows.get(viewRow), this)) {
                ++includedRow;
            } else if (includedRow + 1 == filteredRowCount) {
                return -1;
            }
            if (viewRow == sortedIndex) {
                this.myFilteredRowIndexCache.put(originalRowIndex, includedRow);
                return includedRow;
            }
            ++viewRow;
        }
        return -1;
    }

    @Override
    public int getOriginalIndex(int row) {
        if (this.myFilter == null) {
            if (row < this.mySortedRows.size()) {
                return this.mySortedRows.get(row);
            }
            return -1;
        }
        Integer cachedRowIndex = this.myOriginalRowIndexCache.get(row);
        if (cachedRowIndex != null) {
            return cachedRowIndex;
        }
        int includedRow = -1;
        int viewRow = 0;
        while (viewRow < this.myModel.getRowCount()) {
            if (this.myFilter.isIncluded(this.mySortedRows.get(viewRow), this)) {
                ++includedRow;
            }
            if (includedRow == row) {
                int result = this.mySortedRows.get(viewRow);
                this.myOriginalRowIndexCache.put(row, result);
                return result;
            }
            ++viewRow;
        }
        return -1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myModel.getValueAt(this.getOriginalIndex(rowIndex), columnIndex);
    }

    @Override
    public int getSortedColumnIndex() {
        return this.mySortedColumn;
    }

    @Override
    public int getSecondarySortedColumnIndex() {
        return this.mySecondarySortColumn;
    }

    @Override
    public int getTertiarySortedColumnIndex() {
        return this.myTertiarySortColumn;
    }

    public void setSortMnemonicAt(int column, int mnemonic) {
        MnemonicData mnemonicData = this.myMnemonicData.get(column);
        if (mnemonicData == null) {
            this.myMnemonicData.put(column, new MnemonicData(mnemonic, -1));
        } else {
            mnemonicData.setMnemonic(mnemonic);
        }
    }

    public void setDisplayedSortMnemonicIndexAt(int column, int mnemonicIndex) {
        MnemonicData mnemonicData = this.myMnemonicData.get(column);
        if (mnemonicData == null) {
            this.myMnemonicData.put(column, new MnemonicData(-1, mnemonicIndex));
        } else {
            mnemonicData.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    @Override
    public int getSortMnemonicAt(int column) {
        MnemonicData data = this.myMnemonicData.get(column);
        if (data != null) {
            return data.getMnemonic();
        }
        return -1;
    }

    @Override
    public int getDisplayedSortMnemonicIndexAt(int column) {
        MnemonicData data = this.myMnemonicData.get(column);
        if (data != null) {
            return data.getDisplayedMnemonicIndex();
        }
        return -1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int originalIndex = this.getOriginalIndex(rowIndex);
        if (originalIndex == -1) {
            return;
        }
        this.myModel.setValueAt(aValue, originalIndex, columnIndex);
    }

    @Override
    public void addSortColumn(int columnIndex) {
        this.myComparator.addSortColumn(columnIndex, null);
    }

    @Override
    public void addSortColumn(int columnIndex, Comparator comparator) {
        this.myComparator.addSortColumn(columnIndex, comparator);
    }

    @Override
    public void resetSortColumns() {
        this.mySortedColumn = -1;
        this.mySecondarySortColumn = -1;
        this.myTertiarySortColumn = -1;
        this.myComparator.resetSortColumns();
    }

    @Override
    public void sort(boolean switchDirection) {
        if (this.myAlwaysNotifySortListeners) {
            this.fireTableWillBeSorted();
        }
        if (switchDirection) {
            this.myComparator.switchDirection();
        }
        this.myComparator.setSortedRows(this.mySortedRows);
        Collections.sort(this.mySortedRows, this.myComparator);
        this.clearCachedValues();
        this.fireTableChanged(new TableModelEvent(this, 0, this.myModel.getRowCount()));
        if (this.myAlwaysNotifySortListeners) {
            this.fireTableSorted();
        }
    }

    @Override
    public int sort(boolean switchDirection, int columnIndex, Comparator comparator) {
        this.resetSortColumns();
        this.mySortedColumn = columnIndex;
        this.addSortColumn(columnIndex, comparator);
        this.sort(switchDirection);
        return this.getSortDirection(columnIndex);
    }

    @Override
    public int subsort(boolean switchDirection, int columnIndex) {
        boolean tempSwitchDirection = switchDirection;
        if (this.mySortedColumn < 0 || columnIndex == this.mySortedColumn) {
            return this.sort(tempSwitchDirection, columnIndex);
        }
        if (this.myAlwaysNotifySortListeners) {
            this.fireTableWillBeSorted();
        }
        if (this.mySecondarySortColumn < 0) {
            this.myTertiarySortColumn = -1;
            this.mySecondarySortColumn = columnIndex;
            tempSwitchDirection = false;
        } else if (this.mySecondarySortColumn != columnIndex && this.mySortedColumn != columnIndex) {
            if (this.myTertiarySortColumn < 0) {
                tempSwitchDirection = false;
            }
            this.myTertiarySortColumn = columnIndex;
        }
        if (this.getTertiarySortedColumnIndex() >= 0) {
            this.addSortColumn(this.getTertiarySortedColumnIndex());
        }
        if (this.getSecondarySortedColumnIndex() >= 0) {
            this.addSortColumn(this.getSecondarySortedColumnIndex());
        }
        this.addSortColumn(this.getSortedColumnIndex());
        if (tempSwitchDirection) {
            this.myComparator.switchDirection(columnIndex);
        }
        Collections.sort(this.mySortedRows, this.myComparator);
        this.clearCachedValues();
        this.fireTableChanged(new TableModelEvent(this, 0, this.myModel.getRowCount()));
        if (this.myAlwaysNotifySortListeners) {
            this.fireTableSorted();
        }
        return this.getSortDirection(columnIndex);
    }

    @Override
    public int sort(boolean switchDirection, int columnIndex) {
        this.mySortedColumn = columnIndex;
        this.mySecondarySortColumn = -1;
        this.myTertiarySortColumn = -1;
        this.addSortColumn(columnIndex);
        this.sort(switchDirection);
        return this.getSortDirection(columnIndex);
    }

    @Override
    public int getSortDirection(int columnIndex) {
        return this.myComparator.getSortDirection(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.myModel.getColumnClass(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.myModel.getColumnName(columnIndex);
    }

    @Override
    public boolean isMandatory(int rowIndex, int colIndex) {
        int modelRow = this.getOriginalIndex(rowIndex);
        try {
            return ((PValidatableTableModel)this.myModel).isMandatory(modelRow, colIndex);
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    @Override
    public boolean isValid(int rowIndex, int colIndex) {
        try {
            return ((PValidatableTableModel)this.myModel).isValid(this.getOriginalIndex(rowIndex), colIndex);
        }
        catch (ClassCastException ex) {
            return true;
        }
    }

    @Override
    public boolean isMissing(int rowIndex, int colIndex) {
        int modelRow = this.getOriginalIndex(rowIndex);
        try {
            return ((PValidatableTableModel)this.myModel).isMissing(modelRow, colIndex);
        }
        catch (ClassCastException ex) {
            return this.myModel.getValueAt(modelRow, colIndex) == null;
        }
    }

    @Override
    public boolean isCellDisabled(int row, int column) {
        if (this.myModel instanceof PDisabledTableModel) {
            return ((PDisabledTableModel)((Object)this.myModel)).isCellDisabled(this.getOriginalIndex(row), column);
        }
        return false;
    }

    @Override
    public boolean isCellModified(int row, int column) {
        if (this.myModel instanceof PCellStatusTableModel) {
            return ((PCellStatusTableModel)((Object)this.myModel)).isCellModified(this.getOriginalIndex(row), column);
        }
        return false;
    }

    @Override
    public boolean isCellWarned(int row, int column) {
        if (this.myModel instanceof PCellStatusTableModel) {
            return ((PCellStatusTableModel)((Object)this.myModel)).isCellWarned(this.getOriginalIndex(row), column);
        }
        return false;
    }

    public boolean isCellDeleted(int row, int column) {
        int modelRow = this.mySortedRows.get(row);
        if (this.myModel instanceof PDeletableTableModel) {
            return ((PDeletableTableModel)((Object)this.myModel)).isCellDeleted(modelRow, column);
        }
        return false;
    }

    private void initRows() {
        this.mySortedRows = new ArrayList<Integer>(this.myModel.getRowCount());
        int i = 0;
        while (i < this.myModel.getRowCount()) {
            this.mySortedRows.add(i);
            ++i;
        }
    }

    @Override
    public void filter() {
        this.fireTableWillBeFiltered();
        this.clearCachedValues();
        this.fireTableDataChanged();
        this.fireTableFiltered();
    }

    @Override
    public void setRowFilter(TableRowFilter filter) {
        this.myFilter = filter;
        this.filter();
    }

    @Override
    public TableRowFilter getRowFilter() {
        return this.myFilter;
    }

    @Override
    public Comparator<?> getComparator(int columnIndex) {
        return this.myComparator.getComparator(columnIndex);
    }

    @Override
    public TableModel getWrappedModel() {
        return this.myModel;
    }

    @Override
    public void sort(int direction, int columnIndex) {
        this.mySortedColumn = columnIndex;
        this.addSortColumn(columnIndex);
        this.myComparator.setDirection(direction, columnIndex);
        Collections.sort(this.mySortedRows, this.myComparator);
        this.fireTableChanged(new TableModelEvent(this, 0, this.myModel.getRowCount()));
    }

    @Override
    public void subsort(int direction, int columnIndex) {
        if (this.mySortedColumn < 0) {
            this.sort(direction, columnIndex);
            return;
        }
        if (this.mySecondarySortColumn < 0) {
            this.myTertiarySortColumn = -1;
            this.mySecondarySortColumn = columnIndex;
        } else if (this.mySecondarySortColumn != columnIndex && this.mySortedColumn != columnIndex) {
            this.myTertiarySortColumn = columnIndex;
        }
        if (this.getTertiarySortedColumnIndex() >= 0) {
            this.addSortColumn(this.getTertiarySortedColumnIndex());
        }
        if (this.getSecondarySortedColumnIndex() >= 0) {
            this.addSortColumn(this.getSecondarySortedColumnIndex());
        }
        this.addSortColumn(this.getSortedColumnIndex());
        this.myComparator.setDirection(direction, columnIndex);
        Collections.sort(this.mySortedRows, this.myComparator);
        this.fireTableChanged(new TableModelEvent(this, 0, this.myModel.getRowCount()));
    }

    @Override
    public void secondarySort(int direction, int columnIndex) {
        if (this.mySortedColumn < 0) {
            return;
        }
        this.mySecondarySortColumn = columnIndex;
        this.addSortColumn(this.getTertiarySortedColumnIndex());
        this.addSortColumn(this.getSecondarySortedColumnIndex());
        this.addSortColumn(this.getSortedColumnIndex());
        this.myComparator.setDirection(direction, columnIndex);
        Collections.sort(this.mySortedRows, this.myComparator);
        this.fireTableChanged(new TableModelEvent(this, 0, this.myModel.getRowCount()));
    }

    @Override
    public void tertiarySort(int direction, int columnIndex) {
        if (this.mySortedColumn < 0 || this.mySecondarySortColumn < 0) {
            return;
        }
        this.myTertiarySortColumn = columnIndex;
        this.addSortColumn(this.getTertiarySortedColumnIndex());
        this.addSortColumn(this.getSecondarySortedColumnIndex());
        this.addSortColumn(this.getSortedColumnIndex());
        this.myComparator.setDirection(direction, columnIndex);
        Collections.sort(this.mySortedRows, this.myComparator);
        this.fireTableChanged(new TableModelEvent(this, 0, this.myModel.getRowCount()));
    }

    @Override
    public boolean isColumnSortable(int column) {
        return this.mySortableColumnMap.get(column) == null ? true : this.mySortableColumnMap.get(column);
    }

    @Override
    public void setColumnSortable(int column, boolean sortable) {
        this.mySortableColumnMap.put(column, sortable);
    }

    @Override
    public synchronized List<Object> getUniqueValues(int columnIndex) {
        Comparator<?> columnComparator = this.getComparator(columnIndex);
        TreeSet resultSet = new TreeSet(columnComparator);
        int idx = 0;
        while (idx < this.getRowCount()) {
            Object value = this.getValueAt(idx, columnIndex);
            resultSet.add(value);
            ++idx;
        }
        return new ArrayList<Object>(resultSet);
    }

    @Override
    public int getFirstRowOfValue(Object value, int columnIndex) {
        Map<Object, Integer> valueRowCache = this.myFirstRowOfValueCache.get(columnIndex);
        if (valueRowCache != null) {
            Integer cachedValue = valueRowCache.get(value);
            if (cachedValue != null) {
                return cachedValue;
            }
        } else {
            valueRowCache = new HashMap<Object, Integer>();
            this.myFirstRowOfValueCache.put(columnIndex, valueRowCache);
        }
        Comparator<?> columnComparator = this.getComparator(columnIndex);
        int row = 0;
        while (row < this.getRowCount()) {
            Object nextValue = this.getValueAt(row, columnIndex);
            if (columnComparator.compare(value, nextValue) == 0) {
                valueRowCache.put(value, row);
                return row;
            }
            ++row;
        }
        return -1;
    }

    @Override
    public String getStringValueAt(int rowIndex, int columnIndex) {
        return this.myStringConverter.toString(this.myModel.getValueAt(rowIndex, columnIndex), rowIndex, columnIndex, this.myModel);
    }

    public void setStringConverter(StringConverter converter) {
        this.myStringConverter = converter;
        this.filter();
    }

    public StringConverter getStringConverter() {
        return this.myStringConverter;
    }

    public void addTableSortListener(TableSortListener listener) {
        if (listener != null && !this.mySortListeners.contains(listener)) {
            this.mySortListeners.add(listener);
        }
    }

    public void removeTableSortListener(TableSortListener listener) {
        this.mySortListeners.remove(listener);
    }

    protected void fireTableWillBeSorted() {
        this.fireTableWillBeSorted(TableSortEvent.TYPE_SORTED);
    }

    protected void fireTableSorted() {
        this.fireTableSorted(TableSortEvent.TYPE_SORTED);
    }

    protected void fireTableWillBeFiltered() {
        this.fireTableWillBeSorted(TableSortEvent.TYPE_FILTERED);
    }

    protected void fireTableFiltered() {
        this.fireTableSorted(TableSortEvent.TYPE_FILTERED);
    }

    protected void fireTableWillBeSorted(int eventType) {
        TableSortEvent event = new TableSortEvent(this, eventType);
        for (TableSortListener listener : this.mySortListeners) {
            listener.tableWillBeSorted(event);
        }
    }

    protected void fireTableSorted(int eventType) {
        TableSortEvent event = new TableSortEvent(this, eventType);
        for (TableSortListener listener : this.mySortListeners) {
            listener.tableSorted(event);
        }
    }

    protected void clearCachedValues() {
        this.myCachedRowCount = -1;
        this.myOriginalRowIndexCache.clear();
        this.myFilteredRowIndexCache.clear();
        this.myFirstRowOfValueCache.clear();
    }

    public void setAlwaysNotifySortListeners(boolean alwaysNotifySortListeners) {
        this.myAlwaysNotifySortListeners = alwaysNotifySortListeners;
    }

    public boolean isAlwaysNotifySortListeners() {
        return this.myAlwaysNotifySortListeners;
    }

    private static class MnemonicData {
        private int myMnemonic;
        private int myDisplayedMnemonicIndex;

        public MnemonicData(int mnemonic, int displayedMnemonicIndex) {
            this.myMnemonic = mnemonic;
            this.myDisplayedMnemonicIndex = displayedMnemonicIndex;
        }

        public void setMnemonic(int mnemonic) {
            this.myMnemonic = mnemonic;
        }

        public void setDisplayedMnemonicIndex(int displayedMnemonicIndex) {
            this.myDisplayedMnemonicIndex = displayedMnemonicIndex;
        }

        public int getMnemonic() {
            return this.myMnemonic;
        }

        public int getDisplayedMnemonicIndex() {
            return this.myDisplayedMnemonicIndex;
        }
    }
}

