/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PToggleButton;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.CompoundIcon;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;

public class PTablePanel
extends PPanel
implements ItemListener {
    private JTable myTable;
    private JScrollPane myScrollPane;
    private JToggleButton myInfoButton;
    private int myInfoRowHeight = -1;

    public PTablePanel(JScrollPane tableScroll, Object[] infoRow) {
        this.setLayout(new InfoRowLayout());
        this.myTable = (JTable)tableScroll.getViewport().getView();
        this.myTable.putClientProperty("OrangeTouch.isStraightLeftEdge", true);
        this.setInfoRow(infoRow);
        this.myScrollPane = (JScrollPane)this.add(tableScroll);
        this.myInfoButton = (JToggleButton)this.add(new PInfoButton());
        this.myInfoButton.setName("PTablePanel.InfoButton");
    }

    public Object[] getInfoRow() {
        return (Object[])this.myTable.getClientProperty("infoRow");
    }

    public void setInfoRow(Object[] infoRow) {
        this.myTable.putClientProperty("infoRow", infoRow);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        this.myTable.putClientProperty("infoRowVisible", evt.getStateChange() == 1);
    }

    private class InfoRowLayout
    implements LayoutManager {
        private InfoRowLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            if (PTablePanel.this.myInfoRowHeight <= 1) {
                PTablePanel.this.myInfoRowHeight = PTablePanel.this.myTable.getTableHeader().getHeight();
            }
            if (PTablePanel.this.getComponentOrientation().isLeftToRight()) {
                int headerYPos = PTablePanel.this.myTable.getTableHeader().getY() + 1;
                PTablePanel.this.myInfoButton.setLocation(insets.left, headerYPos);
                PTablePanel.this.myInfoButton.setSize(((PTablePanel)PTablePanel.this).myInfoButton.getPreferredSize().width, PTablePanel.this.myInfoRowHeight + 4);
                PTablePanel.this.myScrollPane.setLocation(PTablePanel.this.myInfoButton.getX() + PTablePanel.this.myInfoButton.getWidth(), insets.top);
                PTablePanel.this.myScrollPane.setSize(size.width - PTablePanel.this.myInfoButton.getWidth(), size.height);
            } else {
                int headerYPos = PTablePanel.this.myTable.getTableHeader().getY();
                PTablePanel.this.myInfoButton.setLocation(size.width - insets.right - ((PTablePanel)PTablePanel.this).myInfoButton.getPreferredSize().width, headerYPos);
                PTablePanel.this.myInfoButton.setSize(((PTablePanel)PTablePanel.this).myInfoButton.getPreferredSize().width, PTablePanel.this.myInfoRowHeight);
                PTablePanel.this.myScrollPane.setLocation(insets.left, insets.top);
                PTablePanel.this.myScrollPane.setSize(size.width - PTablePanel.this.myInfoButton.getWidth(), size.height);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(((PTablePanel)PTablePanel.this).myScrollPane.getPreferredSize().width + ((PTablePanel)PTablePanel.this).myInfoButton.getPreferredSize().width, ((PTablePanel)PTablePanel.this).myScrollPane.getPreferredSize().height);
        }
    }

    private class PInfoButton
    extends PToggleButton {
        public PInfoButton() {
            ImageIcon infoIcon = CommonIcons.getInfoIcon();
            BufferedImage bufImage = ImageUtils.createImage(this, infoIcon);
            ImageIcon scaledIcon = new ImageIcon(ImageUtils.createScaledInstance(bufImage, 14, 14));
            CompoundIcon rowShownIcon = new CompoundIcon(scaledIcon, new PArrowIcon(6, 3, (Color)NetLookAndFeel.getControlInfo(), 5));
            rowShownIcon.setInnerIconHorizontalAlignment(4);
            rowShownIcon.setInnerIconVerticalAlignment(3);
            Insets margin = new Insets(1, 2, 1, 4);
            rowShownIcon.setMargin(margin);
            CompoundIcon rowHiddenIcon = new CompoundIcon(scaledIcon, new PArrowIcon(6, 3, (Color)NetLookAndFeel.getControlInfo(), 3));
            rowHiddenIcon.setMargin(margin);
            rowHiddenIcon.setInnerIconHorizontalAlignment(4);
            rowHiddenIcon.setInnerIconVerticalAlignment(3);
            this.setIcon(rowHiddenIcon);
            this.setRolloverIcon(rowHiddenIcon);
            this.setSelectedIcon(rowShownIcon);
            this.setRolloverSelectedIcon(rowShownIcon);
            this.addItemListener(PTablePanel.this);
            this.setSegmentPosition("first");
            this.setFocusable(false);
        }

        @Override
        protected void paintBorder(Graphics g) {
            super.paintBorder(g);
            if (!this.getModel().isRollover()) {
                g.setColor(NetTheme.getComponentOutlineColor());
                g.drawLine(this.getX() + this.getWidth() - 1, this.getY(), this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 5);
            }
        }
    }
}

