/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.table.PTable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class PTableTransferHandler
extends TransferHandler
implements Transferable {
    private static final int COLUMN_OFFSET = 3;
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{DataFlavor.stringFlavor};
    private String myContents;

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (comp instanceof JTable) {
            this.myContents = this.getCopiedContents((PTable)comp);
            if (this.myContents != null && !this.myContents.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public String getCopiedContents(JTable table) {
        int[] cols;
        int counter;
        int[] rows;
        if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
            return null;
        }
        if (!table.getRowSelectionAllowed()) {
            int rowCount = table.getRowCount();
            rows = new int[rowCount];
            counter = 0;
            while (counter < rowCount) {
                rows[counter] = counter;
                ++counter;
            }
        } else {
            rows = table.getSelectedRows();
        }
        if (!table.getColumnSelectionAllowed()) {
            int colCount = table.getColumnCount();
            cols = new int[colCount];
            counter = 0;
            while (counter < colCount) {
                cols[counter] = counter;
                ++counter;
            }
        } else {
            cols = table.getSelectedColumns();
        }
        if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
            return null;
        }
        int[] suitWidth = this.getSuitableColumnWidth(table);
        return this.createCopiedContent(suitWidth, table);
    }

    private String createCopiedContent(int[] suitWidth, JTable table) {
        StringBuilder copiedContent = new StringBuilder("");
        int column = 0;
        while (column < table.getColumnCount()) {
            String columnName = table.getColumnModel().getColumn(column).getHeaderValue().toString();
            copiedContent.append(String.format("%-" + suitWidth[column] + "s", columnName));
            ++column;
        }
        copiedContent.append("\n");
        int[] selectedRows = table.getSelectedRows();
        int index = 0;
        while (index < selectedRows.length) {
            int column2 = 0;
            while (column2 < table.getColumnCount()) {
                Object value = table.getValueAt(selectedRows[index], column2);
                copiedContent.append(String.format("%-" + suitWidth[column2] + "s", value == null ? "" : value.toString()));
                ++column2;
            }
            copiedContent.append("\n");
            ++index;
        }
        return copiedContent.toString();
    }

    private int[] getSuitableColumnWidth(JTable table) {
        int[] suitWidth = new int[table.getColumnCount()];
        int column = 0;
        while (column < table.getColumnCount()) {
            int longest = 0;
            int columNameWidth = table.getColumnModel().getColumn(column).getHeaderValue().toString().length();
            longest = columNameWidth > longest ? columNameWidth : longest;
            int row = 0;
            while (row < table.getRowCount()) {
                int length = table.getValueAt(row, column) != null ? table.getValueAt(row, column).toString().length() : 0;
                longest = length > longest ? length : longest;
                ++row;
            }
            suitWidth[column] = longest + 3;
            ++column;
        }
        return suitWidth;
    }

    @Override
    protected Transferable createTransferable(JComponent comp) {
        if (comp instanceof JTable) {
            this.myContents = this.getCopiedContents((JTable)comp);
            if (this.myContents != null && !this.myContents.isEmpty()) {
                return this;
            }
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return true;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.myContents;
    }
}

