/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.table.PTableTransferHandler;
import com.nokia.widgets.util.WidgetResources;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class PTransferTable
extends JTable {
    public PTransferTable() {
    }

    public PTransferTable(TableModel dm) {
        super(dm);
    }

    public PTransferTable(Object[][] cellData, String[] columnNames) {
        super(cellData, columnNames);
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.initPopupMenu();
    }

    protected void initPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyPopupItem = new JMenuItem(WidgetResources.getString("Table.Copy"));
        popupMenu.add(copyPopupItem);
        copyPopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PTransferTable.this.handelAction(event);
            }
        });
        this.setComponentPopupMenu(popupMenu);
        this.setTransferHandler(new PTableTransferHandler());
        this.addMouseListener(new CopyMouseListener());
        this.addKeyListener(new CopyKeyListener());
    }

    @Override
    public Point getPopupLocation(MouseEvent event) {
        if (event == null) {
            Rectangle selectedRect = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), false);
            int x = (int)(selectedRect.getX() + (double)(selectedRect.width / 4));
            int y = (int)(selectedRect.getY() + (double)(selectedRect.height / 2));
            return new Point(x, y);
        }
        return super.getPopupLocation(event);
    }

    private void handelAction(AWTEvent e) {
        if (this.isCopiedByMenu(e) || this.isCopiedByKeyBoard(e)) {
            try {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                this.getTransferHandler().exportToClipboard(this, cb, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected boolean isCopiedByKeyBoard(AWTEvent e) {
        KeyEvent event;
        return e instanceof KeyEvent && (event = (KeyEvent)e).isControlDown() && 67 == event.getKeyCode();
    }

    protected boolean isCopiedByMenu(AWTEvent e) {
        ActionEvent event;
        return e instanceof ActionEvent && (event = (ActionEvent)e).getActionCommand().equals(WidgetResources.getString("Table.Copy"));
    }

    private class CopyKeyListener
    extends KeyAdapter {
        private CopyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            PTransferTable.this.handelAction(e);
        }
    }

    private class CopyMouseListener
    extends MouseAdapter {
        private CopyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.handelSelectionChange(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.handelSelectionChange(event);
        }

        private void handelSelectionChange(MouseEvent event) {
            if (event.isPopupTrigger() || SwingUtilities.isRightMouseButton(event)) {
                PTransferTable.this.requestFocusInWindow();
                int row = PTransferTable.this.rowAtPoint(event.getPoint());
                int column = PTransferTable.this.columnAtPoint(event.getPoint());
                int[] selectedRows = PTransferTable.this.getSelectedRows();
                if (Arrays.binarySearch(selectedRows, row) < 0 && row > -1 && column > -1) {
                    PTransferTable.this.changeSelection(row, column, false, false);
                } else {
                    PTransferTable.this.changeSelection(row, column, true, true);
                }
            }
        }
    }
}

