/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class RadioButtonRenderer
extends JRadioButton
implements TableCellRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public RadioButtonRenderer() {
        this.setHorizontalAlignment(0);
        this.putClientProperty("JComponent.sizeVariant", "small");
        this.setBorderPainted(true);
        this.setFocusPainted(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean editable = table.isCellEditable(row, column) && table.isEnabled();
        this.setEnabled(editable);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setSelected(value != null && (Boolean)value != false);
        this.getModel().setRollover(ComponentUtils.isRolloveredCell(table, row, column));
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        return this;
    }
}

