/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.table.PValidatableTableModel;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class TableModelValidator {
    private JTable myTable;
    private static CellFilter INVALID_FILTER = new CellFilter(){

        @Override
        public boolean accept(PValidatableTableModel model, int row, int column) {
            return !model.isValid(row, column);
        }
    };
    private static CellFilter REQUIRED_BUT_MISSING_FILTER = new CellFilter(){

        @Override
        public boolean accept(PValidatableTableModel model, int row, int column) {
            return model.isMandatory(row, column) && model.isMissing(row, column);
        }
    };

    public TableModelValidator(JTable table) {
        this.myTable = table;
    }

    public boolean hasMissingCells() {
        return this.getMissingCellCount() > 0;
    }

    public boolean hasInvalidCells() {
        return this.getInvalidCellCount() > 0;
    }

    public boolean isValid() {
        return !this.hasMissingCells() && !this.hasInvalidCells();
    }

    public Set getInvalidCells() {
        return this.handleInvalidEditor(this.getFilteredCells(INVALID_FILTER));
    }

    public Set getMissingCells() {
        return this.handleMissingEditor(this.getFilteredCells(REQUIRED_BUT_MISSING_FILTER));
    }

    public int getMissingCellCount() {
        return this.getMissingCells().size();
    }

    public int getInvalidCellCount() {
        return this.getInvalidCells().size();
    }

    public boolean editorHasMissingValue() {
        return this.editorHasProperty("requiredButMissing");
    }

    public boolean editorHasInvalidValue() {
        return this.editorHasProperty("invalidEntry");
    }

    private boolean editorHasProperty(String propertyName) {
        if (!this.myTable.isEditing()) {
            return false;
        }
        Component comp = this.myTable.getEditorComponent();
        if (comp instanceof JSpinner) {
            comp = ((JSpinner)comp).getEditor();
        }
        if (comp instanceof JComponent) {
            return ClientPropertyUtil.booleanValue((JComponent)comp, propertyName);
        }
        return false;
    }

    private Set handleMissingEditor(Set missingCells) {
        Point editingCell = this.getEditingCell();
        if (editingCell != null) {
            if (this.editorHasMissingValue()) {
                missingCells.add(editingCell);
            } else {
                missingCells.remove(editingCell);
            }
        }
        return missingCells;
    }

    private Set handleInvalidEditor(Set invalidCells) {
        Point editingCell = this.getEditingCell();
        if (editingCell != null) {
            if (this.editorHasInvalidValue()) {
                invalidCells.add(editingCell);
            } else {
                invalidCells.remove(editingCell);
            }
        }
        return invalidCells;
    }

    private Point getEditingCell() {
        int editingRow = this.myTable.getEditingRow();
        int editingColumn = this.myTable.getEditingColumn();
        if (this.myTable.isEditing() && editingRow > -1 && editingColumn > -1) {
            return new Point(editingRow, editingColumn);
        }
        return null;
    }

    private Set<Point> getFilteredCells(CellFilter filter) {
        HashSet<Point> result = new HashSet<Point>();
        TableModel model = this.myTable.getModel();
        if (!(model instanceof PValidatableTableModel)) {
            return result;
        }
        PValidatableTableModel validatableModel = (PValidatableTableModel)model;
        int column = 0;
        while (column < model.getColumnCount()) {
            int row = 0;
            while (row < model.getRowCount()) {
                if (filter.accept(validatableModel, row, column)) {
                    result.add(new Point(row, column));
                }
                ++row;
            }
            ++column;
        }
        return result;
    }

    private static interface CellFilter {
        public boolean accept(PValidatableTableModel var1, int var2, int var3);
    }
}

