/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.search.SearchEvent;
import com.nokia.widgets.search.SearchListener;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PTableModelSorter;
import com.nokia.widgets.table.StringConverter;
import com.nokia.widgets.table.TableHighlight;
import com.nokia.widgets.table.TableSearchTextField;
import com.nokia.widgets.table.TableSortEvent;
import com.nokia.widgets.table.TableSortListener;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.search.SearchBar;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.Position;

public class TableSearchBar
extends SearchBar
implements SearchListener,
PropertyChangeListener {
    private JTable myTable;
    private TableSearchTextField mySearchTextField;
    ListIterator<TableHighlight> mySearchHits;
    private Object myCurrentHighlight = null;
    private TableSortListener mySortListener = new TableSortHandler();
    private TableModelHandler myTableModelHandler = new TableModelHandler();

    public TableSearchBar(JTable table) {
        this.myTable = table;
        this.mySearchTextField = this.createTableSearchTextField(table);
        this.mySearchTextField.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent event) {
                TableSearchBar.this.myCurrentHighlight = null;
                TableSearchBar.this.mySearchHits = null;
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                this.removeUpdate(event);
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                this.removeUpdate(event);
            }
        });
        this.mySearchTextField.addSearchListener(this);
        this.myTable.getModel().addTableModelListener(this.myTableModelHandler);
        if (table.getModel() instanceof PTableModelSorter) {
            ((PTableModelSorter)table.getModel()).addTableSortListener(this.mySortListener);
        }
        this.buildUI();
        table.addPropertyChangeListener("model", this);
    }

    public void setStringConverter(StringConverter stringConverter) {
        this.mySearchTextField.setStringConverter(stringConverter);
    }

    @Override
    protected PTextField getPTextField() {
        return this.mySearchTextField;
    }

    protected TableSearchTextField createTableSearchTextField(JTable table) {
        return new TableSearchTextField(table);
    }

    private void setIteratorToCurrentHighlight() {
        if (this.myCurrentHighlight == null || this.mySearchHits == null) {
            return;
        }
        this.myPreviousSearchDirection = Position.Bias.Forward;
        this.mySearchHits = this.mySearchTextField.getMatches().listIterator();
        while (this.mySearchHits.hasNext()) {
            TableHighlight nextHighlight = this.mySearchHits.next();
            if (!nextHighlight.equals(this.myCurrentHighlight)) continue;
            this.updateEmphasizedMatch(nextHighlight);
            return;
        }
    }

    private void updateEmphasizedMatch(TableHighlight emphasizedMatch) {
        this.myCurrentHighlight = emphasizedMatch;
        this.myTable.putClientProperty("OrangeTouch.tableEmphasizedHighlight", emphasizedMatch);
        this.scrollMatchToVisible(emphasizedMatch);
        this.myTable.repaint();
    }

    @Override
    public void setMaxSearchCount(int maxSearchCount) {
        super.setMaxSearchCount(maxSearchCount);
        this.mySearchTextField.setMaxSearchCount(maxSearchCount);
    }

    private void search(Position.Bias bias) {
        boolean searchDirectionChanged = this.isSearchDirectionChanged(bias);
        this.setPreviousSearchDirection(bias);
        if (this.mySearchHits == null) {
            this.mySearchHits = this.mySearchTextField.getMatches().listIterator();
        }
        TableHighlight nextMatch = this.getNextMatch(bias, searchDirectionChanged);
        this.updateEmphasizedMatch(nextMatch);
    }

    private void clearHighlights() {
        this.myTable.putClientProperty("OrangeTouch.tableEmphasizedHighlight", null);
        this.myTable.putClientProperty("OrangeTouch.highlightText", null);
    }

    @Override
    public void searchFinished(SearchEvent event) {
        this.myMatchCount = this.mySearchTextField.getMatches().size();
        this.setSearchButtonsEnabled(this.myMatchCount > 0);
        if (this.mySearchTextField.getText().isEmpty()) {
            this.clearHighlights();
        }
        this.updateMatchesCount();
        this.setPreviousSearchDirection(null);
        this.myTable.repaint();
    }

    private TableHighlight getNextMatch(Position.Bias bias, boolean searchDirectionChanged) {
        TableHighlight nextMatch = null;
        if (bias == Position.Bias.Forward) {
            nextMatch = this.nextForwardMatch();
            if (searchDirectionChanged) {
                nextMatch = this.nextForwardMatch();
            }
        } else {
            nextMatch = this.nextBackwardMatch();
            if (searchDirectionChanged) {
                nextMatch = this.nextBackwardMatch();
            }
        }
        return nextMatch;
    }

    private void scrollMatchToVisible(TableHighlight match) {
        if (match == null) {
            return;
        }
        int row = match.getRow();
        if (this.myTable.getModel() instanceof PSortableTableModel) {
            row = ((PSortableTableModel)this.myTable.getModel()).getSortedIndex(row);
        }
        int column = this.myTable.convertColumnIndexToView(match.getColumn());
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, column, false));
    }

    private TableHighlight nextBackwardMatch() {
        if (this.mySearchHits.hasPrevious()) {
            return this.mySearchHits.previous();
        }
        this.mySearchHits = this.mySearchTextField.getMatches().listIterator(this.mySearchTextField.getMatches().size());
        if (this.mySearchHits.hasPrevious()) {
            return this.mySearchHits.previous();
        }
        return null;
    }

    private TableHighlight nextForwardMatch() {
        if (this.mySearchHits.hasNext()) {
            return this.mySearchHits.next();
        }
        this.mySearchHits = this.mySearchTextField.getMatches().listIterator();
        if (this.mySearchHits.hasNext()) {
            return this.mySearchHits.next();
        }
        return null;
    }

    @Override
    public void searchStarted(SearchEvent event) {
        this.mySearchHits = null;
    }

    public StringConverter getStringConverter() {
        return this.mySearchTextField.getStringConverter();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        TableModel newValue;
        if (!"model".equals(event.getPropertyName())) {
            return;
        }
        TableModel oldValue = (TableModel)event.getOldValue();
        if (oldValue != null) {
            oldValue.removeTableModelListener(this.myTableModelHandler);
            if (oldValue instanceof PTableModelSorter) {
                ((PTableModelSorter)oldValue).removeTableSortListener(this.mySortListener);
            }
        }
        if ((newValue = (TableModel)event.getNewValue()) != null) {
            newValue.addTableModelListener(this.myTableModelHandler);
            if (newValue instanceof PTableModelSorter) {
                ((PTableModelSorter)newValue).addTableSortListener(this.mySortListener);
            }
        }
    }

    @Override
    protected void nextMatchAction(ActionEvent e) {
        this.search(Position.Bias.Forward);
    }

    @Override
    protected void previousMatchAction(ActionEvent e) {
        this.search(Position.Bias.Backward);
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (!TableSearchBar.this.isUpdateSearchResultsOnModelUpdate() || "".equals(TableSearchBar.this.mySearchTextField.getText())) {
                return;
            }
            TableSearchBar.this.mySearchTextField.search(false);
            TableSearchBar.this.mySearchHits = TableSearchBar.this.mySearchTextField.getMatches().listIterator();
            TableSearchBar.this.setIteratorToCurrentHighlight();
        }
    }

    private class TableSortHandler
    implements TableSortListener {
        private TableSortHandler() {
        }

        @Override
        public void tableWillBeSorted(TableSortEvent event) {
        }

        @Override
        public void tableSorted(TableSortEvent event) {
            TableSearchBar.this.setIteratorToCurrentHighlight();
        }
    }
}

