/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PTableModelSorter;
import com.nokia.widgets.table.StringConverter;
import com.nokia.widgets.table.TableHighlight;
import com.nokia.widgets.table.TableSortEvent;
import com.nokia.widgets.table.TableSortListener;
import com.nokia.widgets.tree.AbstractSearchTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class TableSearchTextField
extends AbstractSearchTextField
implements TableSortListener {
    protected JTable myTable;
    private List<TableHighlight> myMatches = new LinkedList<TableHighlight>();
    private StringConverter myStringConverter;

    public TableSearchTextField(JTable JTable2) {
        this.setName("JTableSearchTextField");
        this.myTable = JTable2;
        this.myTable.addPropertyChangeListener("model", this);
        if (this.myTable.getModel() instanceof PTableModelSorter) {
            PTableModelSorter newSortModel = (PTableModelSorter)this.myTable.getModel();
            newSortModel.setAlwaysNotifySortListeners(true);
            newSortModel.addTableSortListener(this);
        }
    }

    public JTable getTable() {
        return this.myTable;
    }

    public List<TableHighlight> getMatches() {
        return this.myMatches;
    }

    @Override
    protected ActionListener createSearchAction() {
        return new SearchAction();
    }

    protected void collectMatches(Pattern pattern) {
        this.collectMatches(pattern, -1, true);
    }

    protected void collectMatches(Pattern pattern, int toScrollVisible, boolean scrollFirstMatchVisible) {
        int rowToScrollVisible;
        String regex = pattern.pattern();
        String unescaped = regex.replaceAll("(\\\\)(\\p{Punct})", "$2");
        int selectedRow = this.myTable.getSelectedRow();
        int nodeToScrollVisible = -1;
        int row = 0;
        while (row < this.myTable.getRowCount()) {
            if (this.myMaxSearchCount != -1 && this.getMatches().size() > this.myMaxSearchCount) break;
            int modelRow = this.getModelRow(row);
            int column = 0;
            while (column < this.myTable.getColumnCount()) {
                int modelColumn = this.myTable.convertColumnIndexToModel(column);
                String tableCellText = this.convertValueToText(modelRow, modelColumn);
                Matcher tableMatcher = pattern.matcher(tableCellText.toUpperCase());
                while (tableMatcher.find()) {
                    TableHighlight TableHighlight2 = new TableHighlight(unescaped, modelRow, modelColumn, tableMatcher.start());
                    if (nodeToScrollVisible == -1 && toScrollVisible == -1) {
                        nodeToScrollVisible = row;
                    }
                    this.getMatches().add(TableHighlight2);
                }
                ++column;
            }
            ++row;
        }
        this.sortMatchesToViewOrder();
        int pathToScrollVisible = toScrollVisible;
        if (pathToScrollVisible == -1 && this.getMatches().size() > 0) {
            TableHighlight firstMatch = this.getMatches().get(0);
            pathToScrollVisible = firstMatch.getRow();
        }
        if ((rowToScrollVisible = this.getViewRow(pathToScrollVisible)) >= 0 && (toScrollVisible != -1 || scrollFirstMatchVisible)) {
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(rowToScrollVisible, this.myTable.convertColumnIndexToView(0), false));
        }
        if (selectedRow >= 0) {
            int row2 = this.getViewRow(selectedRow);
            this.myTable.getSelectionModel().addSelectionInterval(row2, row2);
        }
    }

    public void search(boolean scrollFirstMatchVisible) {
        this.search(-1, scrollFirstMatchVisible);
    }

    public void search() {
        this.search(-1, true);
    }

    public void search(int toScrollVisible, boolean scrollFirstMatchVisible) {
        this.fireSearchStarted();
        this.myMatches.clear();
        if (this.myTable.isEditing() && !this.myTable.getCellEditor().stopCellEditing()) {
            this.myTable.getCellEditor().cancelCellEditing();
        }
        String searchText = this.getText();
        this.myTable.putClientProperty("OrangeTouch.highlightText", searchText);
        if (searchText == null || searchText.length() == 0) {
            this.myTable.repaint();
            this.fireSearchFinished();
            return;
        }
        searchText = searchText.replaceAll("(\\p{Punct})", "\\\\$1");
        Pattern pattern = Pattern.compile(searchText.toUpperCase());
        try {
            this.collectMatches(pattern, toScrollVisible, scrollFirstMatchVisible);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fireSearchFinished();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (!"model".equals(evt.getPropertyName())) {
            return;
        }
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getNewValue();
        if (oldValue instanceof PTableModelSorter) {
            PTableModelSorter oldSortModel = (PTableModelSorter)newValue;
            oldSortModel.removeTableSortListener(this);
        }
        if (newValue instanceof PTableModelSorter) {
            PTableModelSorter newSortModel = (PTableModelSorter)newValue;
            newSortModel.setAlwaysNotifySortListeners(true);
            newSortModel.addTableSortListener(this);
        }
        this.sortMatchesToViewOrder();
    }

    private String convertValueToText(int rowIndex, int columnIndex) {
        TableModel model = this.myTable.getModel();
        if (model instanceof PSortableTableModel) {
            return ((PSortableTableModel)model).getStringValueAt(rowIndex, columnIndex);
        }
        Object value = model.getValueAt(rowIndex, columnIndex);
        if (this.myStringConverter != null) {
            return this.myStringConverter.toString(value, rowIndex, columnIndex, model);
        }
        return value != null ? value.toString() : "";
    }

    private int getModelRow(int viewRow) {
        if (viewRow < 0) {
            return viewRow;
        }
        PSortableTableModel sortModel = this.getSortableModel();
        return sortModel != null ? sortModel.getSortedIndex(viewRow) : viewRow;
    }

    private int getViewRow(int modelRow) {
        if (modelRow < 0) {
            return modelRow;
        }
        PSortableTableModel sortModel = this.getSortableModel();
        return sortModel != null ? sortModel.getSortedIndex(modelRow) : modelRow;
    }

    private PSortableTableModel getSortableModel() {
        if (this.myTable.getModel() instanceof PSortableTableModel) {
            return (PSortableTableModel)this.myTable.getModel();
        }
        return null;
    }

    private void sortMatchesToViewOrder() {
        Collections.sort(this.getMatches(), new ViewOrderComparator(this.getSortableModel()));
    }

    @Override
    public void tableWillBeSorted(TableSortEvent event) {
    }

    @Override
    public void tableSorted(TableSortEvent event) {
        this.sortMatchesToViewOrder();
    }

    StringConverter getStringConverter() {
        return this.myStringConverter;
    }

    void setStringConverter(StringConverter stringConverter) {
        this.myStringConverter = stringConverter;
    }

    public final class SearchAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            TableSearchTextField.this.search();
        }
    }

    private class ViewOrderComparator
    implements Comparator<TableHighlight> {
        private final PSortableTableModel mySortModel;

        public ViewOrderComparator(PSortableTableModel sortModel) {
            this.mySortModel = sortModel;
        }

        @Override
        public int compare(TableHighlight o1, TableHighlight o2) {
            int column2;
            int sortedRow2;
            int row = o1.getRow();
            int row2 = o2.getRow();
            int sortedRow = this.mySortModel == null ? row : this.mySortModel.getSortedIndex(row);
            int n = sortedRow2 = this.mySortModel == null ? row2 : this.mySortModel.getSortedIndex(row2);
            if (sortedRow != sortedRow2) {
                return sortedRow - sortedRow2;
            }
            int column = TableSearchTextField.this.myTable.convertColumnIndexToView(o1.getColumn());
            if (column != (column2 = TableSearchTextField.this.myTable.convertColumnIndexToView(o2.getColumn()))) {
                return column - column2;
            }
            return o1.getIndex() - o2.getIndex();
        }
    }
}

