/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.TableRowFilter;
import java.util.regex.Pattern;

public class TextColumnFilter
implements TableRowFilter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Pattern NEWLINE_PATTERN = Pattern.compile("[\n'" + LINE_SEPARATOR + "']");
    private static final String EXACT_MATCH_INDICATOR = "\"";
    private transient String myFilterText;
    private transient String myLowerCaseText;
    private transient int myColumnIndex;
    protected transient boolean myIsExactMatch = false;
    private transient boolean myTextDefined;

    public TextColumnFilter(String text, int columnIndex) {
        this.myColumnIndex = columnIndex;
        this.setFilterText(text);
    }

    public void setFilterText(String text) {
        this.myFilterText = this.removeLineSeparators(text);
        boolean bl = this.myIsExactMatch = this.myFilterText != null && this.myFilterText.startsWith(EXACT_MATCH_INDICATOR) && this.myFilterText.endsWith(EXACT_MATCH_INDICATOR);
        if (this.myIsExactMatch) {
            this.myFilterText = this.myFilterText.substring(1);
            if (this.myFilterText.length() > 1) {
                this.myFilterText = this.myFilterText.substring(0, this.myFilterText.length() - 1);
            }
        }
        this.myLowerCaseText = this.myFilterText != null ? this.myFilterText.toLowerCase() : null;
        this.myTextDefined = this.isActive();
    }

    private String removeLineSeparators(String text) {
        return text == null ? text : NEWLINE_PATTERN.matcher(text).replaceAll(" ");
    }

    public String getFilterText() {
        return this.myFilterText;
    }

    @Override
    public boolean isIncluded(int row, PSortableTableModel model) {
        if (!this.myTextDefined) {
            return true;
        }
        String stringVal = model.getStringValueAt(row, this.myColumnIndex);
        if (stringVal != null) {
            if ("".equals(this.myLowerCaseText)) {
                return "".equals(stringVal);
            }
            stringVal = this.removeLineSeparators(stringVal);
            return this.myIsExactMatch ? stringVal.toLowerCase().equals(this.myLowerCaseText) : stringVal.toLowerCase().contains(this.myLowerCaseText);
        }
        return true;
    }

    @Override
    public boolean isActive() {
        return this.myFilterText != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(", column=");
        builder.append(this.myColumnIndex);
        builder.append(", filter text=");
        builder.append(this.myFilterText);
        return builder.toString();
    }
}

