/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.table.TristateValue;
import com.nokia.widgets.tristatecheckbox.TristateCheckBox;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class TristateCheckBoxRenderer
extends TristateCheckBox
implements TableCellRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private boolean myShowArrow = true;
    private PArrowIcon myArrowIcon = new PArrowIcon(3, 3, NetLookAndFeel.getBlack());

    public TristateCheckBoxRenderer() {
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
        this.setFocusPainted(false);
    }

    public void setShowArrow(boolean showArrow) {
        this.myShowArrow = showArrow;
    }

    public boolean isShowArrow() {
        return this.myShowArrow;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean editable = table.isCellEditable(row, column) && table.isEnabled();
        this.setEnabled(editable);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        TristateValue tristate = (TristateValue)((Object)value);
        if (tristate == null) {
            this.setPending(false);
            this.setSelected(false);
        } else if (TristateValue.ALL.equals((Object)tristate)) {
            this.setSelected(true);
            this.setPending(false);
        } else if (TristateValue.PARTIAL.equals((Object)tristate)) {
            this.setPending(true);
        } else {
            this.setPending(false);
            this.setSelected(false);
        }
        this.getModel().setRollover(ComponentUtils.isRolloveredCell(table, row, column));
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        return this;
    }

    @Override
    protected void paintComponent(Graphics arg0) {
        super.paintComponent(arg0);
        if (this.myShowArrow) {
            this.myArrowIcon.paintIcon(this, arg0, this.getWidth() / 2 + 11, this.getHeight() / 2 - this.myArrowIcon.getIconHeight() / 2);
        }
    }
}

