/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.table;

import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.TableRowFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ValueColumnFilter
implements TableRowFilter {
    private List<Object> myValues;
    private int myColumn;

    public ValueColumnFilter(int column, Object ... value) {
        this.myValues = value != null ? Arrays.asList(value) : new ArrayList<Object>();
        this.myColumn = column;
    }

    public void addValue(Object value) {
        this.myValues.add(value);
    }

    public void removeValue(Object value) {
        this.myValues.remove(value);
    }

    public void removeAllValues() {
        this.myValues.clear();
    }

    public List<Object> getValues() {
        return this.myValues;
    }

    @Override
    public boolean isIncluded(int row, PSortableTableModel model) {
        if (this.myValues == null) {
            return true;
        }
        Object value = model.getWrappedModel().getValueAt(row, this.myColumn);
        Comparator<?> comparator = model.getComparator(this.myColumn);
        for (Object filterValue : this.myValues) {
            if (comparator.compare(filterValue, value) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.myValues != null && this.myValues.size() > 0;
    }
}

