/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.search.SearchEvent;
import com.nokia.widgets.search.SearchListener;
import com.nokia.widgets.text.DropdownTextField;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractSearchTextField
extends DropdownTextField {
    private Set<SearchListener> mySearchListeners = new HashSet<SearchListener>();
    private SearchEvent mySearchEvent;
    private Timer myTimer = null;
    protected int myMaxSearchCount = 200;
    private int myAutoDelay = 400;

    public AbstractSearchTextField(Component comp) {
        super(10);
        this.mySearchEvent = new SearchEvent(comp);
        this.setSearchField(true);
        this.setClearable(true);
        this.setAutoDelay(400);
        this.setPrompt(WidgetResources.getString("Search_Text"));
        this.addActionListener(this.createSearchAction());
        this.addDocumentListener(new DocumentHandler());
    }

    public void addSearchListener(SearchListener listener) {
        if (listener != null) {
            this.mySearchListeners.add(listener);
        }
    }

    public void removeSearchListener(SearchListener listener) {
        this.mySearchListeners.remove(listener);
    }

    protected int getMaxSearchCount() {
        return this.myMaxSearchCount;
    }

    public void setAutoDelay(int delay) {
        this.myAutoDelay = delay;
        if (delay < 0) {
            this.myTimer.stop();
            this.myTimer = null;
        } else if (this.myTimer == null) {
            this.myTimer = new Timer(delay, this.createSearchAction());
            this.myTimer.setRepeats(false);
        } else {
            this.myTimer.setDelay(delay);
        }
    }

    protected void fireSearchStarted() {
        for (SearchListener listener : this.mySearchListeners) {
            listener.searchStarted(this.mySearchEvent);
        }
    }

    protected void fireSearchFinished() {
        for (SearchListener listener : this.mySearchListeners) {
            listener.searchFinished(this.mySearchEvent);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.isOnClearIcon(event.getPoint())) {
            return WidgetResources.getString("ClearSearchButton_TooltipText");
        }
        return super.getToolTipText(event);
    }

    public void setMaxSearchCount(int maxSearchCount) {
        this.myMaxSearchCount = maxSearchCount;
    }

    protected abstract ActionListener createSearchAction();

    private final class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (AbstractSearchTextField.this.getText() == null || AbstractSearchTextField.this.getText().length() == 0 || AbstractSearchTextField.this.myAutoDelay == 0) {
                AbstractSearchTextField.this.createSearchAction().actionPerformed(new ActionEvent(this, 1, ""));
            } else if (AbstractSearchTextField.this.myTimer != null) {
                AbstractSearchTextField.this.myTimer.restart();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.removeUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.removeUpdate(e);
        }
    }
}

