/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.DocumentBase;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class AlphaNumericDocument
extends DocumentBase {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    protected int myMaxChars;
    private boolean myAllowXMLEntities = false;

    public AlphaNumericDocument(int intMaxChars, boolean allowXMLEntities) {
        this.myAllowXMLEntities = allowXMLEntities;
        this.setMaxChars(intMaxChars);
    }

    public AlphaNumericDocument(int intMaxChars) {
        this.setMaxChars(intMaxChars);
    }

    public void setMaxChars(int intMaxChars) {
        this.myMaxChars = intMaxChars;
    }

    public boolean isAllowedChar(char ch) {
        if (this.myAllowXMLEntities) {
            return ch >= ' ' && ch <= '~';
        }
        return ch >= ' ' && ch <= '~' && ch != '&' && ch != '<' && ch != '>';
    }

    public void setValue(String newValue) {
        try {
            this.remove(0, this.getLength());
            if (newValue != null) {
                this.insertString(0, String.valueOf(newValue), null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getValue() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    @Override
    public final void insertString(int offs, String text, AttributeSet a) throws BadLocationException {
        StringBuffer builder;
        String total;
        String str = text;
        if (str.indexOf(LINE_SEPARATOR) > 0) {
            str = str.replaceAll(LINE_SEPARATOR, "");
        }
        if (str.indexOf(10) > 0) {
            str = str.replaceAll("\n", "");
        }
        if ((total = (builder = new StringBuffer(this.getText(0, this.getLength()))).insert(offs, str).toString()).length() > this.myMaxChars) {
            this.notifyError();
            return;
        }
        int i = 0;
        while (i < str.length()) {
            if (!this.isAllowedChar(str.charAt(i))) {
                this.notifyError();
                return;
            }
            ++i;
        }
        super.insertString(offs, str, a);
    }
}

