/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.DocumentBase;
import java.math.BigDecimal;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class DecimalDocument
extends DocumentBase {
    protected int myMaxIntDigits;
    protected int myMaxDecimDigits;
    protected double myMaxValue;
    protected double myMinValue;

    public DecimalDocument(int maxDecimDigits, double minValue, double maxValue) {
        this.myMaxValue = maxValue;
        this.myMinValue = minValue;
        this.myMaxIntDigits = this.calculateMaxIntDigits(this.myMinValue, this.myMaxValue);
        this.myMaxDecimDigits = maxDecimDigits;
    }

    public DecimalDocument(int maxDecimDigits, float minValue, float maxValue) {
        this(maxDecimDigits, Double.parseDouble(String.valueOf(minValue)), Double.parseDouble(String.valueOf(maxValue)));
    }

    protected int calculateMaxIntDigits(double minValue, double maxValue) {
        int bigger = Math.max(Math.abs((int)minValue), Math.abs((int)maxValue));
        return String.valueOf(bigger).length();
    }

    public final void setMaxDecims(int maxDecimalDigits) {
        this.myMaxDecimDigits = maxDecimalDigits;
    }

    public void setMaxValue(double maxValue) {
        double oldValue = this.myMaxValue;
        this.myMaxValue = maxValue;
        this.calculateMaxIntDigits(this.myMinValue, this.myMaxValue);
        this.mySupport.firePropertyChange("maxValue", new Double(oldValue), new Double(this.myMaxValue));
    }

    public void setMinValue(double minValue) {
        double oldValue = this.myMinValue;
        this.myMinValue = minValue;
        this.calculateMaxIntDigits(this.myMinValue, this.myMaxValue);
        this.mySupport.firePropertyChange("minValue", new Double(oldValue), new Double(this.myMinValue));
    }

    public void setMaxValue(float maxValue) {
        double dValue = Double.parseDouble(String.valueOf(maxValue));
        this.setMaxValue(dValue);
    }

    public void setMinValue(float minValue) {
        double dValue = Double.parseDouble(String.valueOf(minValue));
        this.setMinValue(dValue);
    }

    public void setValue(BigDecimal value) {
        try {
            BigDecimal newValue = value;
            this.remove(0, this.getLength());
            newValue = newValue.setScale(this.myMaxDecimDigits);
            String text = newValue.toPlainString();
            this.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setValue(double newValue) {
        try {
            this.remove(0, this.getLength());
            this.insertString(0, BigDecimal.valueOf(newValue).toPlainString(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setValue(float newValue) {
        double dValue = Double.parseDouble(String.valueOf(newValue));
        this.setValue(dValue);
    }

    public double getValue() {
        try {
            return Double.parseDouble(this.getText(0, this.getLength()));
        }
        catch (BadLocationException e) {
            throw new NumberFormatException("Parsing to double failed to BadLocationException");
        }
        catch (NumberFormatException e2) {
            throw e2;
        }
    }

    @Override
    public void insertString(int offs, String text, AttributeSet a) throws BadLocationException {
        StringBuffer builder = new StringBuffer(this.getText(0, this.getLength()));
        String str = text;
        str = this.removeLastZeroFromDecimalNumber(str).replaceAll("\\s", "");
        String total = builder.insert(offs, str).toString();
        if (this.myMaxDecimDigits <= 0 && total.contains(".")) {
            this.notifyError();
            return;
        }
        if (!total.equals("-")) {
            double doubleValue;
            if (total.startsWith("-") && this.myMinValue >= 0.0) {
                this.notifyError();
                return;
            }
            if (str.endsWith("d") || str.endsWith("f") || str.endsWith("D") || str.endsWith("F")) {
                this.notifyError();
                return;
            }
            try {
                doubleValue = Double.parseDouble(total);
            }
            catch (Exception e) {
                this.notifyError();
                return;
            }
            String[] parts = total.split("\\.");
            if (parts.length > 0 && (parts[0] == null || parts[0].length() == 0)) {
                this.notifyError();
                return;
            }
            try {
                Long.parseLong(parts[0]);
            }
            catch (Exception e) {
                this.notifyError();
                return;
            }
            if (doubleValue <= 0.0) {
                if (parts.length > 0 && parts[0] != null && (parts[0].startsWith("-") || parts[0].startsWith("+"))) {
                    parts[0] = parts[0].substring(1);
                    if (parts[0] != null && parts[0].length() == 0) {
                        parts[0] = "0";
                    }
                }
            } else if (parts.length > 0 && parts[0] != null && parts[0].startsWith("+")) {
                parts[0] = parts[0].substring(1);
                if (parts[0] != null && parts[0].length() == 0) {
                    parts[0] = "0";
                }
            }
            if (parts[0].length() > this.myMaxIntDigits || parts.length > 1 && parts[1].length() > this.myMaxDecimDigits || this.myMaxValue >= 0.0 && doubleValue > this.myMaxValue || this.myMaxValue < 0.0 && doubleValue > 0.0 || this.myMinValue <= 0.0 && doubleValue < this.myMinValue || this.myMinValue > 0.0 && doubleValue < 0.0 || Long.valueOf(parts[0]) < (long)this.myMinValue && text.contains(".")) {
                this.notifyError();
                return;
            }
        } else if (this.myMinValue >= 0.0) {
            this.notifyError();
            return;
        }
        super.insertString(offs, str, a);
    }

    protected String removeLastZeroFromDecimalNumber(String decimalNumber) {
        String[] parts;
        if (decimalNumber != null && (parts = decimalNumber.split("\\.")).length > 1 && parts[1].length() > this.myMaxDecimDigits && decimalNumber.endsWith("0")) {
            return this.removeLastZeroFromDecimalNumber(decimalNumber.substring(0, decimalNumber.length() - 1));
        }
        return decimalNumber;
    }
}

