/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.PValidationEvent;
import com.nokia.widgets.text.PValidationException;
import com.nokia.widgets.text.PValidationListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;

public class DecimalListValidator
implements PValidationListener {
    private List myValidValues;

    public DecimalListValidator(List validValues) {
        this.checkListValidity(validValues);
        this.myValidValues = validValues;
    }

    public DecimalListValidator(double[] validValues) {
        this.myValidValues = DecimalListValidator.asDoubleList(validValues);
    }

    public void setValues(List validValues) {
        this.checkListValidity(validValues);
        this.myValidValues = validValues;
    }

    public List getValues() {
        return this.myValidValues;
    }

    protected void checkListValidity(List<?> values) {
        if (values != null) {
            for (Object value : values) {
                if (value instanceof Double) continue;
                throw new IllegalArgumentException("The '" + value + "' is not instance of Double.");
            }
        }
    }

    @Override
    public void validate(PValidationEvent e) throws PValidationException {
        String strText = "";
        try {
            strText = e.getDocument().getText(0, e.getDocument().getLength());
        }
        catch (BadLocationException ble) {
            throw new PValidationException();
        }
        if (strText.trim().length() == 0) {
            return;
        }
        try {
            Double value = Double.valueOf(strText);
            if (!this.myValidValues.contains(value)) {
                throw new PValidationException();
            }
        }
        catch (NumberFormatException ex) {
            throw new PValidationException();
        }
    }

    private static List asDoubleList(double[] values) {
        ArrayList<Double> result = new ArrayList<Double>();
        int idx = 0;
        while (idx < values.length) {
            result.add(new Double(values[idx]));
            ++idx;
        }
        return result;
    }
}

